/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.migration;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.exoplatform.ecm.ProductVersions;
import org.exoplatform.services.cms.views.ApplicationTemplateManagerService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.migration.MigrationUtil;
import org.picocontainer.Startable;

public class TemplateMigrationService
implements Startable {
    RepositoryService repositoryService = null;
    ApplicationTemplateManagerService appTemplateService;
    private Log log = ExoLogger.getLogger(this.getClass());

    public TemplateMigrationService(RepositoryService repositoryService, ApplicationTemplateManagerService appTemplateService) {
        this.repositoryService = repositoryService;
        this.appTemplateService = appTemplateService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (ProductVersions.getCurrentVersionAsInt() == 212) {
            SessionProvider sessionProvider = SessionProvider.createSystemProvider();
            try {
                ManageableRepository repository = this.repositoryService.getCurrentRepository();
                Session session = sessionProvider.getSession("dms-system", repository);
                Node rootNode = session.getRootNode();
                if (rootNode.hasNode("exo:ecm/views/templates/Content List Viewer")) {
                    if (!rootNode.hasNode("exo:ecm/views/templates/content-list-viewer")) {
                        rootNode.addNode("exo:ecm/views/templates/content-list-viewer", "nt:unstructured");
                        if (this.log.isInfoEnabled()) {
                            this.log.info((Object)"CREATE :: content-list-viewer");
                        }
                        rootNode.save();
                    }
                    if (!rootNode.hasNode("exo:ecm/views/templates/content-list-viewer/paginators")) {
                        rootNode.addNode("exo:ecm/views/templates/content-list-viewer/paginators", "nt:unstructured");
                        if (this.log.isInfoEnabled()) {
                            this.log.info((Object)"CREATE :: paginators");
                        }
                        rootNode.save();
                    }
                    if (!rootNode.hasNode("exo:ecm/views/templates/content-list-viewer/list")) {
                        rootNode.addNode("exo:ecm/views/templates/content-list-viewer/list", "nt:unstructured");
                        if (this.log.isInfoEnabled()) {
                            this.log.info((Object)"CREATE :: list");
                        }
                        rootNode.save();
                    }
                    if (!rootNode.hasNode("exo:ecm/views/templates/content-list-viewer/navigation")) {
                        rootNode.addNode("exo:ecm/views/templates/content-list-viewer/navigation", "nt:unstructured");
                        if (this.log.isInfoEnabled()) {
                            this.log.info((Object)"CREATE :: navigation");
                        }
                        rootNode.save();
                    }
                    Node oldPaginatorsNode = rootNode.getNode("exo:ecm/views/templates/Content List Viewer/paginators");
                    Node newPaginatorsNode = rootNode.getNode("exo:ecm/views/templates/content-list-viewer/paginators");
                    NodeIterator oldPaginatorsNodes = oldPaginatorsNode.getNodes();
                    while (oldPaginatorsNodes.hasNext()) {
                        Node paginatorNode = oldPaginatorsNodes.nextNode();
                        if (newPaginatorsNode.hasNode(paginatorNode.getName())) continue;
                        session.getWorkspace().copy("/exo:ecm/views/templates/Content List Viewer/paginators/" + paginatorNode.getName(), "/exo:ecm/views/templates/content-list-viewer/paginators/" + paginatorNode.getName());
                        if (!this.log.isInfoEnabled()) continue;
                        this.log.info((Object)("CLONE :: " + paginatorNode.getName()));
                    }
                    session.save();
                    Node oldViewNode = rootNode.getNode("exo:ecm/views/templates/Content List Viewer/list-by-folder");
                    Node newViewListNode = rootNode.getNode("exo:ecm/views/templates/content-list-viewer/list");
                    Node newViewNavNode = rootNode.getNode("exo:ecm/views/templates/content-list-viewer/navigation");
                    NodeIterator oldViewNodes = oldViewNode.getNodes();
                    while (oldViewNodes.hasNext()) {
                        Node viewNode = oldViewNodes.nextNode();
                        if (newViewListNode.hasNode(viewNode.getName()) || newViewNavNode.hasNode(viewNode.getName())) continue;
                        Node content = viewNode.getNode("jcr:content");
                        InputStream data = content.getProperty("jcr:data").getStream();
                        String sdata = TemplateMigrationService.inputStreamAsString(data);
                        String targetFolder = "list";
                        if (sdata.contains("public void renderCategories")) {
                            targetFolder = "navigation";
                        }
                        session.getWorkspace().copy("/exo:ecm/views/templates/Content List Viewer/list-by-folder/" + viewNode.getName(), "/exo:ecm/views/templates/content-list-viewer/" + targetFolder + "/" + viewNode.getName());
                        if (!this.log.isInfoEnabled()) continue;
                        this.log.info((Object)("CLONE :: " + targetFolder + " :: " + viewNode.getName()));
                    }
                    session.save();
                    session.logout();
                    session = sessionProvider.getSession("portal-system", repository);
                    QueryManager manager = session.getWorkspace().getQueryManager();
                    String statement = "SELECT * from mop:portletpreference where mop:value LIKE '/exo:ecm/views/templates/Content List Viewer/%'";
                    Query query = manager.createQuery(statement.toString(), "sql");
                    NodeIterator nodes = query.execute().getNodes();
                    while (nodes.hasNext()) {
                        String newValue;
                        Node node = (Node)nodes.next();
                        String value = node.getProperty("mop:value").getValues()[0].getString();
                        if (value.equals(newValue = MigrationUtil.checkAndUpdateViewerTemplate(value))) continue;
                        if (this.log.isInfoEnabled()) {
                            this.log.info((Object)("CONVERT :: mop:portletpreference :: " + value + " :: " + newValue + " :: " + node.getPath()));
                        }
                        node.setProperty("mop:value", new String[]{newValue});
                        node.save();
                    }
                    if (this.log.isWarnEnabled()) {
                        this.log.warn((Object)"IMPORTANT NOTE ABOUT WCM 2.1.2 :\nAll CLV templates have been copied to a new storage place. We keep your old templates in the old structure but they won't be used anymore.\nStorage place goes from dms-system:/exo:ecm/views/templates/Content List Viewer to dms-system:/exo:ecm/views/templates/content-list-viewer\nPlease, read the WCM 2.1.2 Upgrade Notice or contact the eXo Support for more info.");
                    }
                }
            }
            catch (Exception e) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"An unexpected problem occurs when migrating templates to new structure", (Throwable)e);
                }
            }
            finally {
                sessionProvider.close();
            }
        }
    }

    public void stop() {
    }

    private static String inputStreamAsString(InputStream stream) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = br.readLine()) != null) {
            sb.append(line);
        }
        br.close();
        return sb.toString();
    }
}

