/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.category;

import javax.jcr.Node;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.portal.artifacts.RemovePortalPlugin;

public class RemoveTaxonomyPlugin
extends RemovePortalPlugin {
    private TaxonomyService taxonomyService;
    private ActionServiceContainer actionServiceContainer;
    private RepositoryService repositoryService;

    public RemoveTaxonomyPlugin(InitParams params, ConfigurationManager configurationManager, RepositoryService repositoryService, TaxonomyService taxonomyService, ActionServiceContainer actionServiceContainer) throws Exception {
        super(params, configurationManager, repositoryService);
        this.repositoryService = repositoryService;
        this.taxonomyService = taxonomyService;
        this.actionServiceContainer = actionServiceContainer;
    }

    public void invalidateFromPortal(SessionProvider sessionProvider, String portalName) throws Exception {
        String repository = this.repositoryService.getCurrentRepository().getConfiguration().getName();
        Node taxonomyTreeNode = this.taxonomyService.getTaxonomyTree(portalName, true);
        this.actionServiceContainer.removeAction(taxonomyTreeNode, repository);
        this.taxonomyService.removeTaxonomyTree(portalName);
    }
}

