/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.webui.navigation;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.exoplatform.portal.mop.Described;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.navigation.NodeChangeListener;
import org.exoplatform.portal.mop.navigation.NodeState;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.webui.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeNode
implements NodeChangeListener<UserNode> {
    private Map<String, TreeNode> caches;
    private UserNavigation nav;
    private UserNode node;
    private TreeNode rootNode;
    private boolean deleteNode = false;
    private boolean cloneNode = false;
    private String id;
    private List<TreeNode> children;
    private Map<Locale, Described.State> i18nizedLabels;

    public TreeNode(UserNavigation nav, UserNode node) {
        this(nav, node, null);
        this.rootNode = this;
        this.caches = new HashMap<String, TreeNode>();
        this.addToCached(this);
    }

    private TreeNode(UserNavigation nav, UserNode node, TreeNode rootNode) {
        this.rootNode = rootNode;
        this.nav = nav;
        this.node = node;
    }

    public List<TreeNode> getChildren() {
        if (this.children == null) {
            this.children = new LinkedList<TreeNode>();
            for (UserNode child : this.node.getChildren()) {
                String key = child.getId() == null ? String.valueOf(child.hashCode()) : child.getId();
                TreeNode node = this.findNode(key);
                if (node == null) {
                    throw new IllegalStateException("Can' find node " + child.getURI() + " in the cache");
                }
                this.children.add(node);
            }
        }
        return this.children;
    }

    public TreeNode getChild(String name) {
        UserNode child = this.node.getChild(name);
        if (child == null) {
            return null;
        }
        return this.findNode(child.getId() == null ? String.valueOf(child.hashCode()) : child.getId());
    }

    public boolean removeChild(TreeNode child) {
        this.children = null;
        if (child == null) {
            return false;
        }
        this.removeFromCached(child);
        return this.node.removeChild(child.getName());
    }

    public TreeNode getParent() {
        UserNode parent = this.node.getParent();
        if (parent == null) {
            return null;
        }
        return this.findNode(parent.getId() == null ? String.valueOf(parent.hashCode()) : parent.getId());
    }

    public TreeNode getChild(int childIndex) throws IndexOutOfBoundsException {
        UserNode child = this.node.getChild(childIndex);
        if (child == null) {
            return null;
        }
        return this.findNode(child.getId() == null ? String.valueOf(child.hashCode()) : child.getId());
    }

    public TreeNode addChild(String childName) {
        this.children = null;
        UserNode child = this.node.addChild(childName);
        return this.addToCached(new TreeNode(this.nav, child, this.rootNode));
    }

    public void addChild(TreeNode child) {
        TreeNode oldParent = child.getParent();
        if (oldParent != null) {
            oldParent.children = null;
        }
        this.children = null;
        this.node.addChild(child.getNode());
    }

    public void addChild(int index, TreeNode child) {
        TreeNode oldParent = child.getParent();
        if (oldParent != null) {
            oldParent.children = null;
        }
        this.children = null;
        this.node.addChild(index, child.getNode());
    }

    public TreeNode findNode(String nodeID) {
        return this.rootNode.caches.get(nodeID);
    }

    public UserNode getNode() {
        return this.node;
    }

    public UserNavigation getPageNavigation() {
        return this.nav;
    }

    public boolean isDeleteNode() {
        return this.deleteNode;
    }

    public void setDeleteNode(boolean deleteNode) {
        this.deleteNode = deleteNode;
    }

    public boolean isCloneNode() {
        return this.cloneNode;
    }

    public void setCloneNode(boolean b) {
        this.cloneNode = b;
    }

    public String getPageRef() {
        return this.node.getPageRef();
    }

    public String getId() {
        if (this.id == null) {
            this.id = this.node.getId() == null ? String.valueOf(this.node.hashCode()) : this.node.getId();
        }
        return this.id;
    }

    public String getURI() {
        return this.node.getURI();
    }

    public String getIcon() {
        return this.node.getIcon();
    }

    public void setIcon(String icon) {
        this.node.setIcon(icon);
    }

    public String getEncodedResolvedLabel() {
        String encodedLabel;
        if (this.getLabel() == null && this.i18nizedLabels != null) {
            Locale locale = Util.getPortalRequestContext().getLocale();
            for (Locale key : this.i18nizedLabels.keySet()) {
                if (!key.equals(locale)) continue;
                return this.i18nizedLabels.get(key).getName();
            }
        }
        return (encodedLabel = this.node.getEncodedResolvedLabel()) == null ? "" : encodedLabel;
    }

    public String getName() {
        return this.node.getName();
    }

    public void setName(String name) {
        this.node.setName(name);
    }

    public String getLabel() {
        return this.node.getLabel();
    }

    public void setLabel(String label) {
        this.node.setLabel(label);
    }

    public Visibility getVisibility() {
        return this.node.getVisibility();
    }

    public void setVisibility(Visibility visibility) {
        this.node.setVisibility(visibility);
    }

    public long getStartPublicationTime() {
        return this.node.getStartPublicationTime();
    }

    public void setStartPublicationTime(long startPublicationTime) {
        this.node.setStartPublicationTime(startPublicationTime);
    }

    public long getEndPublicationTime() {
        return this.node.getEndPublicationTime();
    }

    public void setEndPublicationTime(long endPublicationTime) {
        this.node.setEndPublicationTime(endPublicationTime);
    }

    public void setPageRef(String pageRef) {
        this.node.setPageRef(pageRef);
    }

    public String getResolvedLabel() {
        String resolvedLabel = this.node.getResolvedLabel();
        return resolvedLabel == null ? "" : resolvedLabel;
    }

    public boolean hasChildrenRelationship() {
        return this.node.hasChildrenRelationship();
    }

    public int getChildrenCount() {
        return this.node.getChildrenCount();
    }

    private TreeNode addToCached(TreeNode node) {
        if (node == null) {
            return null;
        }
        if (this.findNode(node.getId()) != null) {
            return node;
        }
        this.rootNode.caches.put(node.getId(), node);
        for (UserNode child : node.getNode().getChildren()) {
            this.addToCached(new TreeNode(this.nav, child, this.rootNode));
        }
        return node;
    }

    private TreeNode removeFromCached(TreeNode node) {
        if (node == null) {
            return null;
        }
        this.rootNode.caches.remove(node.getId());
        if (node.hasChildrenRelationship()) {
            for (TreeNode child : node.getChildren()) {
                this.removeFromCached(child);
            }
        }
        return node;
    }

    public void onAdd(UserNode target, UserNode parent, UserNode previous) {
        this.addToCached(new TreeNode(this.nav, target, this.rootNode));
        this.findNode((String)parent.getId()).children = null;
    }

    public void onCreate(UserNode target, UserNode parent, UserNode previous, String name) {
    }

    public void onRemove(UserNode target, UserNode parent) {
        this.removeFromCached(this.findNode(target.getId()));
        this.findNode((String)parent.getId()).children = null;
    }

    public void onDestroy(UserNode target, UserNode parent) {
    }

    public void onRename(UserNode target, UserNode parent, String name) {
    }

    public void onUpdate(UserNode target, NodeState state) {
    }

    public void onMove(UserNode target, UserNode from, UserNode to, UserNode previous) {
        TreeNode fromTreeNode = this.findNode(from.getId());
        TreeNode toTreeNode = this.findNode(to.getId());
        fromTreeNode.children = null;
        toTreeNode.children = null;
    }

    public void setI18nizedLabels(Map<Locale, Described.State> labels) {
        this.i18nizedLabels = labels;
    }

    public Map<Locale, Described.State> getI18nizedLabels() {
        return this.i18nizedLabels;
    }
}

