/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer.xhtml;

import java.util.Map;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.internal.renderer.ParametersPrinter;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.renderer.reference.ResourceReferenceSerializer;

@Component(value="xhtmlmarker")
public class XHTMLMarkerResourceReferenceSerializer
implements ResourceReferenceSerializer {
    private static final String COMMENT_SEPARATOR = "|-|";
    private ParametersPrinter parametersPrinter = new ParametersPrinter();

    public String serialize(ResourceReference reference) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(reference.isTyped());
        buffer.append(COMMENT_SEPARATOR);
        buffer.append(reference.getType().getScheme());
        buffer.append(COMMENT_SEPARATOR);
        buffer.append(reference.getReference());
        Map<String, String> linkReferenceParameters = reference.getParameters();
        if (!linkReferenceParameters.isEmpty()) {
            buffer.append(COMMENT_SEPARATOR);
            buffer.append(this.parametersPrinter.print(linkReferenceParameters, '\\'));
        }
        return buffer.toString();
    }
}

