/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer.xhtml.link;

import java.util.Map;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.internal.renderer.xhtml.link.XHTMLLinkRenderer;
import org.xwiki.rendering.internal.renderer.xhtml.link.XHTMLLinkTypeRenderer;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.renderer.printer.XHTMLWikiPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class DefaultXHTMLLinkRenderer
implements XHTMLLinkRenderer {
    @Requirement
    private XHTMLLinkTypeRenderer defaultLinkTypeRenderer;
    @Requirement
    protected ComponentManager componentManager;
    private XHTMLWikiPrinter xhtmlPrinter;
    private boolean hasLabel;

    @Override
    public void setHasLabel(boolean hasLabel) {
        this.hasLabel = hasLabel;
    }

    @Override
    public void setXHTMLWikiPrinter(XHTMLWikiPrinter printer) {
        this.xhtmlPrinter = printer;
    }

    @Override
    public XHTMLWikiPrinter getXHTMLWikiPrinter() {
        return this.xhtmlPrinter;
    }

    @Override
    public void beginLink(ResourceReference reference, boolean isFreeStandingURI, Map<String, String> parameters) {
        this.getXHTMLLinkTypeRenderer(reference).beginLink(reference, isFreeStandingURI, parameters);
    }

    @Override
    public void endLink(ResourceReference reference, boolean isFreeStandingURI, Map<String, String> parameters) {
        this.getXHTMLLinkTypeRenderer(reference).endLink(reference, isFreeStandingURI, parameters);
    }

    private XHTMLLinkTypeRenderer getXHTMLLinkTypeRenderer(ResourceReference reference) {
        XHTMLLinkTypeRenderer renderer;
        try {
            renderer = (XHTMLLinkTypeRenderer)this.componentManager.lookup(XHTMLLinkTypeRenderer.class, reference.getType().getScheme());
        }
        catch (ComponentLookupException e) {
            renderer = this.defaultLinkTypeRenderer;
        }
        renderer.setHasLabel(this.hasLabel);
        renderer.setXHTMLWikiPrinter(this.getXHTMLWikiPrinter());
        return renderer;
    }
}

