/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.listener.reference;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.xwiki.rendering.listener.reference.ResourceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceReference
implements Cloneable {
    private boolean isTyped = true;
    private String reference;
    private ResourceType type;
    private Map<String, String> parameters = new HashMap<String, String>();

    public ResourceReference(String reference, ResourceType type) {
        this.setReference(reference);
        this.setType(type);
    }

    public void setTyped(boolean isTyped) {
        this.isTyped = isTyped;
    }

    public boolean isTyped() {
        return this.isTyped;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getReference() {
        return this.reference;
    }

    public ResourceType getType() {
        return this.type;
    }

    public void setType(ResourceType type) {
        this.type = type;
    }

    public void setParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters.putAll(parameters);
    }

    public void removeParameter(String name) {
        this.parameters.remove(name);
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public String toString() {
        Map<String, String> params;
        StringBuffer sb = new StringBuffer();
        sb.append("Typed = [").append(this.isTyped()).append("]");
        sb.append(" ");
        sb.append("Type = [").append(this.getType().getScheme()).append("]");
        if (this.getReference() != null) {
            sb.append(" ");
            sb.append("Reference = [").append(this.getReference()).append("]");
        }
        if (!(params = this.getParameters()).isEmpty()) {
            sb.append(" ");
            sb.append("Parameters = [");
            Iterator<Map.Entry<String, String>> it = params.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, String> entry = it.next();
                sb.append("[").append(entry.getKey()).append("] = [").append(entry.getValue()).append("]");
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        return sb.toString();
    }

    public ResourceReference clone() {
        ResourceReference clone;
        try {
            clone = (ResourceReference)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Failed to clone object", e);
        }
        return clone;
    }

    public int hashCode() {
        return new HashCodeBuilder(1, 9).append((Object)this.getType()).append(this.isTyped()).append((Object)this.getReference()).append(this.getParameters()).toHashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        ResourceReference rhs = (ResourceReference)object;
        return new EqualsBuilder().append((Object)this.getType(), (Object)rhs.getType()).append(this.isTyped(), rhs.isTyped()).append((Object)this.getReference(), (Object)rhs.getReference()).append(this.getParameters(), rhs.getParameters()).isEquals();
    }
}

