/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.mop.core.api.workspace;

import org.chromattic.api.annotations.Create;
import org.chromattic.api.annotations.MappedBy;
import org.chromattic.api.annotations.OneToOne;
import org.chromattic.api.annotations.Owner;
import org.chromattic.api.annotations.PrimaryType;
import org.gatein.mop.api.content.ContentType;
import org.gatein.mop.api.content.Customization;
import org.gatein.mop.api.content.CustomizationContext;
import org.gatein.mop.api.workspace.ObjectType;
import org.gatein.mop.api.workspace.ui.UIWindow;
import org.gatein.mop.core.api.workspace.UIComponentImpl;
import org.gatein.mop.core.api.workspace.content.WorkspaceClone;
import org.gatein.mop.core.api.workspace.content.WorkspaceCustomization;
import org.gatein.mop.core.api.workspace.content.WorkspaceSpecialization;

@PrimaryType(name="mop:uiwindow")
public abstract class UIWindowImpl
extends UIComponentImpl
implements UIWindow,
CustomizationContext {
    public ObjectType<? extends UIWindow> getObjectType() {
        return ObjectType.WINDOW;
    }

    @OneToOne
    @MappedBy(value="mop:customization")
    @Owner
    public abstract WorkspaceCustomization getCustomization();

    public abstract void setCustomization(WorkspaceCustomization var1);

    @Create
    public abstract WorkspaceClone create();

    @Create
    public abstract WorkspaceSpecialization create2();

    public <S> Customization<S> customize(ContentType<S> contentType, String contentId, S state) {
        if (this.getCustomization() != null) {
            throw new IllegalStateException("Already customized");
        }
        WorkspaceClone customization = this.create();
        this.setCustomization(customization);
        customization.setMimeType(contentType.getMimeType());
        customization.setContentId(contentId);
        customization.setState(state);
        return customization;
    }

    public <S> Customization<S> customize(Customization<S> customization) {
        if (customization == null) {
            throw new NullPointerException();
        }
        if (customization instanceof WorkspaceCustomization) {
            if (this.getCustomization() != null) {
                throw new IllegalStateException("Already customized");
            }
            WorkspaceCustomization parentCustomization = (WorkspaceCustomization)customization;
            WorkspaceSpecialization specialization = this.create2();
            this.setCustomization(specialization);
            specialization.setMimeType(parentCustomization.getMimeType());
            specialization.setContentId(parentCustomization.getContentId());
            specialization.setCustomization(parentCustomization);
            return specialization;
        }
        throw new IllegalArgumentException("implement customization of " + customization);
    }

    public String getContextType() {
        return "workspace";
    }

    public String getContextId() {
        return this.getObjectId();
    }

    public boolean contains(CustomizationContext that) {
        return UIWindowImpl.contains(this, that);
    }
}

