/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.security.j2ee;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.security.auth.login.LoginException;
import org.exoplatform.container.monitor.jvm.J2EEServerInfo;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.jaas.DefaultLoginModule;
import org.exoplatform.services.security.jaas.JAASGroup;
import org.exoplatform.services.security.jaas.RolePrincipal;
import org.exoplatform.services.security.jaas.UserPrincipal;

public class JbossLoginModule
extends DefaultLoginModule {
    protected static Log log = ExoLogger.getLogger((String)"exo.core.component.security.core.JbossLoginModule.class");

    public boolean commit() throws LoginException {
        if (super.commit()) {
            Set<Principal> principals = this.subject.getPrincipals();
            JAASGroup roleGroup = new JAASGroup("Roles");
            for (String role : this.identity.getRoles()) {
                roleGroup.addMember(new RolePrincipal(role));
            }
            principals.add((Principal)((Object)roleGroup));
            principals.add(new UserPrincipal(this.identity.getUserId()));
            return true;
        }
        return false;
    }

    public boolean logout() throws LoginException {
        block9: {
            J2EEServerInfo info = new J2EEServerInfo();
            MBeanServer jbossServer = info.getMBeanServer();
            if (jbossServer != null) {
                try {
                    log.debug((Object)"Performing JBoss security manager cache eviction");
                    ObjectName securityManagerName = new ObjectName("jboss.security:service=JaasSecurityManager");
                    String userName = null;
                    Set<UserPrincipal> userPrincipals = this.subject.getPrincipals(UserPrincipal.class);
                    if (!userPrincipals.isEmpty()) {
                        userName = userPrincipals.iterator().next().getName();
                    }
                    if (userName != null) {
                        log.debug((Object)("Going to perform JBoss security manager cache eviction for user " + userName));
                        ArrayList allPrincipals = (ArrayList)jbossServer.invoke(securityManagerName, "getAuthenticationCachePrincipals", new Object[]{this.realmName}, new String[]{String.class.getName()});
                        allPrincipals = new ArrayList(allPrincipals);
                        Principal key = null;
                        for (Principal principal : allPrincipals) {
                            if (!principal.getName().equals(userName)) continue;
                            key = principal;
                            break;
                        }
                        if (key != null) {
                            jbossServer.invoke(securityManagerName, "flushAuthenticationCache", new Object[]{this.realmName, key}, new String[]{String.class.getName(), Principal.class.getName()});
                            log.debug((Object)("Performed JBoss security manager cache eviction for user " + userName + " with principal " + key));
                        } else {
                            log.debug((Object)("No principal found when performing JBoss security manager cache eviction for user " + userName));
                        }
                        break block9;
                    }
                    log.warn((Object)"No user name found when performing JBoss security manager cache eviction");
                }
                catch (Exception e) {
                    log.error((Object)"Could not perform JBoss security manager cache eviction", (Throwable)e);
                }
            } else {
                log.debug((Object)"Could not find mbean server for performing JBoss security manager cache eviction");
            }
        }
        return true;
    }
}

