/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.security.jaas;

import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.spi.LoginModule;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.log.Log;

public abstract class AbstractLoginModule
implements LoginModule {
    private static final String OPTION_PORTAL_CONTAINER_NAME = "portalContainerName";
    private static final String OPTION_REALM_NAME = "realmName";
    private String portalContainerName;
    protected String realmName;
    protected Subject subject;
    protected CallbackHandler callbackHandler;
    protected Map sharedState;
    protected Map options;

    public final void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        this.portalContainerName = this.getPortalContainerName(options);
        this.realmName = this.getRealmName(options);
        this.afterInitialize();
    }

    protected void afterInitialize() {
    }

    protected ExoContainer getContainer() throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        if (container instanceof RootContainer) {
            container = RootContainer.getInstance().getPortalContainer(this.portalContainerName);
            if (container == null) {
                throw new Exception("The eXo container is null, because the current container is a RootContainer and there is no PortalContainer with the name '" + this.portalContainerName + "'.");
            }
        } else if (container == null) {
            throw new Exception("The eXo container is null, because the current container is null.");
        }
        return container;
    }

    private String getPortalContainerName(Map options) {
        String optionValue;
        if (options != null && (optionValue = (String)options.get(OPTION_PORTAL_CONTAINER_NAME)) != null && optionValue.length() > 0) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("The " + this.getClass() + " will use the portal container " + optionValue));
            }
            return optionValue;
        }
        return PortalContainer.DEFAULT_PORTAL_CONTAINER_NAME;
    }

    private String getRealmName(Map options) {
        String optionValue;
        if (options != null && (optionValue = (String)options.get(OPTION_REALM_NAME)) != null && optionValue.length() > 0) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("The " + this.getClass() + " will use the realm " + optionValue));
            }
            return optionValue;
        }
        return PortalContainer.DEFAULT_REALM_NAME;
    }

    protected abstract Log getLogger();
}

