/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.upgrade.plugins;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.ArrayList;
import org.exoplatform.application.gadget.LocalImporter;
import org.exoplatform.application.gadget.impl.GadgetRegistry;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.gatein.common.io.IOTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalGadgetImporter
extends LocalImporter {
    private ConfigurationManager configurationManager;
    private PortalContainer container;
    private String gadgetPath;
    private String gadgetRootAbsolutePath;

    public LocalGadgetImporter(String name, GadgetRegistry registry, String gadgetPath, ConfigurationManager configurationManager, PortalContainer container) {
        super(name, registry, gadgetPath, true);
        this.configurationManager = configurationManager;
        this.container = container;
        this.gadgetPath = gadgetPath;
        if (gadgetPath.startsWith("war:")) {
            gadgetPath = gadgetPath.replace("war:", "");
            this.gadgetRootAbsolutePath = container.getPortalContext().getRealPath(gadgetPath);
            this.gadgetRootAbsolutePath = this.gadgetRootAbsolutePath.replace("\\", "/");
            int gadgetRootPathIndex = this.gadgetRootAbsolutePath.lastIndexOf(gadgetPath);
            this.gadgetRootAbsolutePath = this.gadgetRootAbsolutePath.substring(0, gadgetRootPathIndex);
        }
    }

    public String getName(String resourcePath) {
        if ((resourcePath = resourcePath.replace("\\", "/")).endsWith("/")) {
            resourcePath = resourcePath.substring(0, resourcePath.length() - 1);
        }
        int index = resourcePath.lastIndexOf(47);
        return resourcePath.substring(index + 1);
    }

    public String getParent(String resourcePath) throws IOException {
        String separator = this.getUsedSeparator(resourcePath);
        separator = resourcePath.indexOf("\\") >= 0 ? "\\" : "/";
        if (resourcePath.endsWith(separator)) {
            resourcePath = resourcePath.substring(0, resourcePath.length() - 1);
        }
        int index = resourcePath.lastIndexOf(separator);
        return resourcePath.substring(0, index + 1);
    }

    public String getRealPath(String resourcePath) throws Exception {
        if (!(resourcePath.startsWith("war:") || resourcePath.startsWith("classpath:") || resourcePath.startsWith("jar:"))) {
            File file = new File(resourcePath);
            return file.getAbsolutePath();
        }
        if (resourcePath.startsWith("war:")) {
            if (!resourcePath.equals(this.gadgetPath)) {
                resourcePath = resourcePath.replace("war:", "");
                return this.gadgetRootAbsolutePath + resourcePath;
            }
            File file = new File(this.container.getPortalContext().getRealPath(resourcePath));
            return file.getAbsolutePath();
        }
        File file = new File(this.configurationManager.getURL(resourcePath).getPath());
        return file.getAbsolutePath();
    }

    public byte[] getContent(String filePath) throws IOException {
        InputStream in;
        try {
            if (!(filePath.startsWith("classpath:") || filePath.startsWith("jar:") || filePath.startsWith("war:") || filePath.startsWith("system:"))) {
                filePath = filePath.startsWith("") ? "file:" + filePath : "file:/" + filePath;
            }
            if (filePath.startsWith("war:")) {
                filePath = filePath.replace("war:", "");
                in = this.container.getPortalContext().getResourceAsStream(filePath);
            } else {
                in = this.configurationManager.getInputStream(filePath);
            }
        }
        catch (Exception exception) {
            return null;
        }
        if (in == null) {
            return null;
        }
        return IOTools.getBytes((InputStream)in);
    }

    private String getUsedSeparator(String filePath) {
        String separator = null;
        separator = filePath.indexOf("\\") >= 0 ? "\\" : "/";
        return separator;
    }

    public Iterable<String> getChildren(String folderPath) throws IOException {
        try {
            String absoluteFolderPath = this.getRealPath(folderPath);
            File file = new File(absoluteFolderPath);
            File[] children = file.listFiles();
            ArrayList<String> childList = new ArrayList<String>();
            if (!folderPath.endsWith("/") && !folderPath.endsWith("\\")) {
                folderPath = folderPath + this.getUsedSeparator(folderPath);
            }
            for (File fileChild : children) {
                childList.add(folderPath + fileChild.getName());
            }
            return childList;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public boolean isFile(String resourcePath) {
        Boolean isFile = null;
        try {
            File file = new File(this.getRealPath(resourcePath));
            if (file.exists()) {
                isFile = file.isFile();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (isFile == null) {
            return !resourcePath.endsWith("/") && !resourcePath.endsWith("\\");
        }
        return isFile;
    }

    public String getMimeType(String fileName) {
        String mimeType = URLConnection.guessContentTypeFromName(fileName);
        if (mimeType == null) {
            mimeType = this.container.getPortalContext().getMimeType(fileName);
        }
        return mimeType;
    }
}

