/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.common.rest;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import org.exoplatform.commons.info.ProductInformations;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/platform/version")
public class PlatformInformationRESTService
implements ResourceContainer {
    private Log logger = ExoLogger.getLogger(this.getClass());
    private ProductInformations platformInformations;

    public PlatformInformationRESTService(ProductInformations productInformations) {
        this.platformInformations = productInformations;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getPlatformInformation() {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        try {
            JsonPlatformInfo jsonPlatformInfo = new JsonPlatformInfo();
            jsonPlatformInfo.setPlatformVersion(this.platformInformations.getVersion());
            jsonPlatformInfo.setPlatformBuildNumber(this.platformInformations.getBuildNumber());
            jsonPlatformInfo.setPlatformRevision(this.platformInformations.getRevision());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Getting Platform Informations: eXo Platform (v" + this.platformInformations.getVersion() + " - build " + this.platformInformations.getBuildNumber() + " - rev. " + this.platformInformations.getRevision()));
            }
            return Response.ok((Object)jsonPlatformInfo, (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"HTTP Status-Code 500: Internal Server Error. ");
            }
            return Response.status((int)500).cacheControl(cacheControl).build();
        }
    }

    public static class JsonPlatformInfo {
        private String platformVersion;
        private String platformBuildNumber;
        private String platformRevision;

        public String getPlatformVersion() {
            return this.platformVersion;
        }

        public void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        public String getPlatformBuildNumber() {
            return this.platformBuildNumber;
        }

        public void setPlatformBuildNumber(String platformBuildNumber) {
            this.platformBuildNumber = platformBuildNumber;
        }

        public String getPlatformRevision() {
            return this.platformRevision;
        }

        public void setPlatformRevision(String platformRevision) {
            this.platformRevision = platformRevision;
        }
    }
}

