/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.rightclick.manager;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotInTrashFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotTrashHomeNodeFilter;
import org.exoplatform.ecm.webui.component.explorer.control.listener.UIWorkingAreaActionListener;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.webui.ext.manager.UIAbstractManager;
import org.exoplatform.webui.ext.manager.UIAbstractManagerComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(events={@EventConfig(listeners={CreateLinkActionListener.class})})
public class CreateLinkManageComponent
extends UIAbstractManagerComponent {
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new IsNotInTrashFilter(), new IsNotTrashHomeNodeFilter()});
    private static final Log LOG = ExoLogger.getLogger(CreateLinkManageComponent.class);
    private static final String EXO_TRASH_FOLDER = "exo:trashFolder";

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    private static void createMultiLink(String[] srcPaths, Node destNode, Event<? extends UIComponent> event) throws Exception {
        for (int i = 0; i < srcPaths.length; ++i) {
            CreateLinkManageComponent.createLink(srcPaths[i], destNode, event);
        }
    }

    private static void createLink(String srcPath, Node destNode, Event<? extends UIComponent> event) throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)((UIComponent)event.getSource()).getAncestorOfType(UIJCRExplorer.class);
        Matcher matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(srcPath);
        String wsName = null;
        if (!matcher.find()) {
            throw new IllegalArgumentException("The ObjectId is invalid '" + srcPath + "'");
        }
        wsName = matcher.group(1);
        srcPath = matcher.group(2);
        Session session = uiExplorer.getSessionByWorkspace(wsName);
        Node selectedNode = uiExplorer.getNodeByPath(srcPath, session, false);
        if (selectedNode.isNodeType(EXO_TRASH_FOLDER)) {
            return;
        }
        UIApplication uiApp = (UIApplication)((UIComponent)event.getSource()).getAncestorOfType(UIApplication.class);
        LinkManager linkManager = (LinkManager)((UIComponent)event.getSource()).getApplicationComponent(LinkManager.class);
        if (linkManager.isLink((Item)destNode)) {
            Object[] args = new Object[]{destNode.getPath()};
            uiApp.addMessage(new ApplicationMessage("UIWorkingArea.msg.dest-node-is-link", args, 1));
            return;
        }
        if (linkManager.isLink((Item)selectedNode)) {
            Object[] args = new Object[]{srcPath};
            uiApp.addMessage(new ApplicationMessage("UIWorkingArea.msg.selected-is-link", args, 1));
            return;
        }
        try {
            linkManager.createLink(destNode, "exo:symlink", selectedNode, selectedNode.getName() + ".lnk");
        }
        catch (Exception e) {
            Object[] args = new Object[]{Text.unescapeIllegalJcrChars((String)srcPath), Text.unescapeIllegalJcrChars((String)destNode.getPath())};
            uiApp.addMessage(new ApplicationMessage("UIWorkingArea.msg.create-link-problem", args, 1));
            return;
        }
    }

    private static void createLinkManager(Event<? extends UIComponent> event) throws Exception {
        String nodePath = event.getRequestContext().getRequestParameter("objectId");
        String destPath = event.getRequestContext().getRequestParameter("destInfo");
        CreateLinkManageComponent.processMultipleSelection(nodePath.trim(), destPath.trim(), event);
    }

    private static void processMultipleSelection(String nodePath, String destPath, Event<? extends UIComponent> event) throws Exception {
        Node destNode;
        UIJCRExplorer uiExplorer = (UIJCRExplorer)((UIComponent)event.getSource()).getAncestorOfType(UIJCRExplorer.class);
        Matcher matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(destPath);
        String wsName = null;
        if (!matcher.find()) {
            throw new IllegalArgumentException("The ObjectId is invalid '" + destPath + "'");
        }
        wsName = matcher.group(1);
        destPath = matcher.group(2);
        Session session = uiExplorer.getSessionByWorkspace(wsName);
        UIApplication uiApp = (UIApplication)((UIComponent)event.getSource()).getAncestorOfType(UIApplication.class);
        if (destPath.startsWith(nodePath)) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.bound-move-exception", null, 1));
            return;
        }
        try {
            destNode = uiExplorer.getNodeByPath(destPath, session);
            destPath = destNode.getPath();
            session = destNode.getSession();
        }
        catch (PathNotFoundException path) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.path-not-found-exception", null, 1));
            return;
        }
        catch (Exception e) {
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            return;
        }
        if (!PermissionUtil.canAddNode((Node)destNode)) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.can-not-move-node", null, 1));
            uiExplorer.updateAjax(event);
            return;
        }
        if (uiExplorer.nodeIsLocked(destNode)) {
            Object[] arg = new Object[]{destPath};
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.node-locked", arg, 1));
            return;
        }
        if (!destNode.isCheckedOut()) {
            uiApp.addMessage(new ApplicationMessage("UIActionBar.msg.node-checkedin", null));
            return;
        }
        try {
            if (nodePath.indexOf(";") > -1) {
                CreateLinkManageComponent.createMultiLink(nodePath.split(";"), destNode, event);
            } else {
                CreateLinkManageComponent.createLink(nodePath, destNode, event);
            }
            session.save();
            uiExplorer.updateAjax(event);
        }
        catch (AccessDeniedException ace) {
            Object[] arg = new Object[]{destPath};
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.has-not-add-permission", arg, 1));
            return;
        }
        catch (LockException lock) {
            Object[] arg = new Object[]{nodePath};
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.node-locked", arg, 1));
            return;
        }
        catch (ConstraintViolationException constraint) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.move-constraint-exception", null, 1));
            return;
        }
        catch (Exception e) {
            LOG.error((Object)"an unexpected error occurs while selecting the node", (Throwable)e);
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            return;
        }
    }

    public Class<? extends UIAbstractManager> getUIAbstractManagerClass() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreateLinkActionListener
    extends UIWorkingAreaActionListener<CreateLinkManageComponent> {
        public void processEvent(Event<CreateLinkManageComponent> event) throws Exception {
            CreateLinkManageComponent.createLinkManager((Event<? extends UIComponent>)event);
        }
    }
}

