/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.versions;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.control.UIActionBar;
import org.exoplatform.ecm.webui.component.explorer.versions.UINodeInfo;
import org.exoplatform.ecm.webui.component.explorer.versions.UINodeProperty;
import org.exoplatform.ecm.webui.presentation.AbstractActionComponent;
import org.exoplatform.ecm.webui.presentation.NodePresentation;
import org.exoplatform.ecm.webui.presentation.removeattach.RemoveAttachmentComponent;
import org.exoplatform.ecm.webui.presentation.removecomment.RemoveCommentComponent;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.comments.CommentsService;
import org.exoplatform.services.cms.i18n.MultiLanguageService;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.Parameter;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.ext.UIExtension;
import org.exoplatform.webui.ext.UIExtensionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(type=UIViewVersion.class, template="system:/groovy/webui/core/UITabPane.gtmpl", events={@EventConfig(listeners={ChangeLanguageActionListener.class}), @EventConfig(listeners={ChangeNodeActionListener.class}), @EventConfig(listeners={DownloadActionListener.class})})
public class UIViewVersion
extends UIContainer
implements NodePresentation {
    private NodeLocation node_;
    protected NodeLocation originalNode_;
    private String language_;
    private static final Log LOG = ExoLogger.getLogger((String)"explorer.UIViewVersion");
    private static final String COMMENT_COMPONENT = "Comment".intern();

    public UIViewVersion() throws Exception {
        this.addChild(UINodeInfo.class, null, null);
        ((UINodeProperty)this.addChild(UINodeProperty.class, null, null)).setRendered(false);
    }

    public String getTemplate() {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        String userName = Util.getPortalRequestContext().getRemoteUser();
        try {
            Node node = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentNode();
            this.originalNode_ = NodeLocation.getNodeLocationByNode((Node)node);
            String nodeType = node.getPrimaryNodeType().getName();
            if (this.isNodeTypeSupported(node)) {
                return templateService.getTemplatePathByUser(false, nodeType, userName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public UIComponent getCommentComponent() {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        UIActionBar uiActionBar = (UIActionBar)uiExplorer.findFirstComponentOfType(UIActionBar.class);
        UIComponent uicomponent = uiActionBar.getUIAction(COMMENT_COMPONENT);
        return uicomponent != null ? uicomponent : this;
    }

    public UIComponent getRemoveAttach() throws Exception {
        this.removeChild(RemoveAttachmentComponent.class);
        UIComponent uicomponent = this.addChild(RemoveAttachmentComponent.class, null, "UIViewVersionRemoveAttach");
        ((AbstractActionComponent)uicomponent).setLstComponentupdate(Arrays.asList(UIPopupWindow.class));
        return uicomponent;
    }

    public UIComponent getRemoveComment() throws Exception {
        this.removeChild(RemoveCommentComponent.class);
        UIComponent uicomponent = this.addChild(RemoveCommentComponent.class, null, "UIViewVersionRemoveComment");
        ((AbstractActionComponent)uicomponent).setLstComponentupdate(Arrays.asList(UIPopupWindow.class));
        return uicomponent;
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getJCRTemplateResourceResolver();
    }

    public boolean isNodeTypeSupported(Node node) {
        try {
            TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
            String nodeTypeName = node.getPrimaryNodeType().getName();
            return templateService.isManagedNodeType(nodeTypeName);
        }
        catch (Exception e) {
            return false;
        }
    }

    public Node getNode() throws RepositoryException {
        return NodeLocation.getNodeByLocation((NodeLocation)this.node_);
    }

    public Node getOriginalNode() throws Exception {
        return NodeLocation.getNodeByLocation((NodeLocation)this.originalNode_);
    }

    public void setNode(Node node) {
        this.node_ = NodeLocation.getNodeLocationByNode((Node)node);
    }

    public Node getNodeByUUID(String uuid) throws Exception {
        String[] workspaces;
        ManageableRepository manageRepo = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getCurrentRepository();
        for (String ws : workspaces = manageRepo.getWorkspaceNames()) {
            try {
                return WCMCoreUtils.getSystemSessionProvider().getSession(ws, manageRepo).getNodeByUUID(uuid);
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    public List<Node> getRelations() throws Exception {
        ArrayList<Node> relations = new ArrayList<Node>();
        Node node = this.getNode();
        if (node.hasProperty("exo:relation")) {
            Value[] vals = node.getProperty("exo:relation").getValues();
            for (int i = 0; i < vals.length; ++i) {
                String uuid = vals[i].getString();
                Node nodeToAdd = this.getNodeByUUID(uuid);
                relations.add(nodeToAdd);
            }
        }
        return relations;
    }

    public List<Node> getAttachments() throws Exception {
        ArrayList<Node> attachments = new ArrayList<Node>();
        Node node = this.getNode();
        NodeIterator childrenIterator = node.getNodes();
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        int attachData = 0;
        while (childrenIterator.hasNext()) {
            Node childNode = childrenIterator.nextNode();
            String nodeType = childNode.getPrimaryNodeType().getName();
            List listCanCreateNodeType = Utils.getListAllowedFileType((Node)node, (TemplateService)templateService);
            if (!listCanCreateNodeType.contains(nodeType)) continue;
            if (childNode.hasProperty("jcr:data")) {
                attachData = childNode.getProperty("jcr:data").getStream().available();
                if (attachData <= 0) continue;
                attachments.add(childNode);
                continue;
            }
            attachments.add(childNode);
        }
        return attachments;
    }

    @Deprecated
    public String getAttachmentURL(Node attNode, Parameter[] params) throws Exception {
        return this.getViewableLink(attNode, params);
    }

    public String getViewableLink(Node attNode, Parameter[] params) throws Exception {
        return this.event("ChangeNode", Utils.formatNodeName((String)attNode.getPath()), params);
    }

    public String getIcons(Node node, String type) throws Exception {
        return Utils.getNodeTypeIcon((Node)node, (String)type);
    }

    public boolean hasPropertyContent(Node node, String property) {
        try {
            String value = node.getProperty(property).getString();
            if (value.length() > 0) {
                return true;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected error", (Throwable)e);
        }
        return false;
    }

    public boolean isRssLink() {
        return false;
    }

    public String getRssLink() {
        return null;
    }

    public void update() throws Exception {
        ((UINodeInfo)this.getChild(UINodeInfo.class)).update();
    }

    public List<Node> getComments() throws Exception {
        return ((CommentsService)this.getApplicationComponent(CommentsService.class)).getComments(this.getNode(), this.getLanguage());
    }

    public Object getComponentInstanceOfType(String className) {
        Object service = null;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> object = loader.loadClass(className);
            service = this.getApplicationComponent(object);
        }
        catch (ClassNotFoundException ex) {
            LOG.error((Object)"Unexpected error", (Throwable)ex);
        }
        return service;
    }

    public String getDownloadLink(Node node) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        if (!node.getPrimaryNodeType().getName().equals("nt:file")) {
            node = NodeLocation.getNodeByLocation((NodeLocation)this.originalNode_);
        }
        Node jcrContentNode = node.getNode("jcr:content");
        InputStream input = jcrContentNode.getProperty("jcr:data").getStream();
        InputStreamDownloadResource dresource = new InputStreamDownloadResource(input, "image");
        dresource.setDownloadName(node.getName());
        return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
    }

    public String getImage(Node node) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        Node imageNode = node.getNode("exo:image");
        InputStream input = imageNode.getProperty("jcr:data").getStream();
        InputStreamDownloadResource dresource = new InputStreamDownloadResource(input, "image");
        dresource.setDownloadName(node.getName());
        return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
    }

    public void setLanguage(String language) {
        this.language_ = language;
    }

    public String getLanguage() {
        return this.language_;
    }

    public String getNodeType() throws Exception {
        return this.getNode().getPrimaryNodeType().getName();
    }

    public String getPortalName() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        PortalContainerInfo containerInfo = (PortalContainerInfo)container.getComponentInstanceOfType(PortalContainerInfo.class);
        return containerInfo.getContainerName();
    }

    public List<String> getSupportedLocalise() throws Exception {
        MultiLanguageService multiLanguageService = (MultiLanguageService)this.getApplicationComponent(MultiLanguageService.class);
        return multiLanguageService.getSupportedLanguages(this.getNode());
    }

    public String getTemplatePath() throws Exception {
        return null;
    }

    public String getViewTemplate(String nodeTypeName, String templateName) throws Exception {
        TemplateService tempServ = (TemplateService)this.getApplicationComponent(TemplateService.class);
        return tempServ.getTemplatePath(false, nodeTypeName, templateName);
    }

    public String getTemplateSkin(String nodeTypeName, String skinName) throws Exception {
        TemplateService tempServ = (TemplateService)this.getApplicationComponent(TemplateService.class);
        return tempServ.getSkinPath(nodeTypeName, skinName, this.getLanguage());
    }

    public String getWebDAVServerPrefix() throws Exception {
        PortletRequestContext portletRequestContext = (PortletRequestContext)PortletRequestContext.getCurrentInstance();
        String prefixWebDAV = portletRequestContext.getRequest().getScheme() + "://" + portletRequestContext.getRequest().getServerName() + ":" + String.format("%s", portletRequestContext.getRequest().getServerPort());
        return prefixWebDAV;
    }

    public String getWorkspaceName() throws Exception {
        return this.getNode().getSession().getWorkspace().getName();
    }

    public boolean isNodeTypeSupported() {
        try {
            TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
            return templateService.isManagedNodeType(this.getNodeType());
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getRepository() throws Exception {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getRepositoryName();
    }

    public String encodeHTML(String text) throws Exception {
        return Utils.encodeHTML((String)text);
    }

    private Node getFileLangNode(Node currentNode) throws Exception {
        if (currentNode.getNodes().getSize() > 0L) {
            NodeIterator nodeIter = currentNode.getNodes();
            while (nodeIter.hasNext()) {
                Node ntFile = nodeIter.nextNode();
                if (!ntFile.getPrimaryNodeType().getName().equals("nt:file")) continue;
                return ntFile;
            }
            return currentNode;
        }
        return currentNode;
    }

    public UIComponent getUIComponent(String mimeType) throws Exception {
        UIExtensionManager manager = (UIExtensionManager)this.getApplicationComponent(UIExtensionManager.class);
        List extensions = manager.getUIExtensions("org.exoplatform.ecm.dms.FileViewer");
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("mimeType", mimeType);
        for (UIExtension extension : extensions) {
            UIComponent uiComponent = manager.addUIExtension(extension, context, (UIContainer)this);
            if (uiComponent == null) continue;
            return uiComponent;
        }
        return null;
    }

    public boolean isEnableComment() {
        return false;
    }

    public boolean isEnableVote() {
        return false;
    }

    public void setEnableComment(boolean value) {
    }

    public void setEnableVote(boolean value) {
    }

    public String getInlineEditingField(Node orgNode, String propertyName, String defaultValue, String inputType, String idGenerator, String cssClass, boolean isGenericProperty, String ... arguments) throws Exception {
        return Utils.getInlineEditingField((Node)orgNode, (String)propertyName, (String)defaultValue, (String)inputType, (String)idGenerator, (String)cssClass, (boolean)isGenericProperty, (String[])arguments);
    }

    public String getInlineEditingField(Node orgNode, String propertyName) throws Exception {
        return Utils.getInlineEditingField((Node)orgNode, (String)propertyName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeNodeActionListener
    extends EventListener<UIViewVersion> {
        public void execute(Event<UIViewVersion> event) throws Exception {
            UIViewVersion uiViewVersion = (UIViewVersion)((Object)event.getSource());
            UIApplication uiApp = (UIApplication)uiViewVersion.getAncestorOfType(UIApplication.class);
            uiApp.addMessage(new ApplicationMessage("UIViewVersion.msg.not-supported", null));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DownloadActionListener
    extends EventListener<UIViewVersion> {
        public void execute(Event<UIViewVersion> event) throws Exception {
            UIViewVersion uiComp = (UIViewVersion)((Object)event.getSource());
            String downloadLink = uiComp.getDownloadLink(uiComp.getFileLangNode(uiComp.getNode()));
            event.getRequestContext().getJavascriptManager().addJavascript((CharSequence)("ajaxRedirect('" + downloadLink + "');"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeLanguageActionListener
    extends EventListener<UIViewVersion> {
        public void execute(Event<UIViewVersion> event) throws Exception {
            UIViewVersion uiViewVersion = (UIViewVersion)((Object)event.getSource());
            UIApplication uiApp = (UIApplication)uiViewVersion.getAncestorOfType(UIApplication.class);
            uiApp.addMessage(new ApplicationMessage("UIViewVersion.msg.not-supported", null));
        }
    }
}

