/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jgroups.Address;
import org.jgroups.View;
import org.jgroups.blocks.ReplicatedTree;

public class ReplicatedTreeDemo {
    public static void main(String[] args) {
        String start_directory = null;
        boolean jmx = false;
        String props = "udp.xml";
        for (int i = 0; i < args.length; ++i) {
            if ("-props".equals(args[i])) {
                props = args[++i];
                continue;
            }
            if ("-start_directory".equals(args[i])) {
                start_directory = args[++i];
                continue;
            }
            if ("-jmx".equals(args[i])) {
                jmx = true;
                continue;
            }
            ReplicatedTreeDemo.help();
            return;
        }
        try {
            ReplicatedTree tree = new ReplicatedTree("ReplicatedTreeDemo-Group", props, 10000L, jmx);
            new ReplicatedTreeView(tree, tree.getLocalAddress());
            if (start_directory != null && start_directory.length() > 0) {
                ReplicatedTreeDemo.populateTree(tree, start_directory);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }

    static void help() {
        System.out.println("ReplicatedTreeView [-help] [-props <channel properties>] [-start_directory <dirname>] [-jmx]");
    }

    static void populateTree(ReplicatedTree tree, String dir) {
        String[] children;
        File file = new File(dir);
        if (!file.exists()) {
            return;
        }
        tree.put(dir, null);
        if (file.isDirectory() && (children = file.list()) != null && children.length > 0) {
            for (int i = 0; i < children.length; ++i) {
                ReplicatedTreeDemo.populateTree(tree, dir + '/' + children[i]);
            }
        }
    }

    static class ReplicatedTreeView
    extends JFrame
    implements WindowListener,
    ReplicatedTree.ReplicatedTreeListener,
    TreeSelectionListener,
    TableModelListener {
        DefaultTreeModel tree_model = null;
        JTree jtree = null;
        final DefaultTableModel table_model = new DefaultTableModel();
        final JTable table = new JTable(this.table_model);
        final MyNode root = new MyNode("/");
        final String props;
        String selected_node = null;
        ReplicatedTree tree = null;
        JPanel tablePanel = null;
        JMenu operationsMenu = null;
        JPopupMenu operationsPopup = null;
        JMenuBar menubar = null;
        static final String SEP = "/";
        private static final int KEY_COL_WIDTH = 20;
        private static final int VAL_COL_WIDTH = 300;

        public ReplicatedTreeView(ReplicatedTree tree, Object title) throws Exception {
            this.props = null;
            this.tree = tree;
            tree.addReplicatedTreeListener(this);
            this.addNotify();
            this.setTitle("ReplicatedTreeDemo: mbr=" + title);
            this.tree_model = new DefaultTreeModel(this.root);
            this.jtree = new JTree(this.tree_model);
            this.jtree.setDoubleBuffered(true);
            this.jtree.getSelectionModel().setSelectionMode(1);
            JScrollPane scroll_pane = new JScrollPane(this.jtree);
            this.populateTree();
            this.getContentPane().add((Component)scroll_pane, "Center");
            this.addWindowListener(this);
            this.table_model.setColumnIdentifiers(new String[]{"Name", "Value"});
            this.table_model.addTableModelListener(this);
            this.setTableColumnWidths();
            this.tablePanel = new JPanel();
            this.tablePanel.setLayout(new BorderLayout());
            this.tablePanel.add((Component)this.table.getTableHeader(), "North");
            this.tablePanel.add((Component)this.table, "Center");
            this.getContentPane().add((Component)this.tablePanel, "South");
            this.jtree.addTreeSelectionListener(this);
            MouseAdapter ml = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int selRow = ReplicatedTreeView.this.jtree.getRowForLocation(e.getX(), e.getY());
                    TreePath selPath = ReplicatedTreeView.this.jtree.getPathForLocation(e.getX(), e.getY());
                    if (selRow != -1) {
                        ReplicatedTreeView.this.selected_node = ReplicatedTreeView.this.makeFQN(selPath.getPath());
                        ReplicatedTreeView.this.jtree.setSelectionPath(selPath);
                        if (e.getModifiers() == 4) {
                            ReplicatedTreeView.this.operationsPopup.show(e.getComponent(), e.getX(), e.getY());
                        }
                    }
                }
            };
            this.jtree.addMouseListener(ml);
            this.createMenus();
            this.setLocation(50, 50);
            this.setSize(this.getInsets().left + this.getInsets().right + 485, this.getInsets().top + this.getInsets().bottom + 367);
            this.init();
            this.setVisible(true);
        }

        @Override
        public void windowClosed(WindowEvent event) {
        }

        @Override
        public void windowDeiconified(WindowEvent event) {
        }

        @Override
        public void windowIconified(WindowEvent event) {
        }

        @Override
        public void windowActivated(WindowEvent event) {
        }

        @Override
        public void windowDeactivated(WindowEvent event) {
        }

        @Override
        public void windowOpened(WindowEvent event) {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            System.exit(0);
        }

        @Override
        public void tableChanged(TableModelEvent evt) {
            if (evt.getType() == 0) {
                int row = evt.getFirstRow();
                int col = evt.getColumn();
                if (col == 0) {
                    String key = (String)this.table_model.getValueAt(row, col);
                    String val = (String)this.table_model.getValueAt(row, col + 1);
                    if (key != null && val != null) {
                        this.tree.put(this.selected_node, key, val);
                    }
                } else {
                    String key = (String)this.table_model.getValueAt(row, col - 1);
                    String val = (String)this.table.getValueAt(row, col);
                    if (key != null && val != null) {
                        this.tree.put(this.selected_node, key, val);
                    }
                }
            }
        }

        @Override
        public void valueChanged(TreeSelectionEvent evt) {
            TreePath path = evt.getPath();
            String fqn = SEP;
            HashMap data = null;
            for (int i = 0; i < path.getPathCount(); ++i) {
                String component_name = ((MyNode)path.getPathComponent((int)i)).name;
                if (component_name.equals(SEP)) continue;
                fqn = fqn.equals(SEP) ? fqn + component_name : fqn + SEP + component_name;
            }
            data = this.getData(this.tree, fqn);
            if (data != null) {
                this.getContentPane().add((Component)this.tablePanel, "South");
                this.populateTable(data);
                this.validate();
            } else {
                this.clearTable();
                this.getContentPane().remove(this.tablePanel);
                this.validate();
            }
        }

        @Override
        public void nodeAdded(String fqn) {
            MyNode n = this.root.add(fqn);
            if (n != null) {
                MyNode p = (MyNode)n.getParent();
                this.tree_model.reload(p);
                this.jtree.scrollPathToVisible(new TreePath(n.getPath()));
            }
        }

        @Override
        public void nodeRemoved(String fqn) {
            MyNode n = this.root.findNode(fqn);
            if (n != null) {
                n.removeAllChildren();
                TreeNode par = n.getParent();
                n.removeFromParent();
                this.tree_model.reload(par);
            }
        }

        @Override
        public void nodeModified(String fqn) {
        }

        @Override
        public void viewChange(View new_view) {
            Vector<Address> mbrship;
            if (new_view != null && (mbrship = new_view.getMembers()) != null) {
                this.tree._put(SEP, "members", mbrship);
                this.tree._put(SEP, "coordinator", mbrship.firstElement());
            }
        }

        public void run() {
        }

        void init() {
            Vector mbrship = null;
            this.addGuiNode(SEP);
            Vector vector = mbrship = this.tree != null && this.tree.getMembers() != null ? (Vector)this.tree.getMembers().clone() : null;
            if (mbrship != null) {
                this.tree._put(SEP, "members", mbrship);
                this.tree._put(SEP, "coordinator", mbrship.firstElement());
            }
        }

        private void populateTree() {
            this.addGuiNode(SEP);
        }

        void addGuiNode(String fqn) {
            if (fqn == null) {
                return;
            }
            this.root.add(fqn);
            Set children = this.tree.getChildrenNames(fqn);
            if (children != null) {
                for (String child_name : children) {
                    this.addGuiNode(fqn + SEP + child_name);
                }
            }
        }

        String makeFQN(Object[] path) {
            String tmp_name;
            StringBuilder sb = new StringBuilder("");
            if (path == null) {
                return null;
            }
            for (int i = 0; i < path.length; ++i) {
                tmp_name = ((MyNode)path[i]).name;
                if (tmp_name.equals(SEP)) continue;
                sb.append(SEP + tmp_name);
            }
            tmp_name = sb.toString();
            if (tmp_name.length() == 0) {
                return SEP;
            }
            return tmp_name;
        }

        void clearTable() {
            int num_rows = this.table.getRowCount();
            if (num_rows > 0) {
                for (int i = 0; i < num_rows; ++i) {
                    this.table_model.removeRow(0);
                }
                this.table_model.fireTableRowsDeleted(0, num_rows - 1);
                this.repaint();
            }
        }

        void populateTable(HashMap data) {
            String strval = "<null>";
            int num_rows = 0;
            if (data == null) {
                return;
            }
            num_rows = data.size();
            this.clearTable();
            if (num_rows > 0) {
                for (Map.Entry entry : data.entrySet()) {
                    String key = (String)entry.getKey();
                    Object val = entry.getValue();
                    if (val != null) {
                        strval = val.toString();
                    }
                    this.table_model.addRow(new Object[]{key, strval});
                }
                this.table_model.fireTableRowsInserted(0, num_rows - 1);
                this.validate();
            }
        }

        private void setTableColumnWidths() {
            this.table.sizeColumnsToFit(1);
            TableColumn column = null;
            column = this.table.getColumnModel().getColumn(0);
            column.setMinWidth(20);
            column.setPreferredWidth(20);
            column = this.table.getColumnModel().getColumn(1);
            column.setPreferredWidth(300);
        }

        private void createMenus() {
            this.menubar = new JMenuBar();
            this.operationsMenu = new JMenu("Operations");
            AddNodeAction addNode = new AddNodeAction();
            addNode.putValue("Name", "Add to this node");
            RemoveNodeAction removeNode = new RemoveNodeAction();
            removeNode.putValue("Name", "Remove this node");
            AddModifyDataForNodeAction addModAction = new AddModifyDataForNodeAction();
            addModAction.putValue("Name", "Add/Modify data");
            ExitAction exitAction = new ExitAction();
            exitAction.putValue("Name", "Exit");
            this.operationsMenu.add(addNode);
            this.operationsMenu.add(removeNode);
            this.operationsMenu.add(addModAction);
            this.operationsMenu.add(exitAction);
            this.menubar.add(this.operationsMenu);
            this.setJMenuBar(this.menubar);
            this.operationsPopup = new JPopupMenu();
            this.operationsPopup.add(addNode);
            this.operationsPopup.add(removeNode);
            this.operationsPopup.add(addModAction);
        }

        HashMap getData(ReplicatedTree tree, String fqn) {
            if (tree == null || fqn == null) {
                return null;
            }
            Set keys = tree.getKeys(fqn);
            if (keys == null) {
                return null;
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            for (String key : keys) {
                Object value = tree.get(fqn, key);
                if (value == null) continue;
                data.put(key, value);
            }
            return data;
        }

        class MyNode
        extends DefaultMutableTreeNode {
            String name = "<unnamed>";

            MyNode(String name) {
                this.name = name;
            }

            public MyNode add(String fqn) {
                MyNode ret = null;
                if (fqn == null) {
                    return null;
                }
                MyNode curr = this;
                StringTokenizer tok = new StringTokenizer(fqn, ReplicatedTreeView.SEP);
                while (tok.hasMoreTokens()) {
                    String child_name = tok.nextToken();
                    MyNode n = curr.findChild(child_name);
                    if (n == null) {
                        n = new MyNode(child_name);
                        if (ret == null) {
                            ret = n;
                        }
                        curr.add(n);
                    }
                    curr = n;
                }
                return ret;
            }

            public void remove(String fqn) {
                this.removeFromParent();
            }

            MyNode findNode(String fqn) {
                if (fqn == null) {
                    return null;
                }
                MyNode curr = this;
                StringTokenizer tok = new StringTokenizer(fqn, ReplicatedTreeView.SEP);
                while (tok.hasMoreTokens()) {
                    String child_name = tok.nextToken();
                    MyNode n = curr.findChild(child_name);
                    if (n == null) {
                        return null;
                    }
                    curr = n;
                }
                return curr;
            }

            MyNode findChild(String relative_name) {
                if (relative_name == null || this.getChildCount() == 0) {
                    return null;
                }
                for (int i = 0; i < this.getChildCount(); ++i) {
                    MyNode child = (MyNode)this.getChildAt(i);
                    if (child.name == null || !child.name.equals(relative_name)) continue;
                    return child;
                }
                return null;
            }

            String print(int indent) {
                int i;
                StringBuilder sb = new StringBuilder();
                for (i = 0; i < indent; ++i) {
                    sb.append(' ');
                }
                if (!this.isRoot()) {
                    if (this.name == null) {
                        sb.append("/<unnamed>");
                    } else {
                        sb.append(ReplicatedTreeView.SEP + this.name);
                    }
                }
                sb.append('\n');
                if (this.getChildCount() > 0) {
                    indent = this.isRoot() ? 0 : (indent += 4);
                    for (i = 0; i < this.getChildCount(); ++i) {
                        sb.append(((MyNode)this.getChildAt(i)).print(indent));
                    }
                }
                return sb.toString();
            }

            @Override
            public String toString() {
                return this.name;
            }
        }

        class AddModifyDataForNodeAction
        extends AbstractAction {
            AddModifyDataForNodeAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                HashMap<String, String> data = ReplicatedTreeView.this.getData(ReplicatedTreeView.this.tree, ReplicatedTreeView.this.selected_node);
                if (data == null) {
                    ReplicatedTreeView.this.clearTable();
                    data = new HashMap<String, String>();
                    data.put("Add Key", "Add Value");
                }
                ReplicatedTreeView.this.populateTable(data);
                ReplicatedTreeView.this.getContentPane().add((Component)ReplicatedTreeView.this.tablePanel, "South");
                ReplicatedTreeView.this.validate();
            }
        }

        class RemoveNodeAction
        extends AbstractAction {
            RemoveNodeAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ReplicatedTreeView.this.tree.remove(ReplicatedTreeView.this.selected_node);
            }
        }

        class AddNodeAction
        extends AbstractAction {
            AddNodeAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                JTextField fqnTextField = new JTextField();
                if (ReplicatedTreeView.this.selected_node != null) {
                    fqnTextField.setText(ReplicatedTreeView.this.selected_node);
                }
                Object[] information = new Object[]{"Enter fully qualified name", fqnTextField};
                String btnString1 = "OK";
                String btnString2 = "Cancel";
                Object[] options = new Object[]{"OK", "Cancel"};
                int userChoice = JOptionPane.showOptionDialog(null, information, "Add Node", 0, -1, null, options, options[0]);
                if (userChoice == 0) {
                    String userInput = fqnTextField.getText();
                    ReplicatedTreeView.this.tree.put(userInput, null);
                }
            }
        }

        class ExitAction
        extends AbstractAction {
            ExitAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        }
    }
}

