/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.protocols.TP;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;

public class MessageDispatcherUnitTest
extends ChannelTestBase {
    MessageDispatcher disp;
    MessageDispatcher disp2;
    JChannel ch;
    JChannel ch2;

    public MessageDispatcherUnitTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.ch = this.createChannel();
        this.disableBundling(this.ch);
        this.disp = new MessageDispatcher((Channel)this.ch, null, null, null);
        this.ch.connect("x");
    }

    @Override
    protected void tearDown() throws Exception {
        this.disp.stop();
        this.ch.close();
        if (this.ch2 != null) {
            this.disp2.stop();
            this.ch2.close();
        }
        Util.sleep(500L);
        super.tearDown();
    }

    public void testNullMessageToSelf() {
        MyHandler handler = new MyHandler(null);
        this.disp.setRequestHandler(handler);
        RspList rsps = this.disp.castMessage(null, new Message(), 2, 0L);
        System.out.println("rsps:\n" + rsps);
        MessageDispatcherUnitTest.assertNotNull((Object)rsps);
        MessageDispatcherUnitTest.assertEquals((int)1, (int)rsps.size());
        Object obj = rsps.getFirst();
        MessageDispatcherUnitTest.assertNull((Object)obj);
    }

    public void test200ByteMessageToSelf() {
        this.sendMessage(200);
    }

    public void test2000ByteMessageToSelf() {
        this.sendMessage(2000);
    }

    public void test20000ByteMessageToSelf() {
        this.sendMessage(20000);
    }

    public void testNullMessageToAll() throws Exception {
        this.disp.setRequestHandler(new MyHandler(null));
        this.ch2 = this.createChannel();
        this.disableBundling(this.ch2);
        long start = System.currentTimeMillis();
        this.disp2 = new MessageDispatcher((Channel)this.ch2, null, null, new MyHandler(null));
        long stop = System.currentTimeMillis();
        this.ch2.connect("x");
        MessageDispatcherUnitTest.assertEquals((int)2, (int)this.ch2.getView().size());
        System.out.println("view: " + this.ch2.getView());
        System.out.println("casting message");
        start = System.currentTimeMillis();
        RspList rsps = this.disp.castMessage(null, new Message(), 2, 0L);
        stop = System.currentTimeMillis();
        System.out.println("rsps:\n" + rsps);
        System.out.println("call took " + (stop - start) + " ms");
        MessageDispatcherUnitTest.assertNotNull((Object)rsps);
        MessageDispatcherUnitTest.assertEquals((int)2, (int)rsps.size());
        Rsp rsp = rsps.get(this.ch.getLocalAddress());
        MessageDispatcherUnitTest.assertNotNull((Object)rsp);
        Object ret = rsp.getValue();
        MessageDispatcherUnitTest.assertNull((Object)ret);
        rsp = rsps.get(this.ch2.getLocalAddress());
        MessageDispatcherUnitTest.assertNotNull((Object)rsp);
        ret = rsp.getValue();
        MessageDispatcherUnitTest.assertNull((Object)ret);
    }

    public void test200ByteMessageToAll() throws Exception {
        this.sendMessageToBothChannels(200);
    }

    public void test2000ByteMessageToAll() throws Exception {
        this.sendMessageToBothChannels(2000);
    }

    public void test20000ByteMessageToAll() throws Exception {
        this.sendMessageToBothChannels(20000);
    }

    private void sendMessage(int size) {
        MyHandler handler = new MyHandler(new byte[size]);
        this.disp.setRequestHandler(handler);
        long start = System.currentTimeMillis();
        RspList rsps = this.disp.castMessage(null, new Message(), 2, 0L);
        long stop = System.currentTimeMillis();
        System.out.println("rsps:\n" + rsps);
        System.out.println("call took " + (stop - start) + " ms");
        MessageDispatcherUnitTest.assertNotNull((Object)rsps);
        MessageDispatcherUnitTest.assertEquals((int)1, (int)rsps.size());
        byte[] buf = (byte[])rsps.getFirst();
        MessageDispatcherUnitTest.assertNotNull((Object)buf);
        MessageDispatcherUnitTest.assertEquals((int)size, (int)buf.length);
    }

    private void sendMessageToBothChannels(int size) throws Exception {
        this.disp.setRequestHandler(new MyHandler(new byte[size]));
        this.ch2 = this.createChannel();
        this.disableBundling(this.ch2);
        this.disp2 = new MessageDispatcher((Channel)this.ch2, null, null, new MyHandler(new byte[size]));
        this.ch2.connect("x");
        MessageDispatcherUnitTest.assertEquals((int)2, (int)this.ch2.getView().size());
        System.out.println("casting message");
        long start = System.currentTimeMillis();
        RspList rsps = this.disp.castMessage(null, new Message(), 2, 0L);
        long stop = System.currentTimeMillis();
        System.out.println("rsps:\n" + rsps);
        System.out.println("call took " + (stop - start) + " ms");
        MessageDispatcherUnitTest.assertNotNull((Object)rsps);
        MessageDispatcherUnitTest.assertEquals((int)2, (int)rsps.size());
        Rsp rsp = rsps.get(this.ch.getLocalAddress());
        MessageDispatcherUnitTest.assertNotNull((Object)rsp);
        byte[] ret = (byte[])rsp.getValue();
        MessageDispatcherUnitTest.assertEquals((int)size, (int)ret.length);
        rsp = rsps.get(this.ch2.getLocalAddress());
        MessageDispatcherUnitTest.assertNotNull((Object)rsp);
        ret = (byte[])rsp.getValue();
        MessageDispatcherUnitTest.assertEquals((int)size, (int)ret.length);
    }

    private void disableBundling(JChannel ch) {
        ProtocolStack stack = ch.getProtocolStack();
        TP transport = (TP)stack.findProtocol(TP.class);
        if (transport != null) {
            Properties tmp = new Properties();
            tmp.setProperty("enable_bundling", "false");
            transport.setProperties(tmp);
        }
    }

    public static Test suite() {
        return new TestSuite(MessageDispatcherUnitTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)MessageDispatcherUnitTest.suite());
    }

    private static class MyHandler
    implements RequestHandler {
        byte[] retval = null;

        public MyHandler(byte[] retval) {
            this.retval = retval;
        }

        @Override
        public Object handle(Message msg) {
            return this.retval;
        }
    }
}

