/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.jgroups.util.ReusableThread;
import org.jgroups.util.Util;

public class ReusableThreadTest
extends TestCase {
    public ReusableThreadTest(String name) {
        super(name);
    }

    public void testReusableThread() {
        ReusableThread t = new ReusableThread("Demo ReusableThread");
        MyThread m1 = new MyThread(1);
        MyThread m2 = new MyThread(2);
        LongRunningThread m4 = new LongRunningThread(4);
        System.out.println("Assigning task");
        t.assignTask(m4);
        System.out.println("Sleeping 2 secs");
        Util.sleep(2000L);
        System.out.println("stop()");
        t.stop();
        System.out.println("stop() -- done");
        Util.printThreads();
        System.out.println("\nAssigning task 1");
        t.assignTask(m1);
        t.waitUntilDone();
        System.out.println("done with task 1");
        Util.printThreads();
        System.out.println("\nAssigning task 2");
        t.assignTask(m2);
        t.waitUntilDone();
        System.out.println("done with task 2");
        System.out.println("Stopping thread");
        t.stop();
        System.out.println("done");
        Util.printThreads();
    }

    public void testAssignMultipleTimes() {
        ReusableThread t = new ReusableThread("Demo ReusableThread");
        LongRunningThread t1 = new LongRunningThread(1, 500L);
        LongRunningThread t2 = new LongRunningThread(2, 300L);
        t.start();
        t.assignTask(t1);
        t.waitUntilDone();
        ReusableThreadTest.assertTrue((boolean)t.done());
        t.assignTask(t2);
        t.waitUntilDone();
        ReusableThreadTest.assertTrue((boolean)t.done());
    }

    public void testStop() {
        ReusableThread t = new ReusableThread("Demo ReusableThread");
        LongRunningThread t1 = new LongRunningThread(1, 20000L);
        t.assignTask(t1);
        Util.sleep(1000L);
        t.stop();
        t.waitUntilDone();
        ReusableThreadTest.assertTrue((boolean)t.done());
        ReusableThreadTest.assertFalse((boolean)t.isAlive());
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{ReusableThreadTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }

    static class LongRunningThread
    extends MyThread {
        long sleep_time = 10000L;

        public LongRunningThread(int num) {
            super(num);
            this.name = "LongRunningThread #" + num;
        }

        public LongRunningThread(int num, long sleep_time) {
            super(num);
            this.sleep_time = sleep_time;
            this.name = "LongRunningThread #" + num;
        }

        @Override
        public void run() {
            System.out.println("LongRunningThread " + this.name + " is run");
            System.out.println("LongRunningThread #" + this.num + ": sleeping " + this.sleep_time + " msecs");
            Util.sleep(this.sleep_time);
        }
    }

    static class MyThread
    implements Runnable {
        int num = 0;
        String name = null;

        public MyThread(int num) {
            this.num = num;
            this.name = "Thread #" + num;
        }

        @Override
        public void run() {
            System.out.println("Thread " + this.name + " is run");
            long sleep_time = (long)(Math.random() * 5000.0);
            System.out.print("Thread #" + this.num + ": sleeping " + sleep_time + ':');
            Util.sleep(sleep_time);
            System.out.println(" -- done");
        }
    }
}

