/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.TimeoutException;

public class Promise<T> {
    private final Lock lock = new ReentrantLock();
    private final Condition cond = this.lock.newCondition();
    private T result = null;
    private boolean hasResult = false;

    public Lock getLock() {
        return this.lock;
    }

    public Condition getCond() {
        return this.cond;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getResultWithTimeout(long timeout) throws TimeoutException {
        this.lock.lock();
        try {
            T t = this._getResultWithTimeout(timeout);
            return t;
        }
        finally {
            this.cond.signalAll();
            this.lock.unlock();
        }
    }

    private T _getResultWithTimeout(long timeout) throws TimeoutException {
        T ret = null;
        long time_to_wait = timeout;
        boolean timeout_occurred = false;
        long start = System.currentTimeMillis();
        while (!this.hasResult) {
            if (timeout <= 0L) {
                this.doWait();
                continue;
            }
            if (time_to_wait <= 0L) {
                timeout_occurred = true;
                break;
            }
            this.doWait(time_to_wait);
            time_to_wait = timeout - (System.currentTimeMillis() - start);
        }
        ret = this.result;
        this.result = null;
        this.hasResult = false;
        if (timeout_occurred) {
            throw new TimeoutException();
        }
        return ret;
    }

    public T getResult() {
        try {
            return this.getResultWithTimeout(0L);
        }
        catch (TimeoutException e) {
            return null;
        }
    }

    public T getResult(long timeout) {
        try {
            return this.getResultWithTimeout(timeout);
        }
        catch (TimeoutException e) {
            return null;
        }
    }

    private void doWait() {
        try {
            this.cond.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void doWait(long timeout) {
        try {
            this.cond.await(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasResult() {
        this.lock.lock();
        try {
            boolean bl = this.hasResult;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResult(T obj) {
        this.lock.lock();
        try {
            this.result = obj;
            this.hasResult = true;
            this.cond.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.lock.lock();
        try {
            this.result = null;
            this.hasResult = false;
            this.cond.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return "hasResult=" + Boolean.valueOf(this.hasResult) + ",result=" + this.result;
    }
}

