/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend;

import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.context.WizardContext;
import com.install4j.api.screens.Screen;
import com.install4j.runtime.beans.screens.ProgressScreen;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.ScreenBeanConfig;
import com.install4j.runtime.installer.controller.CommandSink;
import com.install4j.runtime.installer.controller.ControllerCommand;
import com.install4j.runtime.installer.controller.ReturnToken;
import com.install4j.runtime.installer.controller.ScreenExecutor;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.GUIProgressInterface;
import com.install4j.runtime.installer.frontend.LanguageSelectionDialog;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.RollbackProgressInterface;
import com.install4j.runtime.installer.frontend.ScreenEnvelope;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.wizard.WizardBase;
import com.install4j.runtime.wizard.WizardFrame;
import java.awt.Button;
import java.awt.Dimension;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public abstract class WizardScreenExecutor
extends WizardBase
implements ScreenExecutor,
WizardContext {
    private GUIProgressInterface defaultProgressInterface;
    private RollbackProgressInterface rollbackProgressInterface;
    private ScreenEnvelope screenEnvelope;
    private CommandSink commandSink;

    public WizardScreenExecutor() {
        super("");
        this.initAWT();
        this.defaultProgressInterface = new GUIProgressInterface();
        FileInstaller.getInstance().setDefaultProgressInterface(this.defaultProgressInterface);
    }

    protected abstract String getWindowTitle();

    protected abstract Icon getDefaultHeaderIcon();

    protected abstract String getCustomHeaderIconFileName();

    public void setNextButtonEnabled(boolean bl) {
        if (this.screenEnvelope != null) {
            this.screenEnvelope.setNextButtonEnabled(bl);
        }
    }

    public void setBackButtonEnabled(boolean bl) {
        if (this.screenEnvelope != null) {
            this.screenEnvelope.setPreviousButtonEnabled(bl);
        }
    }

    public void setCancelButtonEnabled(boolean bl) {
        if (this.screenEnvelope != null) {
            this.screenEnvelope.setCancelButtonEnabled(bl);
        }
    }

    public void pressNextButton() {
        if (this.screenEnvelope != null) {
            this.screenEnvelope.doNext();
        }
    }

    public void pressPreviousButton() {
        if (this.screenEnvelope != null) {
            this.screenEnvelope.doPrevious();
        }
    }

    public void pressCancelButton() {
        if (this.screenEnvelope != null) {
            this.screenEnvelope.doCancel();
        }
    }

    public void register(Screen screen, ScreenBeanConfig screenBeanConfig) {
        this.getContext().applyToScreen(screen);
        this.registerScreen(new ScreenEnvelope(this, screen, screenBeanConfig));
    }

    public void execute(ScreenBeanConfig screenBeanConfig, CommandSink commandSink, boolean bl) {
        Screen screen = screenBeanConfig.getOrInstantiateScreen(false);
        this.commandSink = commandSink;
        Iterator iterator = this.getScreens().iterator();
        while (iterator.hasNext()) {
            ScreenEnvelope screenEnvelope = (ScreenEnvelope)iterator.next();
            if (screenEnvelope.getScreen() != screen) continue;
            if (this.screenEnvelope != null) {
                this.screenEnvelope.getScreen().deactivated();
            }
            this.screenEnvelope = screenEnvelope;
            if (!bl) {
                screenEnvelope.setPreviousButtonVisible(false);
            }
            this.setScreen(screenEnvelope);
            if (!this.isShowing()) {
                this.showFrame(null, GUIHelper.getFrameIcon());
            }
            return;
        }
        throw new RuntimeException("screen not registered " + screen.toString());
    }

    public CommandSink getCommandSink() {
        return this.commandSink;
    }

    public ProgressInterface getProgressInterface() {
        if (this.rollbackProgressInterface != null) {
            return this.rollbackProgressInterface;
        }
        if (this.screenEnvelope != null) {
            return this.screenEnvelope.getScreen().getProgressInterface(this.defaultProgressInterface);
        }
        return this.defaultProgressInterface;
    }

    public WizardContext getWizardContext() {
        return this;
    }

    public void selectLanguage(ReturnToken returnToken) {
        new LanguageSelectionDialog(returnToken).setVisible(true);
    }

    public boolean isUnattended() {
        return false;
    }

    public boolean isConsole() {
        return false;
    }

    protected int getFrameWidth() {
        return InstallerConfig.getCurrentInstance().getWindowWidth();
    }

    protected int getFrameHeight() {
        return InstallerConfig.getCurrentInstance().getWindowHeight();
    }

    protected boolean needsNextScreenOnVisible() {
        return false;
    }

    protected void beforeShow(WizardFrame wizardFrame) {
        super.beforeShow(wizardFrame);
        wizardFrame.setTitle(this.getWindowTitle());
        wizardFrame.setResizable(InstallerConfig.getCurrentInstance().isResizable());
    }

    protected void beforeHide(WizardFrame wizardFrame) {
        super.beforeHide(wizardFrame);
        if (this.rollbackProgressInterface != null && this.rollbackProgressInterface.isVisible()) {
            this.rollbackProgressInterface.setVisible(false);
        }
    }

    protected boolean isQuitOnWindowClose() {
        if (this.screenEnvelope == null) {
            return true;
        }
        return this.screenEnvelope.isCancelVisible() && this.screenEnvelope.isCancelButtonEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        ResourceBundle resourceBundle = Messages.getMessages();
        this.getContext().setAskingForCancel(true);
        try {
            int n = 0;
            try {
                n = GUIHelper.showOptionDialog(this, resourceBundle.getString("ExitSetupMessage"), new String[]{resourceBundle.getString("ButtonYes"), resourceBundle.getString("ButtonNo")}, 3);
            }
            catch (UserCanceledException userCanceledException) {
                // empty catch block
            }
            if (n == 0) {
                this.screenEnvelope.setCancelButtonEnabled(false);
                this.getContext().setCancelling();
                this.commandSink.returnToController(ControllerCommand.CANCEL);
            }
        }
        finally {
            this.getContext().setAskingForCancel(false);
        }
    }

    protected void setupComponent() {
        super.setupComponent();
        this.setMinimumSize(new Dimension(500, 300));
    }

    public void setRollback() {
        if (this.screenEnvelope != null && this.screenEnvelope.getScreen() instanceof ProgressScreen) {
            ProgressInterface progressInterface = this.getProgressInterface();
            progressInterface.setIndeterminateProgress(false);
            progressInterface.setDetailMessage("");
            progressInterface.setStatusMessage(Messages.getMessages().getString("StatusRollback"));
            progressInterface.setPercentCompleted(0);
        } else if (this.rollbackProgressInterface == null) {
            Runnable runnable = new Runnable(){

                public void run() {
                    WizardScreenExecutor.this.rollbackProgressInterface = new RollbackProgressInterface(WizardScreenExecutor.this.getWizardFrame());
                    WizardScreenExecutor.this.rollbackProgressInterface.setVisible(true);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public void closeWindows() {
        this.finish();
    }

    public Icon getHeaderIcon() {
        try {
            ImageIcon imageIcon = new ImageIcon(InstallerUtil.getInstallerFile(this.getCustomHeaderIconFileName()).getPath());
            if (imageIcon.getIconWidth() <= 0) {
                return this.getDefaultHeaderIcon();
            }
            return imageIcon;
        }
        catch (Exception exception) {
            return this.getDefaultHeaderIcon();
        }
    }

    private void initAWT() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    new Button();
                }
            });
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            invocationTargetException.printStackTrace();
        }
    }

    public void disarmButtons() {
        if (this.screenEnvelope != null) {
            this.screenEnvelope.disarmButtons();
        }
    }
}

