/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.metamodel.bean;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.chromattic.common.collection.Collections;
import org.chromattic.metamodel.bean.BeanFilter;
import org.chromattic.metamodel.bean.BeanInfo;
import org.chromattic.metamodel.bean.BeanValueInfo;
import org.chromattic.metamodel.bean.PropertyInfo;
import org.chromattic.metamodel.bean.SimpleValueInfo;
import org.chromattic.metamodel.bean.ValueInfo;
import org.chromattic.metamodel.bean.ValueKind;
import org.chromattic.metamodel.type.SimpleTypeMapping;
import org.chromattic.metamodel.type.SimpleTypeResolver;
import org.reflext.api.ArrayTypeInfo;
import org.reflext.api.ClassKind;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.MethodInfo;
import org.reflext.api.ParameterizedTypeInfo;
import org.reflext.api.SimpleTypeInfo;
import org.reflext.api.TypeInfo;
import org.reflext.api.TypeVariableInfo;
import org.reflext.api.VoidTypeInfo;
import org.reflext.api.introspection.MethodIntrospector;
import org.reflext.api.visit.HierarchyVisitor;
import org.reflext.api.visit.HierarchyVisitorStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanInfoBuilder {
    private final SimpleTypeResolver simpleTypeResolver;
    private final BeanFilter filter;

    public BeanInfoBuilder() {
        this((BeanFilter)null);
    }

    public BeanInfoBuilder(SimpleTypeResolver simpleTypeResolver) {
        this(simpleTypeResolver, null);
    }

    public BeanInfoBuilder(SimpleTypeResolver simpleTypeResolver, BeanFilter filter) {
        this.simpleTypeResolver = simpleTypeResolver;
        this.filter = filter;
    }

    public BeanInfoBuilder(BeanFilter filter) {
        this(new SimpleTypeResolver(), filter);
    }

    public Map<ClassTypeInfo, BeanInfo> build(ClassTypeInfo ... classTypes) {
        return this.build(Collections.set((Object[])classTypes));
    }

    public Map<ClassTypeInfo, BeanInfo> build(Set<ClassTypeInfo> classTypes) {
        Context ctx = new Context(classTypes);
        ctx.build();
        return ctx.beans;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Context {
        private final Set<ClassTypeInfo> classTypes;
        private final Map<ClassTypeInfo, BeanInfo> beans;

        private Context(Set<ClassTypeInfo> classTypes) {
            this.classTypes = classTypes;
            this.beans = new HashMap<ClassTypeInfo, BeanInfo>();
        }

        void build() {
            Iterator<ClassTypeInfo> iterator;
            while ((iterator = this.classTypes.iterator()).hasNext()) {
                ClassTypeInfo cti = iterator.next();
                BeanInfo beanInfo = this.resolve(cti);
            }
        }

        BeanInfo resolve(ClassTypeInfo classType) {
            BeanInfo bean = this.beans.get(classType);
            if (bean == null) {
                Boolean declared;
                boolean accept;
                if (classType.getKind() == ClassKind.CLASS || classType.getKind() == ClassKind.INTERFACE) {
                    if (classType instanceof SimpleTypeInfo) {
                        accept = false;
                        declared = null;
                    } else if (classType instanceof VoidTypeInfo) {
                        accept = false;
                        declared = null;
                    } else if (this.classTypes.remove(classType)) {
                        accept = true;
                        declared = true;
                    } else if (BeanInfoBuilder.this.filter != null && BeanInfoBuilder.this.filter.accept(classType)) {
                        accept = true;
                        declared = false;
                    } else {
                        accept = false;
                        declared = null;
                    }
                } else {
                    accept = false;
                    declared = null;
                }
                if (accept) {
                    bean = new BeanInfo(classType, declared);
                    this.beans.put(classType, bean);
                    this.build(bean);
                }
            }
            return bean;
        }

        void build(BeanInfo bean) {
            for (ClassTypeInfo ancestorClassType = bean.classType.getSuperClass(); ancestorClassType != null; ancestorClassType = ancestorClassType.getSuperClass()) {
                BeanInfo ancestorBean = this.resolve(ancestorClassType);
                if (ancestorBean == null) continue;
                bean.parent = ancestorBean;
                break;
            }
            this.buildProperties(bean);
            for (MethodInfo mi : bean.classType.getDeclaredMethods()) {
                TypeInfo rti = mi.getReturnType();
                if (!(rti instanceof ClassTypeInfo)) continue;
                this.resolve((ClassTypeInfo)rti);
            }
        }

        private PropertyInfo resolveProperty(BeanInfo bean, String propertyName) {
            if (bean == null) {
                return null;
            }
            if (bean.properties == null) {
                throw new AssertionError();
            }
            PropertyInfo property = bean.properties.get(propertyName);
            if (property == null) {
                property = this.resolveProperty(bean.parent, propertyName);
            }
            return property;
        }

        private void buildProperties(BeanInfo bean) {
            String name;
            BeanHierarchyVisitorStrategy strategy = new BeanHierarchyVisitorStrategy(bean.classType);
            MethodIntrospector introspector = new MethodIntrospector(strategy, true);
            Map getterMap = introspector.getGetterMap(bean.classType);
            Map setterMap = introspector.getSetterMap(bean.classType);
            HashMap<String, ToBuild> toBuilds = new HashMap<String, ToBuild>();
            for (Map.Entry getterEntry : getterMap.entrySet()) {
                name = (String)getterEntry.getKey();
                MethodInfo getter = (MethodInfo)getterEntry.getValue();
                TypeInfo getterTypeInfo = getter.getReturnType();
                ToBuild toBuild = null;
                Set setters = (Set)setterMap.get(name);
                if (setters != null) {
                    for (MethodInfo setter : setters) {
                        TypeInfo setterTypeInfo = (TypeInfo)setter.getParameterTypes().get(0);
                        if (!getterTypeInfo.equals(setterTypeInfo)) continue;
                        toBuild = new ToBuild(getterTypeInfo, getter, setter);
                        break;
                    }
                }
                if (toBuild == null) {
                    toBuild = new ToBuild(getterTypeInfo, getter, null);
                }
                if (toBuild == null) continue;
                toBuilds.put(name, toBuild);
            }
            setterMap.keySet().removeAll(toBuilds.keySet());
            for (Map.Entry setterEntry : setterMap.entrySet()) {
                name = (String)setterEntry.getKey();
                for (MethodInfo setter : (Set)setterEntry.getValue()) {
                    TypeInfo setterTypeInfo = (TypeInfo)setter.getParameterTypes().get(0);
                    toBuilds.put(name, new ToBuild(setterTypeInfo, null, setter));
                }
            }
            HashMap<String, PropertyInfo<SimpleValueInfo, ValueKind.Single>> properties = new HashMap<String, PropertyInfo<SimpleValueInfo, ValueKind.Single>>();
            for (Map.Entry toBuildEntry : toBuilds.entrySet()) {
                BeanInfo related;
                PropertyInfo parentProperty = this.resolveProperty(bean.parent, (String)toBuildEntry.getKey());
                TypeInfo type = ((ToBuild)toBuildEntry.getValue()).type;
                TypeInfo resolvedType = bean.classType.resolve(type);
                PropertyInfo<ValueInfo, ValueKind> property = null;
                if (resolvedType instanceof TypeVariableInfo) {
                    resolvedType = (TypeInfo)((TypeVariableInfo)resolvedType).getBounds().get(0);
                    resolvedType = bean.classType.resolve(resolvedType);
                }
                if (resolvedType instanceof ParameterizedTypeInfo) {
                    ParameterizedTypeInfo parameterizedType = (ParameterizedTypeInfo)resolvedType;
                    TypeInfo rawType = parameterizedType.getRawType();
                    if (rawType instanceof ClassTypeInfo) {
                        TypeInfo elementType;
                        ValueKind.Multi collectionKind;
                        ClassTypeInfo rawClassType = (ClassTypeInfo)rawType;
                        String rawClassName = rawClassType.getName();
                        if (rawClassName.equals("java.util.Collection")) {
                            collectionKind = ValueKind.COLLECTION;
                            elementType = (TypeInfo)parameterizedType.getTypeArguments().get(0);
                        } else if (rawClassName.equals("java.util.List")) {
                            collectionKind = ValueKind.LIST;
                            elementType = (TypeInfo)parameterizedType.getTypeArguments().get(0);
                        } else if (rawClassName.equals("java.util.Map")) {
                            TypeInfo keyType = (TypeInfo)parameterizedType.getTypeArguments().get(0);
                            TypeInfo resolvedKeyType = bean.classType.resolve(keyType);
                            if (resolvedKeyType instanceof ClassTypeInfo && resolvedKeyType.getName().equals("java.lang.String")) {
                                elementType = (TypeInfo)parameterizedType.getTypeArguments().get(1);
                                collectionKind = ValueKind.MAP;
                            } else {
                                elementType = null;
                                collectionKind = null;
                            }
                        } else {
                            elementType = null;
                            collectionKind = null;
                        }
                        if (collectionKind != null) {
                            if (elementType instanceof ParameterizedTypeInfo) {
                                ClassTypeInfo parameterizedElementRawClassType;
                                String parameterizedElementRawClassName;
                                ParameterizedTypeInfo parameterizedElementType = (ParameterizedTypeInfo)elementType;
                                TypeInfo parameterizedElementRawType = parameterizedElementType.getRawType();
                                if (parameterizedElementRawType instanceof ClassTypeInfo && (parameterizedElementRawClassName = (parameterizedElementRawClassType = (ClassTypeInfo)parameterizedElementRawType).getName()).equals("java.util.List")) {
                                    TypeInfo listElementType = (TypeInfo)parameterizedElementType.getTypeArguments().get(0);
                                    property = new PropertyInfo<SimpleValueInfo, ValueKind.Collection>(bean, parentProperty, (String)toBuildEntry.getKey(), ((ToBuild)toBuildEntry.getValue()).getter, ((ToBuild)toBuildEntry.getValue()).setter, (ValueKind.Collection)collectionKind, this.createSimpleValueInfo(bean, listElementType, ValueKind.LIST));
                                }
                            } else {
                                ClassTypeInfo elementClassType = bean.resolveToClass(elementType);
                                if (elementClassType != null) {
                                    BeanInfo relatedBean = this.resolve(elementClassType);
                                    if (relatedBean != null) {
                                        property = new PropertyInfo<BeanValueInfo, ValueKind.Collection>(bean, parentProperty, (String)toBuildEntry.getKey(), ((ToBuild)toBuildEntry.getValue()).getter, ((ToBuild)toBuildEntry.getValue()).setter, (ValueKind.Collection)collectionKind, new BeanValueInfo(type, bean.resolveToClass(elementType), relatedBean));
                                    } else if (collectionKind == ValueKind.LIST) {
                                        property = new PropertyInfo<SimpleValueInfo, ValueKind.Single>(bean, parentProperty, (String)toBuildEntry.getKey(), ((ToBuild)toBuildEntry.getValue()).getter, ((ToBuild)toBuildEntry.getValue()).setter, ValueKind.SINGLE, this.createSimpleValueInfo(bean, elementType, collectionKind));
                                    } else if (collectionKind == ValueKind.MAP) {
                                        property = new PropertyInfo<SimpleValueInfo, ValueKind.Map>(bean, parentProperty, (String)toBuildEntry.getKey(), ((ToBuild)toBuildEntry.getValue()).getter, ((ToBuild)toBuildEntry.getValue()).setter, ValueKind.MAP, this.createSimpleValueInfo(bean, elementType, ValueKind.SINGLE));
                                    }
                                }
                            }
                        }
                    }
                } else if (resolvedType instanceof ArrayTypeInfo) {
                    TypeInfo componentType = ((ArrayTypeInfo)resolvedType).getComponentType();
                    if (componentType instanceof SimpleTypeInfo) {
                        SimpleTypeInfo componentSimpleType = (SimpleTypeInfo)componentType;
                        switch (componentSimpleType.getLiteralType()) {
                            case BOOLEAN: 
                            case DOUBLE: 
                            case FLOAT: 
                            case LONG: 
                            case INT: {
                                property = new PropertyInfo<SimpleValueInfo, ValueKind.Single>(bean, parentProperty, (String)toBuildEntry.getKey(), ((ToBuild)toBuildEntry.getValue()).getter, ((ToBuild)toBuildEntry.getValue()).setter, ValueKind.SINGLE, this.createSimpleValueInfo(bean, componentType, ValueKind.ARRAY));
                                break;
                            }
                        }
                    } else {
                        property = new PropertyInfo<SimpleValueInfo, ValueKind.Single>(bean, parentProperty, (String)toBuildEntry.getKey(), ((ToBuild)toBuildEntry.getValue()).getter, ((ToBuild)toBuildEntry.getValue()).setter, ValueKind.SINGLE, this.createSimpleValueInfo(bean, componentType, ValueKind.ARRAY));
                    }
                } else if (resolvedType instanceof ClassTypeInfo && (related = this.resolve((ClassTypeInfo)resolvedType)) != null) {
                    property = new PropertyInfo<BeanValueInfo, ValueKind.Single>(bean, parentProperty, (String)toBuildEntry.getKey(), ((ToBuild)toBuildEntry.getValue()).getter, ((ToBuild)toBuildEntry.getValue()).setter, ValueKind.SINGLE, new BeanValueInfo(type, bean.resolveToClass(type), related));
                }
                if (property == null) {
                    property = new PropertyInfo<SimpleValueInfo, ValueKind.Single>(bean, parentProperty, (String)toBuildEntry.getKey(), ((ToBuild)toBuildEntry.getValue()).getter, ((ToBuild)toBuildEntry.getValue()).setter, ValueKind.SINGLE, this.createSimpleValueInfo(bean, type, ValueKind.SINGLE));
                }
                properties.put(property.getName(), property);
            }
            bean.properties.putAll(properties);
        }

        private <K extends ValueKind> SimpleValueInfo createSimpleValueInfo(BeanInfo bean, TypeInfo type, K valueKind) {
            TypeInfo resolvedType = bean.getClassType().resolve(type);
            SimpleTypeMapping mapping = BeanInfoBuilder.this.simpleTypeResolver.resolveType(resolvedType);
            return new SimpleValueInfo<K>(type, resolvedType, mapping, valueKind);
        }

        class ToBuild {
            final TypeInfo type;
            final MethodInfo getter;
            final MethodInfo setter;

            ToBuild(TypeInfo type, MethodInfo getter, MethodInfo setter) {
                this.type = type;
                this.getter = getter;
                this.setter = setter;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class BeanHierarchyVisitorStrategy<V extends HierarchyVisitor<V>>
        extends HierarchyVisitorStrategy<V> {
            private final ClassTypeInfo current;

            private BeanHierarchyVisitorStrategy(ClassTypeInfo current) {
                this.current = current;
            }

            protected boolean accept(ClassTypeInfo type) {
                return type == this.current || !Context.this.classTypes.contains(type);
            }
        }
    }
}

