/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.deployment;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.services.deployment.DeploymentPlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.picocontainer.Startable;

public class ContentInitializerService
implements Startable {
    private List<DeploymentPlugin> listDeploymentPlugin = new ArrayList<DeploymentPlugin>();
    private RepositoryService repositoryService;
    private NodeHierarchyCreator nodeHierarchyCreator;
    private Log LOG = ExoLogger.getLogger(this.getClass());
    private static String CONTENT_INIT = "ContentInitializerService";
    private static String EXO_SERVICES = "eXoServices";

    public ContentInitializerService(RepositoryService repositoryService, NodeHierarchyCreator nodeHierarchyCreator, OrganizationService organizationService) {
        this.repositoryService = repositoryService;
        this.nodeHierarchyCreator = nodeHierarchyCreator;
    }

    public void addPlugin(DeploymentPlugin deploymentPlugin) {
        this.listDeploymentPlugin.add(deploymentPlugin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            ManageableRepository repository = this.repositoryService.getCurrentRepository();
            Session session = sessionProvider.getSession(repository.getConfiguration().getDefaultWorkspaceName(), repository);
            Node serviceFolder = (Node)session.getItem(this.nodeHierarchyCreator.getJcrPath(EXO_SERVICES));
            Node contentInitializerService = null;
            contentInitializerService = serviceFolder.hasNode(CONTENT_INIT) ? serviceFolder.getNode(CONTENT_INIT) : serviceFolder.addNode(CONTENT_INIT, "nt:unstructured");
            if (!contentInitializerService.hasNode("ContentInitializerServiceLog")) {
                Date date = new Date();
                StringBuffer logData = new StringBuffer();
                for (DeploymentPlugin deploymentPlugin : this.listDeploymentPlugin) {
                    try {
                        deploymentPlugin.deploy(sessionProvider);
                        logData.append("deploy " + deploymentPlugin.getName() + " deployment plugin succesful at " + date.toString() + "\n");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.LOG.error((Object)("deploy " + deploymentPlugin.getName() + " deployment plugin failure at " + date.toString() + " by " + e.getMessage() + "\n"));
                        logData.append("deploy " + deploymentPlugin.getName() + " deployment plugin failure at " + date.toString() + " by " + e.getMessage() + "\n");
                    }
                }
                Node contentInitializerServiceLog = contentInitializerService.addNode("ContentInitializerServiceLog", "nt:file");
                Node contentInitializerServiceLogContent = contentInitializerServiceLog.addNode("jcr:content", "nt:resource");
                contentInitializerServiceLogContent.setProperty("jcr:encoding", "UTF-8");
                contentInitializerServiceLogContent.setProperty("jcr:mimeType", "text/plain");
                contentInitializerServiceLogContent.setProperty("jcr:data", logData.toString());
                contentInitializerServiceLogContent.setProperty("jcr:lastModified", date.getTime());
                session.save();
            }
        }
        catch (Exception e) {
            this.LOG.error((Object)"An unexpected problem occurs when deploy contents", (Throwable)e);
        }
        finally {
            sessionProvider.close();
        }
    }

    public void stop() {
    }
}

