/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.faq.service.Answer;
import org.exoplatform.faq.service.Category;
import org.exoplatform.faq.service.Comment;
import org.exoplatform.faq.service.FAQServiceUtils;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.FileAttachment;
import org.exoplatform.faq.service.JCRPageList;
import org.exoplatform.faq.service.ObjectSearchResult;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.service.Utils;
import org.exoplatform.faq.service.Watch;
import org.exoplatform.ks.common.CommonUtils;
import org.exoplatform.ks.common.jcr.PropertyReader;
import org.exoplatform.ks.common.jcr.SessionManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuestionPageList
extends JCRPageList {
    private NodeIterator iter_ = null;
    private boolean isQuery_ = false;
    private String value_;
    private boolean isNotYetAnswered = false;
    private boolean isOpenQuestion = false;
    private List<Question> listQuestions_ = null;
    private List<ObjectSearchResult> listFAQFormSearchS_ = null;
    private List<Watch> listWatchs_ = null;
    private List<Category> listCategories_ = null;
    private String questionQuery_ = "";
    private Node nodeCategory_ = null;
    private List<Object> listObject_ = new ArrayList<Object>();
    private FAQSetting faqSetting_ = null;
    private static final String ANSWER_HOME = "faqAnswerHome".intern();
    private static final String COMMENT_HOME = "faqCommentHome".intern();
    private SessionManager sessionManager = FAQServiceUtils.getSessionManager();
    private static Log log = ExoLogger.getLogger(QuestionPageList.class);

    public void setNotYetAnswered(boolean isNotYetAnswered) {
        this.isNotYetAnswered = isNotYetAnswered;
        try {
            this.setTotalQuestion();
        }
        catch (Exception e) {
            log.error((Object)"Fail to set total questions: ", (Throwable)e);
        }
    }

    public void setOpenQuestion(boolean isOpenQuestion) {
        this.isOpenQuestion = isOpenQuestion;
    }

    private void setTotalQuestion() throws Exception {
        this.listQuestions_ = new ArrayList<Question>();
        if (this.iter_ == null || !this.iter_.hasNext()) {
            Session session = this.getJCRSession();
            if (this.isQuery_) {
                QueryManager qm = session.getWorkspace().getQueryManager();
                Query query = qm.createQuery(this.value_, "xpath");
                QueryResult result = query.execute();
                this.iter_ = result.getNodes();
            } else {
                Node node = (Node)session.getItem(this.value_);
                this.iter_ = node.getNodes();
            }
        }
        NodeIterator nodeIterator = this.iter_;
        NodeIterator languageIter = null;
        Node questionNode = null;
        Node languageNode = null;
        while (nodeIterator.hasNext()) {
            StringBuilder languages = new StringBuilder();
            questionNode = nodeIterator.nextNode();
            if (!this.isOpenQuestion) {
                try {
                    if (!questionNode.hasNode(ANSWER_HOME) || questionNode.getNode(ANSWER_HOME).getNodes().getSize() < 1L) {
                        languages.append(questionNode.getProperty("exo:language").getValue().getString());
                    }
                    if (questionNode.hasNode("languages")) {
                        languageNode = questionNode.getNode("languages");
                        languageIter = languageNode.getNodes();
                        while (languageIter.hasNext()) {
                            Node language = languageIter.nextNode();
                            if (language.hasNode(ANSWER_HOME) && language.getNode(ANSWER_HOME).getNodes().getSize() >= 1L) continue;
                            if (languages.length() > 0) {
                                languages.append(",");
                            }
                            languages.append(language.getProperty("exo:language").getString());
                        }
                    }
                    if (languages.length() <= 0) continue;
                    this.listQuestions_.add(this.getQuestion(questionNode).setLanguagesNotYetAnswered(languages.toString()));
                }
                catch (Exception e) {
                    log.error((Object)"Fail to set total questions: ", (Throwable)e);
                }
                continue;
            }
            try {
                if (this.hasAnswerInQuestion(questionNode)) continue;
                this.listQuestions_.add(this.getQuestion(questionNode));
            }
            catch (Exception e) {
                log.error((Object)"Fail to set total questions: ", (Throwable)e);
            }
        }
        this.setAvailablePage(this.listQuestions_.size());
        this.iter_ = null;
        this.closeSession();
    }

    private boolean hasAnswerInQuestion(Node questionNode) throws Exception {
        StringBuffer queryString;
        QueryManager qm = questionNode.getSession().getWorkspace().getQueryManager();
        Query query = qm.createQuery((queryString = new StringBuffer("/jcr:root").append(questionNode.getPath()).append("//element(*,exo:answer)[(@exo:approveResponses='true') and (@exo:activateResponses='true')]")).toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        return iter.getSize() > 0L;
    }

    public QuestionPageList(NodeIterator iter, long pageSize, String value, boolean isQuery) throws Exception {
        super(pageSize);
        this.value_ = value;
        this.isQuery_ = isQuery;
        this.setAvailablePage(iter.getSize());
    }

    public QuestionPageList(List<ObjectSearchResult> faqFormSearchs, long pageSize) throws Exception {
        super(pageSize);
        this.listFAQFormSearchS_ = faqFormSearchs;
        this.setAvailablePage(faqFormSearchs.size());
    }

    public QuestionPageList(List<Watch> listWatch, double page) throws Exception {
        super(10L);
        this.listWatchs_ = listWatch;
        this.setAvailablePage(listWatch.size());
    }

    public QuestionPageList(List<Category> listCategories) throws Exception {
        super(10L);
        this.listCategories_ = listCategories;
        this.setAvailablePage(listCategories.size());
    }

    public QuestionPageList(List<Question> listQuestions, int size) throws Exception {
        super(10L);
        this.listQuestions_ = listQuestions;
        this.setAvailablePage(size);
    }

    public QuestionPageList(Node categoryNode, String quesQuerry, List<Object> listObject, FAQSetting setting) throws Exception {
        super(10L);
        this.questionQuery_ = quesQuerry;
        this.nodeCategory_ = categoryNode;
        this.listObject_.addAll(listObject);
        this.faqSetting_ = setting;
        this.setAvailablePage(listObject.size());
    }

    @Override
    protected void populateCurrentPage(long page, String username) throws Exception {
        if (this.iter_ == null || !this.iter_.hasNext()) {
            Session session = this.getJCRSession();
            if (this.isQuery_) {
                QueryManager qm = session.getWorkspace().getQueryManager();
                Query query = qm.createQuery(this.value_, "xpath");
                QueryResult result = query.execute();
                this.iter_ = result.getNodes();
            } else {
                Node node = (Node)session.getItem(this.value_);
                this.iter_ = node.getNodes();
            }
            if (this.isNotYetAnswered) {
                this.setTotalQuestion();
            }
        }
        if (this.isNotYetAnswered) {
            this.setAvailablePage(this.listQuestions_.size());
        } else {
            this.setAvailablePage(this.iter_.getSize());
        }
        long pageSize = this.getPageSize();
        long position = 0L;
        position = page == 1L ? 0L : (page - 1L) * pageSize;
        this.currentListPage_ = new ArrayList();
        if (!this.isNotYetAnswered) {
            this.iter_.skip(position);
            Question question = new Question();
            int i = 0;
            while ((long)i < pageSize && this.iter_ != null && this.iter_.hasNext()) {
                question = this.getQuestion(this.iter_.nextNode());
                this.currentListPage_.add(question);
                ++i;
            }
        } else {
            pageSize += position;
            for (int i = (int)position; (long)i < pageSize && i < this.listQuestions_.size(); ++i) {
                this.currentListPage_.add(this.listQuestions_.get(i));
            }
        }
        this.iter_ = null;
        this.closeSession();
    }

    @Override
    protected void populateCurrentPageItem(long page) throws Exception {
        if (this.iter_ == null || !this.iter_.hasNext()) {
            Session session = this.getJCRSession();
            if (this.isQuery_) {
                QueryManager qm = session.getWorkspace().getQueryManager();
                Query query = qm.createQuery(this.value_, "xpath");
                QueryResult result = query.execute();
                this.iter_ = result.getNodes();
            } else {
                Node node = (Node)session.getItem(this.value_);
                this.iter_ = node.getNodes();
            }
            this.setAvailablePage(this.iter_.getSize());
            this.checkAndSetPage(page);
            page = this.currentPage_;
        }
        long pageSize = this.getPageSize();
        long position = 0L;
        if (page == 1L) {
            position = 0L;
        } else if (page > 1L) {
            position = (page - 1L) * pageSize;
            this.iter_.skip(position);
        } else {
            pageSize = this.iter_.getSize();
        }
        this.currentListObject_ = new ArrayList();
        int i = 0;
        while ((long)i < pageSize && this.iter_.hasNext()) {
            Node currentNode = this.iter_.nextNode();
            if (currentNode.isNodeType("exo:answer")) {
                this.currentListObject_.add(this.getAnswerByNode(currentNode));
            } else if (currentNode.isNodeType("exo:comment")) {
                this.currentListObject_.add(this.getCommentByNode(currentNode));
            }
            ++i;
        }
        this.iter_ = null;
        this.closeSession();
    }

    @Override
    protected void populateCurrentPageWatch(long page, String username) throws Exception {
        if (this.iter_ == null || !this.iter_.hasNext()) {
            Session session = this.getJCRSession();
            QueryManager qm = session.getWorkspace().getQueryManager();
            Query query = qm.createQuery(this.value_, "xpath");
            QueryResult result = query.execute();
            this.iter_ = result.getNodes();
        }
        long pageSize = this.getPageSize();
        long position = 0L;
        position = page <= 1L ? 0L : (page - 1L) * pageSize;
        this.currentListWatch_ = new ArrayList();
        Node watchNode = null;
        int count = 0;
        while (this.iter_.hasNext()) {
            ++count;
            watchNode = this.iter_.nextNode();
            this.currentListWatch_.addAll(this.getWatchs(watchNode, false, (int)position, (int)pageSize));
        }
        this.iter_ = null;
        this.closeSession();
    }

    @Override
    protected void populateCurrentPageResultSearch(long page, String username) throws Exception {
        long pageSize = this.getPageSize();
        long position = 0L;
        position = page == 1L ? 0L : (page - 1L) * pageSize;
        pageSize *= page;
        this.currentListResultSearch_ = new ArrayList();
        for (int i = (int)position; (long)i < pageSize && i < this.listFAQFormSearchS_.size(); ++i) {
            this.currentListResultSearch_.add(this.listFAQFormSearchS_.get(i));
        }
    }

    @Override
    protected void populateCurrentPageCategoriesSearch(long page, String username) throws Exception {
        long pageSize = this.getPageSize();
        long position = 0L;
        if (!this.isQuery_) {
            position = page == 1L ? 0L : (page - 1L) * pageSize;
            pageSize *= page;
            this.currentListCategory_ = new ArrayList();
            for (int i = (int)position; (long)i < pageSize && i < this.listCategories_.size(); ++i) {
                this.currentListCategory_.add(this.listCategories_.get(i));
            }
        } else {
            if (this.iter_ == null || !this.iter_.hasNext()) {
                Session session = this.getJCRSession();
                QueryManager qm = session.getWorkspace().getQueryManager();
                Query query = qm.createQuery(this.value_, "xpath");
                QueryResult result = query.execute();
                this.iter_ = result.getNodes();
            }
            this.setAvailablePage(this.iter_.getSize());
            position = page == 1L ? 0L : (page - 1L) * pageSize;
            this.currentListCategory_ = new ArrayList();
            this.iter_.skip(position);
            Category category = null;
            int i = 0;
            while ((long)i < pageSize && this.iter_ != null && this.iter_.hasNext()) {
                category = this.getCategory(this.iter_.nextNode());
                this.currentListCategory_.add(category);
                ++i;
            }
            this.iter_ = null;
            this.closeSession();
        }
    }

    @Override
    protected void populateCurrentPageQuestionsSearch(long page, String username) throws Exception {
        long pageSize = this.getPageSize();
        long position = 0L;
        position = page == 1L ? 0L : (page - 1L) * pageSize;
        pageSize *= page;
        this.currentListPage_ = new ArrayList();
        for (int i = (int)position; (long)i < pageSize && i < this.listQuestions_.size(); ++i) {
            this.currentListPage_.add(this.listQuestions_.get(i));
        }
    }

    @Override
    protected void populateCurrentPageCategoriesQuestionsSearch(long page, String username) throws Exception {
        String idSearch = this.getObjectId();
        int posSearch = 0;
        if (this.listObject_ == null || this.listObject_.isEmpty()) {
            this.listObject_ = new ArrayList<Object>();
            int size = 0;
            Session session = this.getJCRSession();
            QueryManager qm = session.getWorkspace().getQueryManager();
            Query query = qm.createQuery(this.questionQuery_, "xpath");
            QueryResult result = query.execute();
            this.iter_ = result.getNodes();
            Question question = null;
            while (this.iter_.hasNext()) {
                question = this.getQuestion(this.iter_.nextNode());
                if (!question.getId().equals(idSearch)) {
                    ++size;
                } else {
                    posSearch = size + 1;
                }
                this.listObject_.add(question);
            }
            this.iter_ = null;
            this.iter_ = this.nodeCategory_.getNodes();
            ArrayList<Category> listCategory = new ArrayList<Category>();
            while (this.iter_.hasNext()) {
                listCategory.add(this.getCategory(this.iter_.nextNode()));
            }
            if (this.faqSetting_.getOrderBy().equals("created")) {
                if (this.faqSetting_.getOrderType().equals("asc")) {
                    Collections.sort(listCategory, new Utils.DatetimeComparatorASC());
                } else {
                    Collections.sort(listCategory, new Utils.DatetimeComparatorDESC());
                }
            } else if (this.faqSetting_.getOrderType().equals("asc")) {
                Collections.sort(listCategory, new Utils.NameComparatorASC());
            } else {
                Collections.sort(listCategory, new Utils.NameComparatorDESC());
            }
            this.listObject_.addAll(listCategory);
            if (this.getAvailablePage() < (long)this.listObject_.size()) {
                this.setAvailablePage(this.listObject_.size());
            }
            this.iter_ = null;
            this.closeSession();
        }
        long pageSize = this.getPageSize();
        long position = 0L;
        if (posSearch > 0) {
            int t = (posSearch /= (int)pageSize) % (int)pageSize;
            if (t > 0 || posSearch == 0) {
                ++posSearch;
            }
            page = posSearch;
            this.setObjectId(null);
        }
        this.setPageJump(page);
        position = page == 1L ? 0L : (page - 1L) * pageSize;
        pageSize *= page;
        this.currentListObject_ = new ArrayList();
        for (int i = (int)position; (long)i < pageSize && i < this.listObject_.size(); ++i) {
            this.currentListObject_.add(this.listObject_.get(i));
        }
        this.listObject_ = null;
    }

    private Question getQuestion(Node questionNode) throws Exception {
        Question question = new Question();
        question.setId(questionNode.getName());
        PropertyReader reader = new PropertyReader(questionNode);
        question.setLanguage(reader.string("exo:language", ""));
        question.setDetail(reader.string("exo:name", ""));
        question.setAuthor(reader.string("exo:author", ""));
        question.setEmail(reader.string("exo:email", ""));
        question.setQuestion(reader.string("exo:title", ""));
        question.setCreatedDate(reader.date("exo:createdDate", CommonUtils.getGreenwichMeanTime().getTime()));
        question.setCategoryId(reader.string("exo:categoryId", ""));
        question.setActivated(reader.bool("exo:isActivated", true));
        question.setApproved(reader.bool("exo:isApproved", true));
        question.setRelations(reader.strings("exo:relatives", new String[0]));
        question.setNameAttachs(reader.strings("exo:nameAttachs", new String[0]));
        question.setUsersVote(reader.strings("exo:usersVote", new String[0]));
        question.setMarkVote(reader.d("exo:markVote"));
        question.setEmailsWatch(reader.strings("exo:emailWatching", new String[0]));
        question.setUsersWatch(reader.strings("exo:userWatching", new String[0]));
        question.setTopicIdDiscuss(reader.string("exo:topicIdDiscuss"));
        question.setLastActivity(reader.string("exo:lastActivity", ""));
        question.setNumberOfPublicAnswers(reader.l("exo:numberOfPublicAnswers"));
        String path = questionNode.getPath();
        question.setPath(path.substring(path.indexOf(Utils.FAQ_APP) + Utils.FAQ_APP.length() + 1));
        ArrayList<FileAttachment> listFile = new ArrayList<FileAttachment>();
        NodeIterator nodeIterator = questionNode.getNodes();
        FileAttachment attachment = null;
        String workspace = questionNode.getSession().getWorkspace().getName();
        while (nodeIterator.hasNext()) {
            Node node = nodeIterator.nextNode();
            if (!node.isNodeType("exo:faqAttachment")) continue;
            attachment = new FileAttachment();
            Node nodeFile = node.getNode("jcr:content");
            attachment.setId(node.getPath());
            attachment.setMimeType(nodeFile.getProperty("jcr:mimeType").getString());
            attachment.setNodeName(node.getName());
            attachment.setName(nodeFile.getProperty("exo:fileName").getValue().getString());
            attachment.setWorkspace(workspace);
            attachment.setPath("/" + workspace + node.getPath());
            try {
                if (nodeFile.hasProperty("jcr:data")) {
                    attachment.setSize(nodeFile.getProperty("jcr:data").getStream().available());
                } else {
                    attachment.setSize(0L);
                }
            }
            catch (Exception e) {
                attachment.setSize(0L);
            }
            listFile.add(attachment);
        }
        question.setAttachMent(listFile);
        question.setAnswers(this.getAnswers(questionNode));
        question.setComments(this.getComment(questionNode));
        return question;
    }

    public Answer[] getAnswers(Node questionNode) throws Exception {
        try {
            if (!questionNode.hasNode(ANSWER_HOME)) {
                return new Answer[0];
            }
            NodeIterator nodeIterator = questionNode.getNode(ANSWER_HOME).getNodes();
            Answer[] answers = new Answer[(int)nodeIterator.getSize()];
            Node answerNode = null;
            int i = 0;
            while (nodeIterator.hasNext()) {
                answerNode = nodeIterator.nextNode();
                answers[i] = this.getAnswerByNode(answerNode);
                ++i;
            }
            return answers;
        }
        catch (Exception e) {
            return new Answer[0];
        }
    }

    public Answer getAnswerByNode(Node answerNode) throws Exception {
        Answer answer = new Answer();
        answer.setId(answerNode.getName());
        PropertyReader reader = new PropertyReader(answerNode);
        answer.setResponses(reader.string("exo:responses", ""));
        answer.setResponseBy(reader.string("exo:responseBy", ""));
        answer.setFullName(reader.string("exo:fullName", ""));
        answer.setDateResponse(reader.date("exo:dateResponse", CommonUtils.getGreenwichMeanTime().getTime()));
        answer.setUsersVoteAnswer(reader.strings("exo:usersVoteAnswer", new String[0]));
        answer.setMarkVotes(reader.l("exo:MarkVotes"));
        answer.setApprovedAnswers(reader.bool("exo:approveResponses", true));
        answer.setActivateAnswers(reader.bool("exo:activateResponses", true));
        answer.setPostId(reader.string("exo:postId", ""));
        String path = answerNode.getPath();
        answer.setPath(path.substring(path.indexOf(Utils.FAQ_APP) + Utils.FAQ_APP.length() + 1));
        return answer;
    }

    public Comment[] getComment(Node questionNode) throws Exception {
        try {
            if (!questionNode.hasNode(COMMENT_HOME)) {
                return new Comment[0];
            }
            NodeIterator nodeIterator = questionNode.getNode(COMMENT_HOME).getNodes();
            Comment[] comments = new Comment[(int)nodeIterator.getSize()];
            Node commentNode = null;
            int i = 0;
            while (nodeIterator.hasNext()) {
                commentNode = nodeIterator.nextNode();
                comments[i] = this.getCommentByNode(commentNode);
                ++i;
            }
            return comments;
        }
        catch (Exception e) {
            log.error((Object)"Fail to get comments: ", (Throwable)e);
            return new Comment[0];
        }
    }

    public Comment getCommentByNode(Node commentNode) throws Exception {
        Comment comment = new Comment();
        comment.setId(commentNode.getName());
        PropertyReader reader = new PropertyReader(commentNode);
        comment.setComments(reader.string("exo:comments", ""));
        comment.setCommentBy(reader.string("exo:commentBy", ""));
        comment.setFullName(reader.string("exo:fullName", ""));
        comment.setDateComment(reader.date("exo:dateComment", CommonUtils.getGreenwichMeanTime().getTime()));
        comment.setPostId(reader.string("exo:postId", ""));
        return comment;
    }

    private Category getCategory(Node categoryNode) throws Exception {
        Category cat = new Category();
        PropertyReader reader = new PropertyReader(categoryNode);
        cat.setId(categoryNode.getName());
        cat.setName(reader.string("exo:name", ""));
        cat.setDescription(reader.string("exo:description", ""));
        cat.setCreatedDate(reader.date("exo:createdDate", CommonUtils.getGreenwichMeanTime().getTime()));
        cat.setModerators(reader.strings("exo:moderators", new String[0]));
        cat.setUserPrivate(reader.strings("exo:userPrivate", new String[0]));
        cat.setModerateQuestions(reader.bool("exo:isModerateQuestions", false));
        String path = categoryNode.getPath();
        cat.setPath(path.substring(path.indexOf(Utils.FAQ_APP) + Utils.FAQ_APP.length() + 1));
        return cat;
    }

    private List<Watch> getWatchs(Node watchNode, boolean isGetAll, int start, int max) throws Exception {
        ArrayList<Watch> listWatches = new ArrayList<Watch>();
        PropertyReader reader = new PropertyReader(watchNode);
        String[] emails = reader.strings("exo:emailWatching", new String[0]);
        String[] userWatch = reader.strings("exo:userWatching", new String[0]);
        String[] RSS = reader.strings("exo:rssWatching", new String[0]);
        if (userWatch != null) {
            if (isGetAll) {
                start = 0;
                max = userWatch.length;
            } else {
                max += start;
                this.setAvailablePage(userWatch.length);
            }
        }
        for (int i = start; i < max && i < userWatch.length; ++i) {
            Watch watch = new Watch();
            watch.setEmails(emails[i]);
            watch.setUser(userWatch[i]);
            if (i < RSS.length) {
                watch.setRSS(RSS[i]);
            }
            listWatches.add(watch);
        }
        return listWatches;
    }

    @Override
    public List<Question> getAll() throws Exception {
        if (this.iter_ == null || !this.iter_.hasNext()) {
            Session session = this.getJCRSession();
            if (this.isQuery_) {
                QueryManager qm = session.getWorkspace().getQueryManager();
                Query query = qm.createQuery(this.value_, "xpath");
                QueryResult result = query.execute();
                this.iter_ = result.getNodes();
            } else {
                Node node = (Node)session.getItem(this.value_);
                this.iter_ = node.getNodes();
            }
        }
        ArrayList<Question> questions = new ArrayList<Question>();
        while (this.iter_.hasNext()) {
            Node questionNode = this.iter_.nextNode();
            questions.add(this.getQuestion(questionNode));
        }
        this.iter_ = null;
        this.closeSession();
        return questions;
    }

    public List<Watch> getAllWatch() throws Exception {
        ArrayList<Watch> listWatches = new ArrayList<Watch>();
        if (this.iter_ == null) {
            Session session = this.getJCRSession();
            if (this.isQuery_) {
                QueryManager qm = session.getWorkspace().getQueryManager();
                Query query = qm.createQuery(this.value_, "xpath");
                QueryResult result = query.execute();
                this.iter_ = result.getNodes();
            } else {
                Node node = (Node)session.getItem(this.value_);
                this.iter_ = node.getNodes();
            }
        }
        Node watchNode = null;
        while (this.iter_.hasNext()) {
            watchNode = this.iter_.nextNode();
            listWatches.addAll(this.getWatchs(watchNode, true, 0, 0));
        }
        this.iter_ = null;
        this.closeSession();
        return listWatches;
    }

    @Override
    public void setList(List<Question> contacts) {
    }

    private Session getJCRSession() throws Exception {
        return this.sessionManager.getCurrentSession() != null ? this.sessionManager.getCurrentSession() : this.sessionManager.openSession();
    }

    private void closeSession() throws Exception {
        if (this.sessionManager.getCurrentSession() != null && this.sessionManager.getCurrentSession().isLive()) {
            this.sessionManager.closeSession();
        }
    }
}

