/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.cache;

import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.organization.impl.GroupImpl;
import org.exoplatform.services.organization.impl.MembershipImpl;
import org.exoplatform.services.organization.impl.MembershipTypeImpl;
import org.exoplatform.services.organization.impl.UserImpl;
import org.exoplatform.services.organization.impl.UserProfileImpl;

public class OrganizationCacheHandler {
    private final ExoCache userCache;
    private final ExoCache userProfileCache;
    private final ExoCache membershipCache;
    private final ExoCache membershipTypeCache;
    private final ExoCache groupCache;

    public OrganizationCacheHandler(CacheService cservice) {
        this.userCache = cservice.getCacheInstance(UserImpl.class.getName());
        this.userProfileCache = cservice.getCacheInstance(UserProfileImpl.class.getName());
        this.membershipCache = cservice.getCacheInstance(MembershipImpl.class.getName());
        this.membershipTypeCache = cservice.getCacheInstance(MembershipTypeImpl.class.getName());
        this.groupCache = cservice.getCacheInstance(GroupImpl.class.getName());
    }

    public OrganizationCacheHandler(CacheService cservice, long lifeTime) {
        this(cservice);
        this.userCache.setLiveTime(lifeTime);
        this.userProfileCache.setLiveTime(lifeTime);
        this.membershipCache.setLiveTime(lifeTime);
        this.membershipTypeCache.setLiveTime(lifeTime);
        this.groupCache.setLiveTime(lifeTime);
    }

    public ExoCache getUserProfileCache() {
        return this.userProfileCache;
    }

    public ExoCache getUserCache() {
        return this.userCache;
    }

    public ExoCache getMembershipTypeCache() {
        return this.membershipTypeCache;
    }

    public ExoCache getMembershipCache() {
        return this.membershipCache;
    }

    public ExoCache getGroupCache() {
        return this.groupCache;
    }
}

