/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.common.internal.util.propertyservice;

import com.arjuna.common.util.exceptions.LoadPropertiesException;
import com.arjuna.common.util.exceptions.ManagementPluginException;
import com.arjuna.common.util.exceptions.SavePropertiesException;
import com.arjuna.common.util.propertyservice.PropertyManager;
import com.arjuna.common.util.propertyservice.plugins.PropertyManagementPlugin;
import com.arjuna.common.util.propertyservice.plugins.PropertyManagerIOPlugin;
import com.arjuna.common.util.propertyservice.propertycontainer.PropertyManagerPluginInterface;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class PropertyManagerImpl
implements PropertyManagerPluginInterface {
    private static boolean _verbose = false;
    private PropertyManagerImpl _topLevelPropertyManager = this;
    private HashSet _parentPropertyManagers;
    private HashSet _childPropertyManagers;
    private Properties _properties;
    private String _name;
    private String _associatedUri;
    private String _associatedPluginClassname;

    public PropertyManagerImpl(String name) {
        this._name = name;
        this._parentPropertyManagers = new HashSet();
        this._childPropertyManagers = new HashSet();
        this._properties = new Properties();
        this._associatedUri = null;
    }

    public PropertyManagerImpl(String name, PropertyManagerImpl parent) {
        this(name);
        this._topLevelPropertyManager = parent;
    }

    public PropertyManagerPluginInterface getTopLevelPropertyManager() {
        return this._topLevelPropertyManager;
    }

    public String getName() {
        return this._name;
    }

    public String getUri() {
        return this._associatedUri;
    }

    public void setUri(String uri) {
        this._associatedUri = uri;
    }

    public String getIOPluginClassname() {
        return this._associatedPluginClassname;
    }

    public void setIOPluginClassname(String classname) {
        this._associatedPluginClassname = classname;
    }

    public String getProperty(String name) {
        String value = System.getProperty(name);
        value = value != null ? value : this.getPropertyFromSubTree(name);
        return value;
    }

    private String getPropertyFromSubTree(String name) {
        String value = this._properties.getProperty(name);
        if (value == null) {
            Iterator itr = this._parentPropertyManagers.iterator();
            while (itr.hasNext() && value == null) {
                PropertyManagerImpl pm = (PropertyManagerImpl)itr.next();
                value = pm.getPropertyFromSubTree(name);
            }
        }
        return value;
    }

    public String getProperty(String name, String defaultValue) {
        String value = this.getProperty(name);
        return value == null ? defaultValue : value;
    }

    public String setProperty(String name, String value) {
        return this.setProperty(name, value, true);
    }

    public String setProperty(String name, String value, boolean setSystemProperty) {
        String oldValue;
        if (setSystemProperty && System.getProperty(name) != null) {
            System.setProperty(name, value);
        }
        if ((oldValue = this.setLocalProperty(name, value)) == null) {
            this._properties.setProperty(name, value);
        }
        return oldValue;
    }

    public String removeProperty(String name) {
        if (System.getProperty(name) != null) {
            System.getProperties().remove(name);
        }
        String oldValue = this.removeLocalProperty(name);
        return oldValue;
    }

    private String removeLocalProperty(String name) {
        PropertyManagerImpl pm = this;
        String oldValue = this._properties.getProperty(name);
        if (oldValue != null) {
            this._properties.remove(name);
        }
        Iterator itr = this._parentPropertyManagers.iterator();
        while (oldValue == null && itr.hasNext()) {
            pm = (PropertyManagerImpl)itr.next();
            oldValue = pm.removeLocalProperty(name);
        }
        return oldValue;
    }

    private String setLocalProperty(String name, String value) {
        PropertyManagerImpl pm = this;
        String oldValue = this._properties.getProperty(name);
        if (oldValue != null) {
            this._properties.setProperty(name, value);
        }
        Iterator itr = this._parentPropertyManagers.iterator();
        while (oldValue == null && itr.hasNext()) {
            pm = (PropertyManagerImpl)itr.next();
            oldValue = pm.setLocalProperty(name, value);
        }
        return oldValue;
    }

    public Properties getLocalProperties() {
        return this._properties;
    }

    public Properties getProperties() {
        Properties returnProps = this.getAllProperties();
        returnProps.putAll((Map<?, ?>)System.getProperties());
        return returnProps;
    }

    public Properties getAllProperties() {
        Properties returnProps = new Properties();
        for (PropertyManagerImpl pm : this._parentPropertyManagers) {
            returnProps.putAll((Map<?, ?>)pm.getAllProperties());
        }
        returnProps.putAll((Map<?, ?>)this._properties);
        return returnProps;
    }

    public Enumeration propertyNames() {
        return this.getProperties().keys();
    }

    public synchronized void load(String pluginClassname, String uri) throws IOException, ClassNotFoundException, LoadPropertiesException {
        try {
            String classname = System.getProperty("com.arjuna.common.util.propertyservice.pluginclassname");
            classname = classname == null ? pluginClassname : classname;
            PropertyManagerIOPlugin plugin = (PropertyManagerIOPlugin)Thread.currentThread().getContextClassLoader().loadClass(classname).newInstance();
            plugin.load(uri, this._topLevelPropertyManager, _verbose);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LoadPropertiesException("Failed to instantiate plugin: " + e);
        }
    }

    public synchronized void save(String pluginClassname, String uri) throws IOException, ClassNotFoundException, SavePropertiesException {
        try {
            String classname;
            if (pluginClassname == null) {
                pluginClassname = this._associatedPluginClassname;
            }
            classname = (classname = System.getProperty("com.arjuna.common.util.propertyservice.pluginclassname")) == null ? pluginClassname : classname;
            PropertyManagerIOPlugin plugin = (PropertyManagerIOPlugin)Thread.currentThread().getContextClassLoader().loadClass(pluginClassname).newInstance();
            plugin.save(uri, this);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new SavePropertiesException("Failed to instantiate plugin: " + e);
        }
    }

    public boolean verbose() {
        return _verbose;
    }

    public void addChild(PropertyManager pm) {
        if (!this._childPropertyManagers.contains(pm)) {
            this._childPropertyManagers.add(pm);
            ((PropertyManagerImpl)pm).addParent(this);
        }
    }

    public void addParent(PropertyManager pm) {
        if (!this._parentPropertyManagers.contains(pm)) {
            this._parentPropertyManagers.add(pm);
            ((PropertyManagerImpl)pm).addChild(this);
        }
    }

    public PropertyManagerPluginInterface createPropertyManager(String modulename) {
        return new PropertyManagerImpl(modulename, this._topLevelPropertyManager);
    }

    public PropertyManagerPluginInterface[] getParents() {
        PropertyManagerPluginInterface[] pms = new PropertyManagerPluginInterface[this._parentPropertyManagers.size()];
        this._parentPropertyManagers.toArray(pms);
        return pms;
    }

    public PropertyManagerPluginInterface[] getChildren() {
        PropertyManagerPluginInterface[] pms = new PropertyManagerPluginInterface[this._childPropertyManagers.size()];
        this._childPropertyManagers.toArray(pms);
        return pms;
    }

    public void addManagementPlugin(PropertyManagementPlugin plugin) throws IOException, ManagementPluginException {
        try {
            plugin.initialise(this);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ManagementPluginException(e.toString());
        }
    }

    public PropertyManagerPluginInterface getChild(String moduleName) {
        PropertyManagerPluginInterface returnPm = null;
        Iterator itr = this._childPropertyManagers.iterator();
        while (returnPm == null && itr.hasNext()) {
            PropertyManagerImpl pm = (PropertyManagerImpl)itr.next();
            if (!pm.getName().equals(moduleName)) continue;
            returnPm = pm;
        }
        if (returnPm == null) {
            returnPm = this.createPropertyManager(moduleName);
            this.addChild(returnPm);
        }
        return returnPm;
    }

    static {
        String verboseSetting = System.getProperty("com.arjuna.common.util.propertyservice.verbosePropertyManager");
        if (verboseSetting != null && verboseSetting.equalsIgnoreCase("ON")) {
            _verbose = true;
        }
    }
}

