/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.connections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.profile.UIProfileUserSearch;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfigs(value={@ComponentConfig(template="classpath:groovy/social/webui/connections/UIInvitations.gtmpl", events={@EventConfig(listeners={AcceptActionListener.class}), @EventConfig(listeners={DenyActionListener.class}), @EventConfig(listeners={SearchActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={LoadMorePeopleActionListener.class})})})
public class UIInvitations
extends UIContainer {
    private static final Log LOG = ExoLogger.getLogger(UIInvitations.class);
    private static final String INVITATION_REVOKED_INFO = "UIInvitations.label.RevokedInfo";
    UIProfileUserSearch uiProfileUserSearch = (UIProfileUserSearch)this.createUIComponent(UIProfileUserSearch.class, null, "UIProfileUserSearch");
    private static final int RECEIVED_INVITATION_PER_PAGE = 45;
    private boolean loadAtEnd = false;
    private boolean hasUpdated = false;
    private int currentLoadIndex;
    private boolean enableLoadNext;
    private int loadingCapacity;
    private List<Identity> peopleList;
    private ListAccess<Identity> peopleListAccess;
    private int peopleNum;

    public UIInvitations() throws Exception {
        this.uiProfileUserSearch.setHasPeopleTab(true);
        this.addChild((UIComponent)this.uiProfileUserSearch);
        this.init();
    }

    public void init() {
        try {
            this.setHasUpdatedIdentity(false);
            this.setLoadAtEnd(false);
            this.enableLoadNext = false;
            this.currentLoadIndex = 0;
            this.loadingCapacity = 45;
            this.peopleList = new ArrayList<Identity>();
            ArrayList<Identity> excludedIdentityList = new ArrayList<Identity>();
            excludedIdentityList.add(Utils.getViewerIdentity());
            this.uiProfileUserSearch.getProfileFilter().setExcludedIdentityList(excludedIdentityList);
            this.setPeopleList(this.loadPeople(this.currentLoadIndex, this.loadingCapacity));
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void setLoadingCapacity(int loadingCapacity) {
        this.loadingCapacity = loadingCapacity;
    }

    public boolean isEnableLoadNext() {
        return this.enableLoadNext;
    }

    public void setEnableLoadNext(boolean enableLoadNext) {
        this.enableLoadNext = enableLoadNext;
    }

    public boolean isLoadAtEnd() {
        return this.loadAtEnd;
    }

    public void setLoadAtEnd(boolean loadAtEnd) {
        this.loadAtEnd = loadAtEnd;
    }

    public boolean isHasUpdatedIdentity() {
        return this.hasUpdated;
    }

    public void setHasUpdatedIdentity(boolean hasUpdatedIdentity) {
        this.hasUpdated = hasUpdatedIdentity;
    }

    public List<Identity> getPeopleList() throws Exception {
        int realPeopleListSize;
        if (this.isHasUpdatedIdentity()) {
            this.setHasUpdatedIdentity(false);
            this.setPeopleList(this.loadPeople(0, this.peopleList.size()));
        }
        this.setEnableLoadNext((realPeopleListSize = this.peopleList.size()) >= 45 && realPeopleListSize < this.getPeopleNum());
        return this.peopleList;
    }

    public void setPeopleList(List<Identity> peopleList) {
        this.peopleList = peopleList;
    }

    public int getPeopleNum() {
        return this.peopleNum;
    }

    public void setPeopleNum(int peopleNum) {
        this.peopleNum = peopleNum;
    }

    public ListAccess<Identity> getPeopleListAccess() {
        return this.peopleListAccess;
    }

    public void setPeopleListAccess(ListAccess<Identity> peopleListAccess) {
        this.peopleListAccess = peopleListAccess;
    }

    public void loadNext() throws Exception {
        this.currentLoadIndex += this.loadingCapacity;
        this.peopleList.addAll(new ArrayList<Object>(Arrays.asList(this.getPeopleListAccess().load(this.currentLoadIndex, this.loadingCapacity))));
    }

    public void loadSearch() throws Exception {
        this.currentLoadIndex = 0;
        this.setPeopleList(this.loadPeople(this.currentLoadIndex, this.loadingCapacity));
    }

    private List<Identity> loadPeople(int index, int length) throws Exception {
        this.setPeopleListAccess((ListAccess<Identity>)Utils.getRelationshipManager().getIncomingWithListAccess(Utils.getOwnerIdentity()));
        this.setPeopleNum(this.getPeopleListAccess().getSize());
        this.uiProfileUserSearch.setPeopleNum(this.getPeopleNum());
        Identity[] people = (Identity[])this.getPeopleListAccess().load(index, length);
        return new ArrayList<Identity>(Arrays.asList(people));
    }

    public boolean isEditable() {
        return Utils.isOwner();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SearchActionListener
    extends EventListener<UIInvitations> {
        public void execute(Event<UIInvitations> event) throws Exception {
            UIInvitations uiInvitations = (UIInvitations)((Object)event.getSource());
            uiInvitations.loadSearch();
            uiInvitations.setLoadAtEnd(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiInvitations);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DenyActionListener
    extends EventListener<UIInvitations> {
        public void execute(Event<UIInvitations> event) throws Exception {
            UIInvitations uiInvitations = (UIInvitations)((Object)event.getSource());
            String identityId = event.getRequestContext().getRequestParameter("objectId");
            Identity invitedIdentity = Utils.getIdentityManager().getIdentity(identityId, true);
            Identity invitingIdentity = Utils.getViewerIdentity();
            Relationship relationship = Utils.getRelationshipManager().get(invitingIdentity, invitedIdentity);
            uiInvitations.setLoadAtEnd(false);
            if (relationship == null || relationship.getStatus() != Relationship.Type.PENDING) {
                UIApplication uiApplication = event.getRequestContext().getUIApplication();
                uiApplication.addMessage(new ApplicationMessage(UIInvitations.INVITATION_REVOKED_INFO, null, 2));
                return;
            }
            uiInvitations.setHasUpdatedIdentity(true);
            Utils.getRelationshipManager().deny(invitedIdentity, invitingIdentity);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AcceptActionListener
    extends EventListener<UIInvitations> {
        public void execute(Event<UIInvitations> event) throws Exception {
            UIInvitations uiInvitations = (UIInvitations)((Object)event.getSource());
            String identityId = event.getRequestContext().getRequestParameter("objectId");
            Identity invitedIdentity = Utils.getIdentityManager().getIdentity(identityId, true);
            Identity invitingIdentity = Utils.getOwnerIdentity();
            Relationship relationship = Utils.getRelationshipManager().get(invitingIdentity, invitedIdentity);
            uiInvitations.setLoadAtEnd(false);
            if (relationship == null || relationship.getStatus() != Relationship.Type.PENDING) {
                UIApplication uiApplication = event.getRequestContext().getUIApplication();
                uiApplication.addMessage(new ApplicationMessage(UIInvitations.INVITATION_REVOKED_INFO, null, 2));
                return;
            }
            uiInvitations.setHasUpdatedIdentity(true);
            Utils.getRelationshipManager().confirm(invitedIdentity, invitingIdentity);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LoadMorePeopleActionListener
    extends EventListener<UIInvitations> {
        public void execute(Event<UIInvitations> event) throws Exception {
            UIInvitations uiInvitations = (UIInvitations)((Object)event.getSource());
            if (uiInvitations.currentLoadIndex < uiInvitations.peopleNum) {
                uiInvitations.loadNext();
            } else {
                uiInvitations.setEnableLoadNext(false);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiInvitations);
        }
    }
}

