/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="classpath:groovy/social/webui/space/UISpaceMenu.gtmpl", events={@EventConfig(name="RenameSpaceAppName", listeners={RenameSpaceAppNameActionListener.class})})
public class UISpaceMenu
extends UIContainer {
    private static final Log LOG = ExoLogger.getLogger(UISpaceMenu.class);
    private static final String NEW_SPACE_APPLICATION_NAME = "newSpaceAppName";
    private static final String INVALID_APPLICATION_NAME_MSG = "UISpaceMenuPortlet.msg.invalidAppName";
    private static final String EXISTING_APPLICATION_NAME_MSG = "UISpaceMenuPortlet.msg.existingAppName";
    private static final String SPACE_HOME_APP_NAME = "UISpaceMenu.label.Home";
    private static final String SPACE_SETTINGS = "settings";
    private SpaceService spaceService = null;
    private Space space = null;

    public List<UserNode> getApps() throws Exception {
        String spaceUrl = SpaceUtils.getSpaceUrl();
        SpaceService spaceSrc = (SpaceService)this.getApplicationComponent(SpaceService.class);
        this.space = spaceSrc.getSpaceByUrl(spaceUrl);
        if (this.space == null) {
            return new ArrayList<UserNode>(0);
        }
        UserNavigation pageNav = SpaceUtils.getGroupNavigation((String)this.space.getGroupId());
        UserNode homeNode = SpaceUtils.getHomeNodeWithChildren((UserNavigation)pageNav, (String)this.space.getUrl());
        UserNode hiddenNode = homeNode.getChild(SPACE_SETTINGS);
        if (!this.hasSettingPermission() && hiddenNode != null) {
            homeNode.removeChild(hiddenNode.getName());
        }
        ArrayList<UserNode> userNodeArraySorted = new ArrayList<UserNode>(homeNode.getChildren());
        Collections.sort(userNodeArraySorted, new ApplicationComparator());
        return userNodeArraySorted;
    }

    public String getSpaceName() throws Exception {
        this.space = this.getSpace();
        if (this.space == null) {
            return null;
        }
        return this.space.getDisplayName();
    }

    public String getAppSelected() throws Exception {
        UIPortal uiPortal = Util.getUIPortal();
        UserNode selectedNode = uiPortal.getSelectedUserNode();
        String[] split = selectedNode.getURI().split("/");
        return split[split.length - 1];
    }

    protected String getImageSource() {
        Space space = this.getSpace();
        if (space != null) {
            return space.getAvatarUrl();
        }
        return "";
    }

    protected boolean hasSettingPermission() throws SpaceException {
        this.spaceService = this.getSpaceService();
        String userId = Util.getPortalRequestContext().getRemoteUser();
        Space space = this.getSpace();
        return this.spaceService.hasSettingPermission(space, userId);
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        }
        return this.spaceService;
    }

    private Space getSpace() {
        if (this.space == null) {
            this.spaceService = this.getSpaceService();
            String spaceUrl = SpaceUtils.getSpaceUrl();
            this.space = this.spaceService.getSpaceByUrl(spaceUrl);
        }
        return this.space;
    }

    private boolean isAppNameExisted(UserNode homeNode, String nodeName) throws Exception {
        Collection nodes = homeNode.getChildren();
        for (UserNode node : nodes) {
            if (!node.getName().equals(nodeName)) continue;
            return true;
        }
        String spaceHomeAppName = WebuiRequestContext.getCurrentInstance().getApplicationResourceBundle().getString(SPACE_HOME_APP_NAME);
        return nodeName.equals(spaceHomeAppName);
    }

    private boolean isValidAppName(String appName) {
        if ((appName = appName.trim()) == null || appName.length() < 1) {
            return false;
        }
        if (Character.isDigit(appName.charAt(0)) || appName.charAt(0) == '-') {
            return false;
        }
        for (int i = 0; i < appName.length(); ++i) {
            char c = appName.charAt(i);
            if (Character.isLetter(c) || Character.isDigit(c) || c == '_' || c == '-' || Character.isSpaceChar(c)) continue;
            return false;
        }
        return true;
    }

    protected Space getSpace(String spaceUrl) {
        return this.spaceService.getSpaceByUrl(spaceUrl);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ApplicationComparator
    implements Comparator<UserNode> {
        private ApplicationComparator() {
        }

        @Override
        public int compare(UserNode pageNode1, UserNode pageNode2) {
            return pageNode1.getResolvedLabel().compareToIgnoreCase(pageNode2.getResolvedLabel());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RenameSpaceAppNameActionListener
    extends EventListener<UISpaceMenu> {
        public void execute(Event<UISpaceMenu> event) throws Exception {
            UISpaceMenu spaceMenu = (UISpaceMenu)((Object)event.getSource());
            WebuiRequestContext context = event.getRequestContext();
            String newSpaceAppName = context.getRequestParameter(UISpaceMenu.NEW_SPACE_APPLICATION_NAME);
            UIPortal uiPortal = Util.getUIPortal();
            PortalRequestContext prContext = Util.getPortalRequestContext();
            SpaceService spaceService = (SpaceService)spaceMenu.getApplicationComponent(SpaceService.class);
            String spaceUrl = SpaceUtils.getSpaceUrl();
            Space space = spaceService.getSpaceByUrl(spaceUrl);
            UserNode selectedNode = uiPortal.getSelectedUserNode();
            UserNode homeNode = null;
            UserNavigation spaceNavigation = SpaceUtils.getGroupNavigation((String)space.getGroupId());
            homeNode = SpaceUtils.getHomeNodeWithChildren((UserNavigation)spaceNavigation, (String)spaceUrl);
            if (homeNode == null) {
                throw new Exception("homeNode is null!");
            }
            String oldName = selectedNode.getName();
            String oldUri = selectedNode.getURI();
            if (selectedNode.getResolvedLabel().equals(newSpaceAppName)) {
                prContext.getResponse().sendRedirect(Utils.getSpaceURL(selectedNode));
                return;
            }
            UIApplication uiApp = context.getUIApplication();
            if (!spaceMenu.isValidAppName(newSpaceAppName)) {
                uiApp.addMessage(new ApplicationMessage(UISpaceMenu.INVALID_APPLICATION_NAME_MSG, null, 1));
                prContext.getResponse().sendRedirect(Utils.getSpaceURL(selectedNode));
                return;
            }
            String newNodeName = newSpaceAppName.trim().replace(' ', '_');
            if (spaceMenu.isAppNameExisted(homeNode, newNodeName)) {
                uiApp.addMessage(new ApplicationMessage(UISpaceMenu.EXISTING_APPLICATION_NAME_MSG, null, 2));
                prContext.getResponse().sendRedirect(Utils.getSpaceURL(selectedNode));
                return;
            }
            String installedApps = space.getApp();
            String[] apps = installedApps.split(",");
            String[] appParts = null;
            String editedApp = null;
            String newInstalledApps = null;
            for (String app : apps) {
                if (app.length() == 0 || !(appParts = app.split(":"))[1].equals(oldName)) continue;
                editedApp = appParts[0] + ":" + newNodeName + ":" + appParts[2] + ":" + appParts[3];
                newInstalledApps = installedApps.replaceAll(app, editedApp);
                space.setApp(newInstalledApps);
                spaceService.updateSpace(space);
                break;
            }
            UserNode renamedNode = homeNode.getChild(oldName);
            renamedNode.setName(newNodeName);
            renamedNode.setLabel(newSpaceAppName);
            UserPortalConfigService configService = (UserPortalConfigService)spaceMenu.getApplicationComponent(UserPortalConfigService.class);
            DataStorage dataService = (DataStorage)spaceMenu.getApplicationComponent(DataStorage.class);
            Page page = configService.getPage(renamedNode.getPageRef());
            if (page != null) {
                page.setTitle(newNodeName);
                dataService.save(page);
            }
            UserPortal userPortal = Util.getUIPortalApplication().getUserPortalConfig().getUserPortal();
            userPortal.saveNode(homeNode, null);
            String newUri = renamedNode.getURI();
            if (newUri != null) {
                prContext.getResponse().sendRedirect(Utils.getSpaceURL(renamedNode));
            }
        }
    }
}

