/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import java.util.List;
import java.util.ResourceBundle;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.social.common.ResourceBundleUtil;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.space.UISpaceAddForm;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/social/webui/space/UISpaceSearch.gtmpl", events={@EventConfig(listeners={AddSpaceActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SearchActionListener.class})})
public class UISpaceSearch
extends UIForm {
    public static final String SPACE_SEARCH = "SpaceSearch";
    public static final String SEARCH = "Search";
    static final String ALL = "All";
    public static final String DEFAULT_SPACE_NAME_SEARCH = "name or description";
    static final String RIGHT_INPUT_PATTERN = "^[\\p{L}][\\p{L}._\\- \\d]+$";
    static final String PREFIX_ADDED_FOR_CHECK = "PrefixAddedForCheck";
    private final String POPUP_ADD_SPACE = "UIPopupAddSpace";
    SpaceService spaceService = null;
    private List<Space> spaceList = null;
    String selectedChar = null;
    String spaceNameSearch = null;
    int spaceNum;
    List<String> spaceNameForAutoSuggest = null;
    private boolean isNewSearch;
    String typeOfRelation = null;
    String spaceURL = null;

    public String getSpaceNameSearch() {
        return this.spaceNameSearch;
    }

    public void setSpaceNameSearch(String spaceNameSearch) {
        this.spaceNameSearch = spaceNameSearch;
    }

    public int getSpaceNum() {
        return this.spaceNum;
    }

    public void setSpaceNum(int spaceNum) {
        this.spaceNum = spaceNum;
    }

    public String getTypeOfRelation() {
        return this.typeOfRelation;
    }

    public void setTypeOfRelation(String typeOfRelation) {
        this.typeOfRelation = typeOfRelation;
    }

    public String getSpaceURL() {
        return this.spaceURL;
    }

    public void setSpaceURL(String spaceURL) {
        this.spaceURL = spaceURL;
    }

    public String getCurrentUserName() {
        RequestContext context = RequestContext.getCurrentInstance();
        return context.getRemoteUser();
    }

    protected String getRestContextName() {
        return PortalContainer.getCurrentRestContextName();
    }

    protected String getPortalName() {
        return PortalContainer.getCurrentPortalContainerName();
    }

    public List<String> getSpaceNameForAutoSuggest() {
        return this.spaceNameForAutoSuggest;
    }

    public void setSpaceNameForAutoSuggest(List<String> spaceNameForAutoSuggest) {
        this.spaceNameForAutoSuggest = spaceNameForAutoSuggest;
    }

    public void setSpaceList(List<Space> spaceList) {
        this.spaceList = spaceList;
    }

    public List<Space> getSpaceList() throws Exception {
        return this.spaceList;
    }

    public String getSelectedChar() {
        return this.selectedChar;
    }

    public void setSelectedChar(String selectedChar) {
        this.selectedChar = selectedChar;
    }

    public UISpaceSearch() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(SPACE_SEARCH, null, DEFAULT_SPACE_NAME_SEARCH));
        UIPopupWindow uiPopup = (UIPopupWindow)this.createUIComponent(UIPopupWindow.class, null, "UIPopupAddSpace");
        uiPopup.setShow(false);
        uiPopup.setWindowSize(400, 0);
        this.addChild((UIComponent)uiPopup);
        this.setSelectedChar(ALL);
    }

    public boolean isNewSearch() {
        return this.isNewSearch;
    }

    public void setNewSearch(boolean isNewSearch) {
        this.isNewSearch = isNewSearch;
    }

    protected String getLabelSpaceFound() {
        String labelArg = "UISpaceSearch.label.SpaceFoundListingFilter";
        if (this.getSpaceNum() > 1) {
            labelArg = "UISpaceSearch.label.SpacesFoundListingFilter";
        }
        String searchCondition = this.getSelectedChar();
        if (this.selectedChar == null) {
            labelArg = "UISpaceSearch.label.SpaceFoundListingSearch";
            if (this.getSpaceNum() > 1) {
                labelArg = "UISpaceSearch.label.SpacesFoundListingSearch";
            }
            searchCondition = this.getSpaceNameSearch();
        }
        return ResourceBundleUtil.replaceArguments((String)WebuiRequestContext.getCurrentInstance().getApplicationResourceBundle().getString(labelArg), (String[])new String[]{Integer.toString(this.getSpaceNum()), searchCondition != null ? searchCondition : " "});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddSpaceActionListener
    extends EventListener<UISpaceSearch> {
        public void execute(Event<UISpaceSearch> event) throws Exception {
            UISpaceSearch uiSpaceSearch = (UISpaceSearch)((Object)event.getSource());
            UIPopupWindow uiPopup = (UIPopupWindow)uiSpaceSearch.getChild(UIPopupWindow.class);
            UISpaceAddForm uiAddSpaceForm = (UISpaceAddForm)uiSpaceSearch.createUIComponent(UISpaceAddForm.class, null, null);
            uiPopup.setUIComponent((UIComponent)uiAddSpaceForm);
            uiPopup.setWindowSize(500, 0);
            uiPopup.setShow(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SearchActionListener
    extends EventListener<UISpaceSearch> {
        public void execute(Event<UISpaceSearch> event) throws Exception {
            WebuiRequestContext ctx = event.getRequestContext();
            UISpaceSearch uiSpaceSearch = (UISpaceSearch)((Object)event.getSource());
            String charSearch = ctx.getRequestParameter("objectId");
            ResourceBundle resApp = ctx.getApplicationResourceBundle();
            String defaultSpaceNameAndDesc = resApp.getString(uiSpaceSearch.getId() + ".label.DefaultSpaceNameAndDesc");
            String searchCondition = (String)((UIFormStringInput)uiSpaceSearch.getChildById(UISpaceSearch.SPACE_SEARCH)).getValue();
            if ((searchCondition == null || searchCondition.equals(defaultSpaceNameAndDesc)) && charSearch == null) {
                uiSpaceSearch.setSelectedChar(null);
                uiSpaceSearch.setSpaceNameSearch(null);
                ctx.addUIComponentToUpdateByAjax((UIComponent)uiSpaceSearch);
            } else {
                if (searchCondition != null) {
                    searchCondition = searchCondition.trim();
                }
                if (charSearch != null) {
                    ((UIFormStringInput)uiSpaceSearch.getChildById(UISpaceSearch.SPACE_SEARCH)).setValue((Object)defaultSpaceNameAndDesc);
                }
                uiSpaceSearch.setSelectedChar(charSearch);
                uiSpaceSearch.setSpaceNameSearch(searchCondition);
                uiSpaceSearch.setNewSearch(true);
                Event searchEvent = uiSpaceSearch.getParent().createEvent(UISpaceSearch.SEARCH, Event.Phase.DECODE, ctx);
                if (searchEvent != null) {
                    searchEvent.broadcast();
                }
            }
        }
    }
}

