/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.rightclick.manager;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.control.filter.CanSetPropertyFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotCheckedOutFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotInTrashFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotLockedFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotTrashHomeNodeFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsVersionableFilter;
import org.exoplatform.ecm.webui.component.explorer.control.listener.UIWorkingAreaActionListener;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.webui.ext.manager.UIAbstractManager;
import org.exoplatform.webui.ext.manager.UIAbstractManagerComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(events={@EventConfig(listeners={CheckOutActionListener.class})})
public class CheckOutManageComponent
extends UIAbstractManagerComponent {
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new IsNotInTrashFilter(), new CanSetPropertyFilter(), new IsNotLockedFilter(), new IsNotCheckedOutFilter(), new IsVersionableFilter(), new IsNotTrashHomeNodeFilter()});

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    public static void checkOutManage(Event<? extends UIComponent> event, UIJCRExplorer uiExplorer, UIApplication uiApp) throws Exception {
        String nodePath = event.getRequestContext().getRequestParameter("objectId");
        Matcher matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(nodePath);
        String wsName = null;
        if (!matcher.find()) {
            throw new IllegalArgumentException("The ObjectId is invalid '" + nodePath + "'");
        }
        wsName = matcher.group(1);
        nodePath = matcher.group(2);
        Session session = uiExplorer.getSessionByWorkspace(wsName);
        Node node = uiExplorer.getNodeByPath(nodePath, session);
        nodePath = node.getPath();
        session = node.getSession();
        wsName = session.getWorkspace().getName();
        try {
            node.checkout();
        }
        catch (PathNotFoundException path) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.path-not-found-exception", null, 1));
            return;
        }
        catch (Exception e) {
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            uiExplorer.updateAjax(event);
        }
    }

    public Class<? extends UIAbstractManager> getUIAbstractManagerClass() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CheckOutActionListener
    extends UIWorkingAreaActionListener<CheckOutManageComponent> {
        public void processEvent(Event<CheckOutManageComponent> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((CheckOutManageComponent)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            UIApplication uiApp = (UIApplication)((CheckOutManageComponent)((Object)event.getSource())).getAncestorOfType(UIApplication.class);
            CheckOutManageComponent.checkOutManage(event, uiExplorer, uiApp);
        }
    }
}

