/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.upload;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.jcr.Node;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import org.exoplatform.ecm.webui.component.explorer.upload.UIUploadContainer;
import org.exoplatform.ecm.webui.component.explorer.upload.UIUploadContent;
import org.exoplatform.ecm.webui.component.explorer.upload.UIUploadManager;
import org.exoplatform.services.cms.metadata.MetadataService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={AddActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={CancelActionListener.class})})
public class UIExternalMetadataForm
extends UIForm {
    public void renderExternalList() throws Exception {
        MetadataService metadataService = (MetadataService)this.getApplicationComponent(MetadataService.class);
        for (NodeType nodeType : metadataService.getAllMetadatasNodeType()) {
            UIFormCheckBoxInput uiCheckBox = new UIFormCheckBoxInput(nodeType.getName(), nodeType.getName(), (Object)"");
            if (this.isInternalUse(nodeType)) continue;
            if (this.hasExternalMetadata(nodeType.getName())) {
                uiCheckBox.setChecked(true);
                uiCheckBox.setEnable(false);
            } else {
                uiCheckBox.setChecked(false);
                uiCheckBox.setEnable(true);
            }
            this.addUIFormInput((UIFormInput)uiCheckBox);
        }
    }

    private boolean isInternalUse(NodeType nodeType) throws Exception {
        for (PropertyDefinition pro : nodeType.getPropertyDefinitions()) {
            if (!pro.getName().equals("exo:internalUse")) continue;
            return pro.getDefaultValues()[0].getBoolean();
        }
        return false;
    }

    private boolean hasExternalMetadata(String name) throws Exception {
        UIUploadManager uiUploadManager = (UIUploadManager)this.getAncestorOfType(UIUploadManager.class);
        UIUploadContainer uiUploadContainer = (UIUploadContainer)uiUploadManager.getChild(UIUploadContainer.class);
        Node uploaded = uiUploadContainer.getUploadedNode();
        for (NodeType mixin : uploaded.getMixinNodeTypes()) {
            if (!mixin.getName().equals(name)) continue;
            return true;
        }
        if (uploaded.hasNode("jcr:content")) {
            for (NodeType mixin : uploaded.getNode("jcr:content").getMixinNodeTypes()) {
                if (!mixin.getName().equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public String getLabel(ResourceBundle res, String id) {
        try {
            return res.getString("UIExternalMetadataForm.label." + id);
        }
        catch (MissingResourceException ex) {
            return '_' + id;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddActionListener
    extends EventListener<UIExternalMetadataForm> {
        public void execute(Event<UIExternalMetadataForm> event) throws Exception {
            UIExternalMetadataForm uiExternalMetadataForm = (UIExternalMetadataForm)((Object)event.getSource());
            ArrayList listCheckbox = new ArrayList();
            uiExternalMetadataForm.findComponentOfType(listCheckbox, UIFormCheckBoxInput.class);
            UIUploadManager uiUploadManager = (UIUploadManager)((UIExternalMetadataForm)((Object)event.getSource())).getAncestorOfType(UIUploadManager.class);
            UIUploadContainer uiContainer = (UIUploadContainer)uiUploadManager.getChild(UIUploadContainer.class);
            String metadataName = null;
            Node uploadedNode = uiContainer.getUploadedNode();
            for (int i = 0; i < listCheckbox.size(); ++i) {
                if (!((UIFormCheckBoxInput)listCheckbox.get(i)).isChecked() || !((UIFormCheckBoxInput)listCheckbox.get(i)).isEnable()) continue;
                metadataName = ((UIFormCheckBoxInput)listCheckbox.get(i)).getName();
                if (!uploadedNode.canAddMixin(metadataName)) {
                    UIApplication uiApp = (UIApplication)uiExternalMetadataForm.getAncestorOfType(UIApplication.class);
                    uiApp.addMessage(new ApplicationMessage("UIExternalMetadataForm.msg.can-not-add", null, 1));
                    return;
                }
                uploadedNode.addMixin(metadataName);
                this.createMandatoryPropertyValue(uploadedNode, metadataName);
                uploadedNode.save();
                UIUploadContent uiUploadContent = (UIUploadContent)uiContainer.getChild(UIUploadContent.class);
                uiUploadContent.externalList_.add(metadataName);
            }
            uploadedNode.getSession().save();
            UIPopupWindow uiPopup = (UIPopupWindow)uiUploadManager.getChildById("AddMetadataPopup");
            uiPopup.setShow(false);
            uiPopup.setRendered(false);
            uiContainer.setRenderedChild(UIUploadContent.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiUploadManager);
        }

        private void createMandatoryPropertyValue(Node node, String nodeTypeName) throws Exception {
            NodeTypeManager nodeTypeManager = node.getSession().getWorkspace().getNodeTypeManager();
            NodeType nodeType = nodeTypeManager.getNodeType(nodeTypeName);
            block18: for (PropertyDefinition propertyDefinition : nodeType.getPropertyDefinitions()) {
                if (!propertyDefinition.isMandatory() || propertyDefinition.isAutoCreated() && node.hasProperty(propertyDefinition.getName()) || propertyDefinition.isProtected()) continue;
                String propertyName = propertyDefinition.getName();
                int requiredType = propertyDefinition.getRequiredType();
                if (!propertyDefinition.isMultiple()) {
                    switch (requiredType) {
                        case 1: {
                            node.setProperty(propertyName, "");
                            break;
                        }
                        case 2: {
                            node.setProperty(propertyName, "");
                            break;
                        }
                        case 6: {
                            node.setProperty(propertyName, false);
                            break;
                        }
                        case 3: {
                            node.setProperty(propertyName, 0L);
                            break;
                        }
                        case 4: {
                            node.setProperty(propertyName, 0L);
                            break;
                        }
                        case 5: {
                            node.setProperty(propertyName, (Calendar)new GregorianCalendar());
                            break;
                        }
                        case 9: {
                            node.setProperty(propertyName, "");
                        }
                    }
                    continue;
                }
                switch (requiredType) {
                    case 1: {
                        node.setProperty(propertyName, new String[]{""});
                        continue block18;
                    }
                    case 2: {
                        node.setProperty(propertyName, new String[]{""});
                        continue block18;
                    }
                    case 6: {
                        node.setProperty(propertyName, new Value[]{node.getSession().getValueFactory().createValue(false)});
                        continue block18;
                    }
                    case 3: {
                        node.setProperty(propertyName, new Value[]{node.getSession().getValueFactory().createValue(0L)});
                        continue block18;
                    }
                    case 4: {
                        node.setProperty(propertyName, new Value[]{node.getSession().getValueFactory().createValue(0L)});
                        continue block18;
                    }
                    case 5: {
                        node.setProperty(propertyName, new Value[]{node.getSession().getValueFactory().createValue((Calendar)new GregorianCalendar())});
                        continue block18;
                    }
                    case 9: {
                        node.setProperty(propertyName, new String[0]);
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UIExternalMetadataForm> {
        public void execute(Event<UIExternalMetadataForm> event) throws Exception {
            UIUploadManager uiUploadManager = (UIUploadManager)((UIExternalMetadataForm)((Object)event.getSource())).getAncestorOfType(UIUploadManager.class);
            UIPopupWindow uiPopup = (UIPopupWindow)uiUploadManager.getChildById("AddMetadataPopup");
            uiPopup.setShow(false);
            uiPopup.setRendered(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiUploadManager);
        }
    }
}

