/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.upload;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.upload.UISingleUploadContainer;
import org.exoplatform.ecm.webui.component.explorer.upload.UISingleUploadContent;
import org.exoplatform.ecm.webui.form.UIDialogForm;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.metadata.MetadataService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormMultiValueInputSet;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveActionListener.class}, phase=Event.Phase.DECODE)})
public class UISingleAddMetadataForm
extends UIDialogForm {
    private static final Log LOG = ExoLogger.getLogger((String)"explorer.UISingleAddMetadataForm");
    private String nodeType_;

    public UISingleAddMetadataForm() throws Exception {
        this.setActions(ACTIONS);
    }

    public void setNodeType(String nodeType) {
        this.nodeType_ = nodeType;
    }

    public String getNodeType() {
        return this.nodeType_;
    }

    public String getDialogTemplatePath() {
        this.repositoryName = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getRepositoryName();
        MetadataService metadataService = (MetadataService)this.getApplicationComponent(MetadataService.class);
        try {
            return metadataService.getMetadataPath(this.nodeType_, true);
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected error", (Throwable)e);
            return null;
        }
    }

    public String getTemplate() {
        return this.getDialogTemplatePath();
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getJCRTemplateResourceResolver();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveActionListener
    extends EventListener<UISingleAddMetadataForm> {
        public void execute(Event<UISingleAddMetadataForm> event) throws Exception {
            event.getRequestContext().addUIComponentToUpdateByAjax(((UISingleAddMetadataForm)((Object)event.getSource())).getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddActionListener
    extends EventListener<UISingleAddMetadataForm> {
        public void execute(Event<UISingleAddMetadataForm> event) throws Exception {
            event.getRequestContext().addUIComponentToUpdateByAjax(((UISingleAddMetadataForm)((Object)event.getSource())).getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UISingleAddMetadataForm> {
        public void execute(Event<UISingleAddMetadataForm> event) throws Exception {
            UISingleUploadContainer uiUploadContainer = (UISingleUploadContainer)((UISingleAddMetadataForm)((Object)event.getSource())).getParent();
            uiUploadContainer.removeChild(UISingleAddMetadataForm.class);
            uiUploadContainer.setRenderedChild(UISingleUploadContent.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiUploadContainer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UISingleAddMetadataForm> {
        public void execute(Event<UISingleAddMetadataForm> event) throws Exception {
            UISingleAddMetadataForm uiForm = (UISingleAddMetadataForm)((Object)event.getSource());
            UIJCRExplorer uiJCRExplorer = (UIJCRExplorer)uiForm.getAncestorOfType(UIJCRExplorer.class);
            UISingleUploadContainer uiUploadContainer = (UISingleUploadContainer)uiForm.getAncestorOfType(UISingleUploadContainer.class);
            Node node = uiUploadContainer.getEditNode(uiForm.nodeType_);
            NodeTypeManager ntManager = uiJCRExplorer.getSession().getWorkspace().getNodeTypeManager();
            PropertyDefinition[] props = ntManager.getNodeType(uiForm.getNodeType()).getPropertyDefinitions();
            ArrayList<Value> valueList = new ArrayList<Value>();
            for (PropertyDefinition prop : props) {
                String name = prop.getName();
                String inputName = (String)uiForm.fieldNames.get(name);
                if (prop.isProtected()) continue;
                int requiredType = prop.getRequiredType();
                if (prop.isMultiple()) {
                    if (requiredType == 5) {
                        UIFormDateTimeInput uiFormDateTime = (UIFormDateTimeInput)uiForm.getUIInput(inputName);
                        valueList.add(uiJCRExplorer.getSession().getValueFactory().createValue(uiFormDateTime.getCalendar()));
                        node.setProperty(name, valueList.toArray(new Value[0]));
                        continue;
                    }
                    List values = ((UIFormMultiValueInputSet)uiForm.getUIInput(inputName)).getValue();
                    node.setProperty(name, values.toArray(new String[values.size()]));
                    continue;
                }
                if (requiredType == 6) {
                    UIFormInput uiInput = uiForm.getUIInput(inputName);
                    String value = "false";
                    if (uiInput instanceof UIFormSelectBox) {
                        value = (String)((UIFormSelectBox)uiInput).getValue();
                    }
                    node.setProperty(name, Boolean.parseBoolean(value));
                    continue;
                }
                if (requiredType == 5) {
                    UIFormDateTimeInput cal = (UIFormDateTimeInput)uiForm.getUIInput(inputName);
                    node.setProperty(name, cal.getCalendar());
                    continue;
                }
                if (requiredType != 1) continue;
                String value = (String)((UIFormStringInput)uiForm.getUIInput(inputName)).getValue();
                if (value == null) {
                    value = "";
                }
                node.setProperty(name, value);
            }
            node.save();
            node.getSession().save();
            uiUploadContainer.setRenderedChild(UISingleUploadContent.class);
            uiUploadContainer.removeChild(UISingleAddMetadataForm.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiUploadContainer);
        }
    }
}

