/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.util;

import com.google.caja.lexer.escaping.Escaping;
import com.google.caja.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

public final class RhinoAsserts {
    public static String structuralForm(Object o) {
        final IdentityHashMap visited = new IdentityHashMap();
        RhinoAsserts.walk(o, new JsObjVisitor(){
            int counter = 0;

            @Override
            void visitArray(Scriptable s, Object[] values) {
                if (this.visit(s)) {
                    for (Object value : values) {
                        RhinoAsserts.walk(value, this);
                    }
                }
            }

            @Override
            void visitObject(Scriptable s, List<Pair<String, Object>> props) {
                if (this.visit(s)) {
                    for (Pair<String, Object> prop : props) {
                        RhinoAsserts.walk(prop.b, this);
                    }
                }
            }

            private boolean visit(Object o) {
                VisitationRecord r = (VisitationRecord)visited.get(o);
                if (r == null) {
                    r = new VisitationRecord();
                    visited.put(o, r);
                    return true;
                }
                if (r.key == 0) {
                    r.key = ++this.counter;
                }
                return false;
            }
        });
        final StringBuilder sb = new StringBuilder();
        RhinoAsserts.walk(o, new JsObjVisitor(){

            @Override
            void visitString(String s) {
                sb.append('\"');
                Escaping.escapeJsString((CharSequence)s, true, false, sb);
                sb.append('\"');
            }

            @Override
            void visitNumber(Number n) {
                sb.append(n);
            }

            @Override
            void visitBoolean(Boolean b) {
                sb.append(b);
            }

            @Override
            void visitNull() {
                sb.append("null");
            }

            @Override
            void visitUndefined() {
                sb.append("undefined");
            }

            @Override
            void visitArray(Scriptable s, Object[] values) {
                if (this.checkDupePrefix(s)) {
                    sb.append('[');
                    int n = values.length;
                    for (int i = 0; i < n; ++i) {
                        if (i != 0) {
                            sb.append(", ");
                        }
                        RhinoAsserts.walk(values[i], this);
                    }
                    sb.append(']');
                }
            }

            @Override
            void visitObject(Scriptable s, List<Pair<String, Object>> props) {
                if (this.checkDupePrefix(s)) {
                    sb.append('{');
                    boolean sawOne = false;
                    for (Pair<String, Object> prop : props) {
                        if (sawOne) {
                            sb.append(", ");
                        } else {
                            sawOne = true;
                        }
                        sb.append('\"');
                        Escaping.escapeJsString((CharSequence)prop.a, true, false, sb);
                        sb.append("\": ");
                        RhinoAsserts.walk(prop.b, this);
                    }
                    sb.append('}');
                }
            }

            private boolean checkDupePrefix(Object o) {
                VisitationRecord r = (VisitationRecord)visited.get(o);
                if (r.key == 0) {
                    return true;
                }
                sb.append('#').append(r.key);
                if (r.written) {
                    sb.append('#');
                    return false;
                }
                r.written = true;
                sb.append('=');
                return true;
            }
        });
        return sb.toString();
    }

    private static void walk(Object o, JsObjVisitor visitor) {
        if (o == null) {
            visitor.visitNull();
        } else if (o instanceof String) {
            visitor.visitString((String)o);
        } else if (o instanceof Number) {
            visitor.visitNumber((Number)o);
        } else if (o instanceof Boolean) {
            visitor.visitBoolean((Boolean)o);
        } else if (o instanceof Undefined) {
            visitor.visitUndefined();
        } else if (o instanceof NativeArray) {
            Scriptable s = (Scriptable)o;
            Scriptable globalScope = s.getParentScope();
            Object lengthVal = s.get("length", globalScope);
            int length = ((Number)lengthVal).intValue();
            Object[] elements = new Object[length];
            for (int i = 0; i < length; ++i) {
                elements[i] = s.get(i, globalScope);
            }
            visitor.visitArray(s, elements);
        } else if (o instanceof Scriptable && RhinoAsserts.isBaseObject((Scriptable)o)) {
            Scriptable s = (Scriptable)o;
            Scriptable globalScope = s.getParentScope();
            Object[] ids = s.getIds();
            Arrays.sort(ids, new Comparator<Object>(){

                @Override
                public int compare(Object a, Object b) {
                    if (a instanceof Number) {
                        if (b instanceof Number) {
                            double d = ((Number)a).doubleValue();
                            double e = ((Number)b).doubleValue();
                            return Double.isNaN(d) ? (Double.isNaN(e) ? 0 : 1) : (d < e ? -1 : (d == e ? 0 : 1));
                        }
                        return -1;
                    }
                    if (b instanceof Number) {
                        return 1;
                    }
                    return a.toString().compareTo(b.toString());
                }
            });
            ArrayList<Pair<String, Object>> props = new ArrayList<Pair<String, Object>>();
            for (Object id : ids) {
                Number n;
                int i;
                if (id instanceof Number && (double)(i = (n = (Number)id).intValue()) == n.doubleValue() && i >= 0) {
                    props.add(Pair.pair("" + i, s.get(i, globalScope)));
                    continue;
                }
                String k = id.toString();
                if (k.endsWith("__")) continue;
                props.add(Pair.pair(k, s.get(k, globalScope)));
            }
            visitor.visitObject(s, props);
        } else {
            String typeHint = "";
            if (o instanceof Scriptable) {
                typeHint = " : " + ((Scriptable)o).getClassName();
            }
            throw new IllegalArgumentException("Cannot compare structure of " + o + typeHint);
        }
    }

    private static boolean isBaseObject(Scriptable s) {
        Scriptable proto = s.getPrototype();
        return proto != null && proto.getPrototype() == null;
    }

    private RhinoAsserts() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class JsObjVisitor {
        private JsObjVisitor() {
        }

        void visitString(String s) {
        }

        void visitNumber(Number n) {
        }

        void visitBoolean(Boolean b) {
        }

        void visitNull() {
        }

        void visitUndefined() {
        }

        void visitArray(Scriptable s, Object[] values) {
        }

        void visitObject(Scriptable s, List<Pair<String, Object>> props) {
        }
    }

    private static class VisitationRecord {
        int key;
        boolean written;

        private VisitationRecord() {
        }
    }
}

