/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.convert;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.io.DocumentResult;
import org.dom4j.io.DocumentSource;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.jbpm.jpdl.par.ProcessArchive;

public class Converter {
    private static final String STYLESHEET_NAME = "convert-pdl-2.0-to-3.0.xslt";
    File indir;
    File outdir;
    private static final Log log = LogFactory.getLog((Class)Converter.class);

    public Document convert(Document document) throws Exception {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer(new StreamSource(this.getClass().getResourceAsStream(STYLESHEET_NAME)));
        DocumentSource source = new DocumentSource(document);
        DocumentResult result = new DocumentResult();
        transformer.transform((Source)source, (Result)result);
        return result.getDocument();
    }

    public String convertPar(ProcessArchive pa) {
        try {
            Document doc = DocumentHelper.parseText((String)new String(pa.getEntry("processdefinition.xml")));
            Document doc30 = this.convert(doc);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            this.serializetoXML(bos, doc30);
            return bos.toString();
        }
        catch (DocumentException de) {
            log.error((Object)"Conversion had trouble parsing the 2.0 process definition", (Throwable)de);
        }
        catch (Exception ex) {
            log.error((Object)"Unexpected error in conversion", (Throwable)ex);
        }
        return null;
    }

    public void serializetoXML(OutputStream out, Document document) throws Exception {
        OutputFormat outformat = OutputFormat.createPrettyPrint();
        XMLWriter writer = new XMLWriter(out, outformat);
        writer.write(document);
        writer.flush();
    }

    public static void main(String[] args) throws Exception {
        Converter converter = new Converter();
        if (!converter.parse(args)) {
            System.err.println();
            System.err.println("Usage: java -jar converter.jar input-directory output-directory\n\ninput-directory is the directory where you have 2.0 process archives (*.par)\nThe converted process files will be placed in the output-directory");
            System.exit(1);
        }
        converter.convertPars();
    }

    boolean parse(String[] args) {
        if (args.length != 2) {
            return false;
        }
        this.indir = new File(args[0]);
        if (!this.indir.isDirectory()) {
            System.err.println("Input file " + args[0] + " is not a valid directory name.");
            return false;
        }
        this.outdir = new File(args[1]);
        if (!this.outdir.isDirectory()) {
            System.err.println("Output file " + args[1] + " is not a valid directory name.");
            return false;
        }
        return true;
    }

    void convertPars() throws Exception {
        String[] files = this.indir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".par");
            }
        });
        for (int i = 0; i < files.length; ++i) {
            ZipInputStream zip = new ZipInputStream(new FileInputStream(this.indir.getPath() + "/" + files[i]));
            ProcessArchive pa = new ProcessArchive(zip);
            String xml = this.convertPar(pa);
            ZipOutputStream zippo = new ZipOutputStream(new FileOutputStream(this.outdir.getPath() + "/" + files[i]));
            Iterator iter = pa.getEntries().keySet().iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                zippo.putNextEntry(new ZipEntry(name));
                if ("processdefinition.xml".equalsIgnoreCase(name)) {
                    zippo.write(xml.getBytes());
                } else {
                    zippo.write(pa.getEntry(name));
                }
                zippo.closeEntry();
            }
            zippo.close();
            System.out.println("Converted " + files[i]);
        }
    }
}

