/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.connector.collaboration;

import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.jcr.Node;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import org.exoplatform.ecm.connector.fckeditor.FCKUtils;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.wcm.portal.PortalFolderSchemaHandler;
import org.exoplatform.services.wcm.webcontent.WebContentSchemaHandler;
import org.exoplatform.wcm.connector.BaseConnector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Path(value="/contents/vote/")
public class VoteConnector
extends BaseConnector
implements ResourceContainer {
    @POST
    @Path(value="/star/")
    public Response postStarVote(@FormParam(value="jcrPath") String jcrPath, @FormParam(value="vote") String vote) throws Exception {
        if (jcrPath.contains("%20")) {
            jcrPath = URLDecoder.decode(jcrPath, "UTF-8");
        }
        return this.postVote(null, null, jcrPath, vote, "en");
    }

    @GET
    @Path(value="/star/")
    public Response getStarVote(@QueryParam(value="repositoryName") String repositoryName, @QueryParam(value="workspaceName") String workspaceName, @QueryParam(value="jcrPath") String jcrPath) throws Exception {
        return this.getVote(repositoryName, workspaceName, jcrPath);
    }

    @GET
    @Path(value="/postVote/")
    public Response postVote(@QueryParam(value="repositoryName") String repositoryName, @QueryParam(value="workspaceName") String workspaceName, @QueryParam(value="jcrPath") String jcrPath, @QueryParam(value="vote") String vote, @QueryParam(value="lang") String lang) throws Exception {
        try {
            Node content;
            if (repositoryName == null && workspaceName == null) {
                String[] path = jcrPath.split("/");
                repositoryName = path[1];
                workspaceName = path[2];
                if ((jcrPath = jcrPath.substring(repositoryName.length() + workspaceName.length() + 2)).charAt(1) == '/') {
                    jcrPath.substring(1);
                }
            }
            if ((content = this.getContent(repositoryName, workspaceName, jcrPath, null, false)).isNodeType("mix:votable")) {
                String userName = content.getSession().getUserID();
                this.votingService.vote(content, Double.parseDouble(vote), userName, lang);
            }
        }
        catch (Exception e) {
            Response.serverError().build();
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
        return Response.ok().header("Last-Modified", (Object)dateFormat.format(new Date())).build();
    }

    @GET
    @Path(value="/getVote/")
    public Response getVote(@QueryParam(value="repositoryName") String repositoryName, @QueryParam(value="workspaceName") String workspaceName, @QueryParam(value="jcrPath") String jcrPath) throws Exception {
        try {
            Node content;
            if (repositoryName == null && workspaceName == null) {
                String[] path = jcrPath.split("/");
                repositoryName = path[1];
                workspaceName = path[2];
                if ((jcrPath = jcrPath.substring(repositoryName.length() + workspaceName.length() + 2)).charAt(1) == '/') {
                    jcrPath.substring(1);
                }
            }
            if ((content = this.getContent(repositoryName, workspaceName, jcrPath)).isNodeType("mix:votable")) {
                String votingRate = "";
                if (content.hasProperty("exo:votingRate")) {
                    votingRate = content.getProperty("exo:votingRate").getString();
                }
                String votingTotal = "";
                if (content.hasProperty("exo:voteTotalOfLang")) {
                    votingTotal = content.getProperty("exo:voteTotalOfLang").getString();
                }
                Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                Element element = document.createElement("vote");
                Element rate = document.createElement("rate");
                rate.setTextContent(votingRate);
                Element total = document.createElement("total");
                total.setTextContent(votingTotal);
                element.appendChild(rate);
                element.appendChild(total);
                document.appendChild(element);
                SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
                return Response.ok((Object)new DOMSource(document), (String)"text/xml").header("Last-Modified", (Object)dateFormat.format(new Date())).build();
            }
        }
        catch (Exception e) {
            Response.serverError().build();
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
        return Response.ok().header("Last-Modified", (Object)dateFormat.format(new Date())).build();
    }

    protected Node getRootContentStorage(Node parentNode) throws Exception {
        try {
            PortalFolderSchemaHandler folderSchemaHandler = (PortalFolderSchemaHandler)this.webSchemaConfigService.getWebSchemaHandlerByType(PortalFolderSchemaHandler.class);
            return folderSchemaHandler.getDocumentStorage(parentNode);
        }
        catch (Exception e) {
            WebContentSchemaHandler webContentSchemaHandler = (WebContentSchemaHandler)this.webSchemaConfigService.getWebSchemaHandlerByType(WebContentSchemaHandler.class);
            return webContentSchemaHandler.getDocumentFolder(parentNode);
        }
    }

    protected String getContentStorageType() throws Exception {
        return FCKUtils.DOCUMENT_TYPE;
    }
}

