/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.model.source.join;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum JoinType {
    INNER("INNER JOIN"),
    LEFT_OUTER("LEFT OUTER JOIN"),
    RIGHT_OUTER("RIGHT OUTER JOIN");

    private static final Map<String, JoinType> TYPE_BY_SYMBOL;
    private final String symbol;

    private JoinType(String symbol) {
        this.symbol = symbol;
    }

    public String getString() {
        return this.getSymbol();
    }

    public String getSymbol() {
        return this.symbol;
    }

    public boolean isOuter() {
        return this.equals((Object)LEFT_OUTER) || this.equals((Object)RIGHT_OUTER);
    }

    public String toString() {
        return this.symbol;
    }

    public static JoinType forSymbol(String symbol) {
        return TYPE_BY_SYMBOL.get(symbol.toUpperCase());
    }

    static {
        HashMap<String, JoinType> typesBySymbol = new HashMap<String, JoinType>();
        for (JoinType type : JoinType.values()) {
            typesBySymbol.put(type.getSymbol().toUpperCase(), type);
        }
        TYPE_BY_SYMBOL = Collections.unmodifiableMap(typesBySymbol);
    }
}

