/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.tree.selectmany;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.ecm.webui.popup.UIPopupComponent;
import org.exoplatform.ecm.webui.tree.UIBaseNodeTreeSelector;
import org.exoplatform.ecm.webui.tree.UINodeTreeBuilder;
import org.exoplatform.ecm.webui.tree.selectmany.UICategoriesSelectPanel;
import org.exoplatform.ecm.webui.tree.selectmany.UISelectedCategoriesGrid;
import org.exoplatform.services.cms.categories.CategoriesService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIBreadcumbs;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfigs(value={@ComponentConfig(template="classpath:groovy/ecm/webui/UIContainerWithAction.gtmpl"), @ComponentConfig(type=UIBreadcumbs.class, id="BreadcumbCategories", template="system:/groovy/webui/core/UIBreadcumbs.gtmpl", events={@EventConfig(listeners={SelectPathActionListener.class})})})
public class UICategoriesSelector
extends UIBaseNodeTreeSelector
implements UIPopupComponent {
    private List<String> existedCategoryList = new ArrayList<String>();
    private String pathTaxonomy = "";

    public UICategoriesSelector() throws Exception {
        this.addChild(UIBreadcumbs.class, "BreadcumbCategories", "BreadcumbCategories");
        this.addChild(UINodeTreeBuilder.class, null, null);
        this.addChild(UICategoriesSelectPanel.class, null, null);
        ((UISelectedCategoriesGrid)this.addChild(UISelectedCategoriesGrid.class, null, null)).setRendered(false);
    }

    public void init() throws Exception {
        Node rootCategories;
        CategoriesService categoriesService = (CategoriesService)this.getApplicationComponent(CategoriesService.class);
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        Node rootCategoryTree = rootCategories = categoriesService.getTaxonomyHomeNode(WCMCoreUtils.getUserSessionProvider());
        if (rootCategories != null) {
            this.pathTaxonomy = rootCategories.getPath() + "/";
        }
        UINodeTreeBuilder builder = (UINodeTreeBuilder)this.getChild(UINodeTreeBuilder.class);
        builder.setRootTreeNode(rootCategoryTree);
        UICategoriesSelectPanel uiCategoriesSelectPanel = (UICategoriesSelectPanel)this.getChild(UICategoriesSelectPanel.class);
        uiCategoriesSelectPanel.updateGrid();
        UISelectedCategoriesGrid categoriesGrid = (UISelectedCategoriesGrid)this.getChild(UISelectedCategoriesGrid.class);
        categoriesGrid.setSelectedCategories(this.existedCategoryList);
        if (this.existedCategoryList.size() > 0) {
            categoriesGrid.setRendered(true);
        }
        categoriesGrid.updateGrid(categoriesGrid.getUIPageIterator().getCurrentPage());
    }

    @Override
    public void onChange(Node currentNode, Object context) throws Exception {
        String[] arrayPath;
        UICategoriesSelectPanel uiCategoriesSelectPanel = (UICategoriesSelectPanel)this.getChild(UICategoriesSelectPanel.class);
        uiCategoriesSelectPanel.setParentNode(currentNode);
        uiCategoriesSelectPanel.updateGrid();
        UIBreadcumbs uiBreadcumbs = (UIBreadcumbs)this.getChild(UIBreadcumbs.class);
        ArrayList<UIBreadcumbs.LocalPath> listLocalPath = new ArrayList<UIBreadcumbs.LocalPath>();
        String path = currentNode.getPath().trim();
        if (path.startsWith(this.pathTaxonomy)) {
            path = path.substring(this.pathTaxonomy.length(), path.length());
        }
        if ((arrayPath = path.split("/")).length > 0) {
            for (int i = 0; i < arrayPath.length; ++i) {
                if (arrayPath[i].trim().equals("")) continue;
                UIBreadcumbs.LocalPath localPath1 = new UIBreadcumbs.LocalPath(arrayPath[i].trim(), arrayPath[i].trim());
                listLocalPath.add(localPath1);
            }
        }
        uiBreadcumbs.setPath(listLocalPath);
    }

    public List<String> getExistedCategoryList() {
        return this.existedCategoryList;
    }

    public void setExistedCategoryList(List<String> existedCategoryList) {
        this.existedCategoryList = existedCategoryList;
    }

    @Override
    public void activate() throws Exception {
    }

    @Override
    public void deActivate() throws Exception {
    }

    public void changeGroup(String groupId, Object context) throws Exception {
        List listLocalPath;
        String stringPath = this.pathTaxonomy;
        UIBreadcumbs uiBreadcumb = (UIBreadcumbs)this.getChild(UIBreadcumbs.class);
        if (groupId == null) {
            groupId = "";
        }
        if ((listLocalPath = uiBreadcumb.getPath()) == null || listLocalPath.size() == 0) {
            return;
        }
        ArrayList<String> listLocalPathString = new ArrayList<String>();
        for (UIBreadcumbs.LocalPath localPath : listLocalPath) {
            listLocalPathString.add(localPath.getId().trim());
        }
        if (listLocalPathString.contains(groupId)) {
            int i;
            int index = listLocalPathString.indexOf(groupId);
            if (index == listLocalPathString.size() - 1) {
                return;
            }
            for (i = listLocalPathString.size() - 1; i > index; --i) {
                listLocalPathString.remove(i);
                listLocalPath.remove(i);
            }
            uiBreadcumb.setPath(listLocalPath);
            for (i = 0; i < listLocalPathString.size(); ++i) {
                String pathName = (String)listLocalPathString.get(i);
                if (pathName == null && pathName.equals("")) continue;
                stringPath = stringPath + pathName.trim();
                if (i >= listLocalPathString.size() - 1) continue;
                stringPath = stringPath + "/";
            }
            this.changeNode(stringPath, context);
        }
    }

    private void changeNode(String stringPath, Object context) throws Exception {
        UINodeTreeBuilder builder = (UINodeTreeBuilder)this.getChild(UINodeTreeBuilder.class);
        builder.changeNode(stringPath, context);
        UIBaseNodeTreeSelector nodeTreeSelector = (UIBaseNodeTreeSelector)builder.getAncestorOfType(UIBaseNodeTreeSelector.class);
        UICategoriesSelector uiCategoriesSelector = (UICategoriesSelector)nodeTreeSelector.getChild(UICategoriesSelector.class);
        if (uiCategoriesSelector != null) {
            uiCategoriesSelector.setRenderedChild(UICategoriesSelectPanel.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectPathActionListener
    extends EventListener<UIBreadcumbs> {
        public void execute(Event<UIBreadcumbs> event) throws Exception {
            UIBreadcumbs uiBreadcumbs = (UIBreadcumbs)event.getSource();
            UICategoriesSelector uiCategoriesSelector = (UICategoriesSelector)uiBreadcumbs.getParent();
            String objectId = event.getRequestContext().getRequestParameter("objectId");
            uiBreadcumbs.setSelectPath(objectId);
            String selectGroupId = uiBreadcumbs.getSelectLocalPath().getId();
            uiCategoriesSelector.changeGroup(selectGroupId, event.getRequestContext());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiCategoriesSelector);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CloseActionListener
    extends EventListener<UICategoriesSelector> {
        public void execute(Event<UICategoriesSelector> event) throws Exception {
            UICategoriesSelector uiCategoriesSelector = (UICategoriesSelector)event.getSource();
            UIPopupWindow uiPopup = (UIPopupWindow)uiCategoriesSelector.getParent();
            if (uiPopup != null) {
                uiPopup.setShow(false);
                uiPopup.setRendered(false);
                event.getRequestContext().addUIComponentToUpdateByAjax(uiPopup.getParent());
                return;
            }
            uiCategoriesSelector.deActivate();
        }
    }
}

