/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.component.organization;

import javax.jcr.Session;
import org.exoplatform.platform.component.organization.Util;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileEventListener;

public class NewProfileListener
extends UserProfileEventListener {
    private RepositoryService repositoryService;

    public NewProfileListener(RepositoryService repositoryService) throws Exception {
        this.repositoryService = repositoryService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSave(UserProfile user, boolean isNew) throws Exception {
        if (!isNew) {
            return;
        }
        Session session = null;
        try {
            session = this.repositoryService.getCurrentRepository().getSystemSession(Util.WORKSPACE);
            if (!Util.hasProfileFolder(session, user.getUserName())) {
                Util.createProfileFolder(session, user.getUserName());
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postDelete(UserProfile user) throws Exception {
        Session session = null;
        try {
            session = this.repositoryService.getCurrentRepository().getSystemSession(Util.WORKSPACE);
            if (Util.hasProfileFolder(session, user.getUserName())) {
                Util.deleteProfileFolder(session, user.getUserName());
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }
}

