/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.component.organization;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.impl.GroupImpl;
import org.exoplatform.services.organization.impl.MembershipImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static final String SPECIAL_CHARACTER_REPLACEMENT = "___";
    public static final String MEMBERSHIP_SEPARATOR = "---";
    public static final String ORGANIZATION_INITIALIZATIONS = "OrganizationIntegrationService";
    public static final String USERS_FOLDER = "users";
    public static final String GROUPS_FOLDER = "groups";
    public static final String MEMBERSHIPS_FOLDER = "memberships";
    public static final String PROFILES_FOLDER = "profiles";
    public static String WORKSPACE = "collaboration";
    public static String HOME_PATH = "/";

    public static void init(Session session) throws Exception {
        Node homePathNode = null;
        try {
            homePathNode = (Node)session.getItem(HOME_PATH);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (homePathNode == null) {
            homePathNode = Util.createFolder(session.getRootNode(), HOME_PATH);
        }
        Node organizationInitializersHomePathNode = null;
        organizationInitializersHomePathNode = !homePathNode.hasNode(ORGANIZATION_INITIALIZATIONS) ? Util.createFolder(homePathNode, ORGANIZATION_INITIALIZATIONS) : homePathNode.getNode(ORGANIZATION_INITIALIZATIONS);
        if (!organizationInitializersHomePathNode.hasNode(USERS_FOLDER)) {
            Util.createFolder(organizationInitializersHomePathNode, USERS_FOLDER);
        }
        if (!organizationInitializersHomePathNode.hasNode(GROUPS_FOLDER)) {
            Util.createFolder(organizationInitializersHomePathNode, GROUPS_FOLDER);
        }
        if (!organizationInitializersHomePathNode.hasNode(MEMBERSHIPS_FOLDER)) {
            Util.createFolder(organizationInitializersHomePathNode, MEMBERSHIPS_FOLDER);
        }
        if (!organizationInitializersHomePathNode.hasNode(PROFILES_FOLDER)) {
            Util.createFolder(organizationInitializersHomePathNode, PROFILES_FOLDER);
        }
        session.save();
    }

    public static Node getUsersFolder(Session session) throws Exception {
        Node organizationInitializersHomePathNode = null;
        try {
            Node homePathNode = (Node)session.getItem(HOME_PATH);
            organizationInitializersHomePathNode = homePathNode.getNode(ORGANIZATION_INITIALIZATIONS);
        }
        catch (Exception e) {
            Util.init(session);
            Node homePathNode = (Node)session.getItem(HOME_PATH);
            organizationInitializersHomePathNode = homePathNode.getNode(ORGANIZATION_INITIALIZATIONS);
        }
        return organizationInitializersHomePathNode.getNode(USERS_FOLDER);
    }

    public static Node getGroupsFolder(Session session) throws Exception {
        Node organizationInitializersHomePathNode = null;
        try {
            Node homePathNode = (Node)session.getItem(HOME_PATH);
            organizationInitializersHomePathNode = homePathNode.getNode(ORGANIZATION_INITIALIZATIONS);
        }
        catch (Exception e) {
            Util.init(session);
            Node homePathNode = (Node)session.getItem(HOME_PATH);
            organizationInitializersHomePathNode = homePathNode.getNode(ORGANIZATION_INITIALIZATIONS);
        }
        return organizationInitializersHomePathNode.getNode(GROUPS_FOLDER);
    }

    public static Node getMembershipsFolder(Session session) throws Exception {
        Node organizationInitializersHomePathNode = null;
        try {
            Node homePathNode = (Node)session.getItem(HOME_PATH);
            organizationInitializersHomePathNode = homePathNode.getNode(ORGANIZATION_INITIALIZATIONS);
        }
        catch (Exception e) {
            Util.init(session);
            Node homePathNode = (Node)session.getItem(HOME_PATH);
            organizationInitializersHomePathNode = homePathNode.getNode(ORGANIZATION_INITIALIZATIONS);
        }
        return organizationInitializersHomePathNode.getNode(MEMBERSHIPS_FOLDER);
    }

    public static Node getProfilesFolder(Session session) throws Exception {
        Node organizationInitializersHomePathNode = null;
        try {
            Node homePathNode = (Node)session.getItem(HOME_PATH);
            organizationInitializersHomePathNode = homePathNode.getNode(ORGANIZATION_INITIALIZATIONS);
        }
        catch (Exception e) {
            Util.init(session);
            Node homePathNode = (Node)session.getItem(HOME_PATH);
            organizationInitializersHomePathNode = homePathNode.getNode(ORGANIZATION_INITIALIZATIONS);
        }
        return organizationInitializersHomePathNode.getNode(PROFILES_FOLDER);
    }

    public static boolean hasUserFolder(Session session, String username) throws Exception {
        return Util.getUsersFolder(session).hasNode(username);
    }

    public static boolean hasProfileFolder(Session session, String username) throws Exception {
        return Util.getProfilesFolder(session).hasNode(username);
    }

    public static boolean hasMembershipFolder(Session session, Membership membership) throws Exception {
        boolean hasNode = Util.getMembershipsFolder(session).hasNode(membership.getGroupId().replace("/", SPECIAL_CHARACTER_REPLACEMENT) + MEMBERSHIP_SEPARATOR + membership.getMembershipType().replace("*", SPECIAL_CHARACTER_REPLACEMENT) + MEMBERSHIP_SEPARATOR + membership.getUserName());
        return hasNode;
    }

    public static boolean hasGroupFolder(Session session, String groupId) throws Exception {
        return Util.getGroupsFolder(session).hasNode(groupId.replace("/", SPECIAL_CHARACTER_REPLACEMENT).trim());
    }

    public static void createUserFolder(Session session, String username) throws Exception {
        Util.createFolder(Util.getUsersFolder(session), username);
        session.save();
    }

    public static void createProfileFolder(Session session, String username) throws Exception {
        Util.createFolder(Util.getProfilesFolder(session), username);
        session.save();
    }

    public static void createMembershipFolder(Session session, Membership membership) throws Exception {
        Util.createFolder(Util.getMembershipsFolder(session), membership.getGroupId().replace("/", SPECIAL_CHARACTER_REPLACEMENT) + MEMBERSHIP_SEPARATOR + membership.getMembershipType().replace("*", SPECIAL_CHARACTER_REPLACEMENT) + MEMBERSHIP_SEPARATOR + membership.getUserName());
        Util.createFolder(Util.getGroupNode(session, membership.getGroupId()), membership.getMembershipType().replace("*", SPECIAL_CHARACTER_REPLACEMENT) + MEMBERSHIP_SEPARATOR + membership.getUserName());
        Util.createFolder(Util.getUserNode(session, membership.getUserName()), membership.getMembershipType().replace("*", SPECIAL_CHARACTER_REPLACEMENT) + MEMBERSHIP_SEPARATOR + membership.getGroupId().replace("/", SPECIAL_CHARACTER_REPLACEMENT));
        session.save();
    }

    public static Node getUserNode(Session session, String username) throws PathNotFoundException, RepositoryException, Exception {
        return Util.getUsersFolder(session).getNode(username);
    }

    public static void createGroupFolder(Session session, String groupId) throws Exception {
        Util.createFolder(Util.getGroupsFolder(session), groupId.replace("/", SPECIAL_CHARACTER_REPLACEMENT).trim());
        session.save();
    }

    public static void deleteUserFolder(Session session, String username) throws Exception {
        Util.getUsersFolder(session).getNode(username).remove();
        session.save();
    }

    public static void deleteProfileFolder(Session session, String username) throws Exception {
        Util.getProfilesFolder(session).getNode(username).remove();
        session.save();
    }

    public static void deleteMembershipFolder(Session session, Membership membership) throws Exception {
        Util.getMembershipsFolder(session).getNode(membership.getGroupId().replace("/", SPECIAL_CHARACTER_REPLACEMENT) + MEMBERSHIP_SEPARATOR + membership.getMembershipType().replace("*", SPECIAL_CHARACTER_REPLACEMENT) + MEMBERSHIP_SEPARATOR + membership.getUserName()).remove();
        String membershipGroupFolderName = membership.getMembershipType().replace("*", SPECIAL_CHARACTER_REPLACEMENT) + MEMBERSHIP_SEPARATOR + membership.getUserName();
        if (Util.hasGroupFolder(session, membership.getGroupId()) && Util.getGroupNode(session, membership.getGroupId()).hasNode(membershipGroupFolderName)) {
            Util.getGroupNode(session, membership.getGroupId()).getNode(membershipGroupFolderName).remove();
        }
        String membershipUserFolderName = membership.getMembershipType().replace("*", SPECIAL_CHARACTER_REPLACEMENT) + MEMBERSHIP_SEPARATOR + membership.getGroupId().replace("/", SPECIAL_CHARACTER_REPLACEMENT);
        if (Util.hasUserFolder(session, membership.getUserName()) && Util.getUserNode(session, membership.getUserName()).hasNode(membershipUserFolderName)) {
            Util.getUserNode(session, membership.getUserName()).getNode(membershipUserFolderName).remove();
        }
        session.save();
    }

    public static void deleteGroupFolder(Session session, String groupId) throws Exception {
        Util.getGroupNode(session, groupId).remove();
        session.save();
    }

    public static Node getGroupNode(Session session, String groupId) throws PathNotFoundException, RepositoryException, Exception {
        return Util.getGroupsFolder(session).getNode(groupId.replace("/", SPECIAL_CHARACTER_REPLACEMENT));
    }

    private static Node createFolder(Node parentNode, String name) throws Exception {
        parentNode.addNode(name, "nt:folder");
        parentNode.getSession().save();
        return parentNode.getNode(name);
    }

    public static List<String> getActivatedUsers(Session session) throws Exception {
        ArrayList<String> activatedUsernames = new ArrayList<String>();
        NodeIterator usersFolderIterator = Util.getUsersFolder(session).getNodes();
        while (usersFolderIterator.hasNext()) {
            Node userFolder = usersFolderIterator.nextNode();
            activatedUsernames.add(userFolder.getName());
        }
        return activatedUsernames;
    }

    public static List<String> getActivatedGroups(Session session) throws Exception {
        ArrayList<String> activatedGroups = new ArrayList<String>();
        NodeIterator groupsFolderIterator = Util.getGroupsFolder(session).getNodes();
        while (groupsFolderIterator.hasNext()) {
            Node groupFolder = groupsFolderIterator.nextNode();
            String groupId = groupFolder.getName().replace(SPECIAL_CHARACTER_REPLACEMENT, "/");
            activatedGroups.add(groupId);
        }
        return activatedGroups;
    }

    public static List<Membership> getActivatedMembershipsRelatedToGroup(Session session, String groupId) throws Exception {
        ArrayList<Membership> activatedMemberships = new ArrayList<Membership>();
        NodeIterator membershipNodesIterator = Util.getGroupNode(session, groupId).getNodes();
        while (membershipNodesIterator.hasNext()) {
            Node membershipNode = membershipNodesIterator.nextNode();
            String membershipId = membershipNode.getName();
            String[] membershipElements = membershipId.split(MEMBERSHIP_SEPARATOR);
            String membershipType = membershipElements[0].replace(SPECIAL_CHARACTER_REPLACEMENT, "*");
            String username = membershipElements[1];
            MembershipImpl membership = new MembershipImpl();
            membership.setGroupId(groupId);
            membership.setMembershipType(membershipType);
            membership.setUserName(username);
            membership.setId(Util.computeId((Membership)membership));
            activatedMemberships.add((Membership)membership);
        }
        return activatedMemberships;
    }

    public static List<Group> getActivatedChildrenGroup(Session session, String parentGroupId) throws Exception {
        ArrayList<Group> activatedGroups = new ArrayList<Group>();
        NodeIterator groupsNodesIterator = Util.getGroupsFolder(session).getNodes();
        while (groupsNodesIterator.hasNext()) {
            Node groupNode = groupsNodesIterator.nextNode();
            String groupId = groupNode.getName();
            if (!(groupId = groupId.replace(SPECIAL_CHARACTER_REPLACEMENT, "/")).contains(parentGroupId) || groupId.equals(parentGroupId)) continue;
            GroupImpl group = new GroupImpl();
            group.setId(groupId);
            group.setGroupName(groupId);
            activatedGroups.add((Group)group);
        }
        return activatedGroups;
    }

    public static List<Membership> getActivatedMembershipsRelatedToUser(Session session, String username) throws Exception {
        ArrayList<Membership> activatedMemberships = new ArrayList<Membership>();
        NodeIterator membershipNodesIterator = Util.getUserNode(session, username).getNodes();
        while (membershipNodesIterator.hasNext()) {
            Node membershipNode = membershipNodesIterator.nextNode();
            String membershipId = membershipNode.getName();
            String[] membershipElements = membershipId.split(MEMBERSHIP_SEPARATOR);
            String membershipType = membershipElements[0].replace(SPECIAL_CHARACTER_REPLACEMENT, "*");
            String groupId = membershipElements[1].replace(SPECIAL_CHARACTER_REPLACEMENT, "/");
            MembershipImpl membership = new MembershipImpl();
            membership.setGroupId(groupId);
            membership.setMembershipType(membershipType);
            membership.setUserName(username);
            membership.setId(Util.computeId((Membership)membership));
            activatedMemberships.add((Membership)membership);
        }
        return activatedMemberships;
    }

    public static String computeId(Membership membership) {
        StringBuffer id = new StringBuffer();
        if (membership.getMembershipType() != null) {
            id.append(membership.getMembershipType());
        }
        id.append(":");
        if (membership.getUserName() != null) {
            id.append(membership.getUserName());
        }
        id.append(":");
        if (membership.getGroupId() != null) {
            id.append(membership.getGroupId());
        }
        return id.toString();
    }
}

