/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class Utils {
    public static String productNameAndVersion = "";
    public static String pingServerURL = "";
    public static String registrationFormUrl;
    public static final int DEFAULT_DELAY_PERIOD = 30;
    public static int delayPeriod;
    public static int daysBeforeExpire;
    public static boolean loopfuseFormDisplayed;
    public static String KEY_CONTENT;
    public static boolean outdated;
    public static String pingBackUrl;
    public static final String LEAD_CAPTURE_KEY = "UnlockKey";
    public static final String REMIND_DATE = "remindDate";
    public static final String LOOP_FUSE_FORM_DISPLAYED = "formDisplayed";
    public static final String LAST_START_DATE = "LSTD";
    public static final String USER_HOME;
    public static final String EXO_HOME_FOLDER;
    public static final String HOME_CONFIG_FILE_LOCATION;
    private static final DateFormat dateFormat;

    public static String getModifiedMD5Code(byte[] dataToHash) throws NoSuchAlgorithmException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        Provider provBC = Security.getProvider("BC");
        MessageDigest digest = MessageDigest.getInstance("MD5", provBC);
        digest.update(dataToHash);
        byte[] hashMD5 = digest.digest(dataToHash);
        StringBuffer hashMD5String = new StringBuffer();
        for (int i = 0; i < hashMD5.length; ++i) {
            int n = i;
            hashMD5[n] = (byte)(hashMD5[n] % 26);
            hashMD5[i] = (byte)Math.abs(hashMD5[i]);
            int n2 = i;
            hashMD5[n2] = (byte)(hashMD5[n2] + 64);
            hashMD5String.append((char)hashMD5[i]);
        }
        return hashMD5String.toString();
    }

    public static String formatDate(Calendar date) {
        return dateFormat.format(date.getTime());
    }

    public static Calendar parseDate(String dateString) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateFormat.parse(dateString));
        return calendar;
    }

    public static String readFromFile(String key, String fileLocation) throws InvalidPropertiesFormatException, IOException {
        if (fileLocation == null || fileLocation.isEmpty() || !new File(fileLocation).exists()) {
            throw new IllegalArgumentException("Illegal file Location parameter: " + fileLocation);
        }
        Properties properties = new Properties();
        FileInputStream inputStream = new FileInputStream(fileLocation);
        properties.loadFromXML(inputStream);
        ((InputStream)inputStream).close();
        return (String)properties.get(key);
    }

    public static void writeToFile(String key, String value, String fileLocation, boolean addDefaultTrialKeyIfNotExists) throws InvalidPropertiesFormatException, IOException {
        FileOutputStream outputStream;
        if (fileLocation == null || fileLocation.isEmpty()) {
            throw new IllegalArgumentException("Illegal empty file Location parameter.");
        }
        Properties properties = new Properties();
        if (new File(fileLocation).exists()) {
            FileInputStream inputStream = new FileInputStream(fileLocation);
            properties.loadFromXML(inputStream);
            ((InputStream)inputStream).close();
        } else {
            Utils.verifyAndCreateParentFolder(fileLocation);
            if (addDefaultTrialKeyIfNotExists) {
                properties.put(LEAD_CAPTURE_KEY, "");
            }
            outputStream = new FileOutputStream(fileLocation);
            properties.storeToXML(outputStream, fileLocation);
            ((OutputStream)outputStream).close();
        }
        properties.put(key, value);
        outputStream = new FileOutputStream(fileLocation);
        properties.storeToXML(outputStream, "");
        ((OutputStream)outputStream).close();
    }

    public static void writeTrialKey(String hashMD5, String fileLocation) throws InvalidPropertiesFormatException, IOException {
        Utils.writeToFile(LEAD_CAPTURE_KEY, hashMD5, fileLocation, true);
    }

    public static void writeRemindDate(String remindDateStringBase64, String fileLocation) throws InvalidPropertiesFormatException, IOException {
        Utils.writeToFile(REMIND_DATE, remindDateStringBase64, fileLocation, true);
    }

    public static void writePingBackFormDisplayed(String fileLocation) throws InvalidPropertiesFormatException, IOException {
        Utils.writeToFile(LOOP_FUSE_FORM_DISPLAYED, Boolean.toString(loopfuseFormDisplayed), fileLocation, true);
    }

    public static Calendar parseDateBase64(String dateString) throws ParseException {
        return Utils.parseDate(new String(Base64.decodeBase64((byte[])dateString.getBytes())));
    }

    public static String formatDateBase64(Calendar date) {
        return new String(Base64.encodeBase64((byte[])Utils.formatDate(date).getBytes()));
    }

    public static String computeRemindDateFromTodayBase64() {
        if (delayPeriod <= 0 || outdated) {
            return "";
        }
        Calendar remindDate = Calendar.getInstance();
        remindDate.add(5, delayPeriod);
        return Utils.formatDateBase64(remindDate);
    }

    private static void verifyAndCreateParentFolder(String fileLocation) {
        String parentFolderPath = fileLocation;
        int parentFolderPathEndIndex = fileLocation.lastIndexOf("/");
        if (parentFolderPathEndIndex < 0 && (parentFolderPathEndIndex = fileLocation.lastIndexOf("\\")) >= 0) {
            parentFolderPath = fileLocation.substring(0, parentFolderPathEndIndex);
        }
        if (!new File(parentFolderPath).exists()) {
            new File(parentFolderPath).mkdirs();
        }
    }

    static {
        delayPeriod = 30;
        daysBeforeExpire = 0;
        loopfuseFormDisplayed = false;
        outdated = false;
        USER_HOME = System.getProperty("user.home");
        EXO_HOME_FOLDER = USER_HOME + "/.eXo";
        HOME_CONFIG_FILE_LOCATION = EXO_HOME_FOLDER + "/exokey.xml";
        dateFormat = new SimpleDateFormat("dd/MM/yyyy");
    }
}

