/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.voting.impl;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.cms.i18n.MultiLanguageService;
import org.exoplatform.services.cms.voting.VotingService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;

public class VotingServiceImpl
implements VotingService {
    static final String VOTABLE = "mix:votable";
    static final String VOTER_PROP = "exo:voter";
    static final String VOTER_VOTEVALUE_PROP = "exo:voterVoteValues";
    static final String VOTING_RATE_PROP = "exo:votingRate";
    static final String VOTE_TOTAL_PROP = "exo:voteTotal";
    static final String VOTE_TOTAL_LANG_PROP = "exo:voteTotalOfLang";
    private static final String LANGUAGES = "languages";
    private static final String SPACE = " ";
    private MultiLanguageService multiLangService_;

    public VotingServiceImpl(MultiLanguageService multiLangService) {
        this.multiLangService_ = multiLangService;
    }

    public long getVoteTotal(Node node) throws Exception {
        long voteTotal = 0L;
        if (!node.hasNode(LANGUAGES) && node.hasProperty(VOTE_TOTAL_PROP)) {
            return node.getProperty(VOTE_TOTAL_LANG_PROP).getLong();
        }
        Node multiLanguages = node.getNode(LANGUAGES);
        voteTotal = node.getProperty(VOTE_TOTAL_LANG_PROP).getLong();
        NodeIterator nodeIter = multiLanguages.getNodes();
        while (nodeIter.hasNext()) {
            Node languageNode = nodeIter.nextNode();
            if (node.getPrimaryNodeType().getName().equals("nt:file")) {
                languageNode = this.getFileLangNode(languageNode);
            }
            if (!languageNode.hasProperty(VOTE_TOTAL_LANG_PROP)) continue;
            voteTotal += languageNode.getProperty(VOTE_TOTAL_LANG_PROP).getLong();
        }
        return voteTotal;
    }

    public Node getFileLangNode(Node currentNode) throws Exception {
        if (currentNode.getNodes().getSize() > 0L) {
            NodeIterator nodeIter = currentNode.getNodes();
            while (nodeIter.hasNext()) {
                Node ntFile = nodeIter.nextNode();
                if (!ntFile.getPrimaryNodeType().getName().equals("nt:file")) continue;
                return ntFile;
            }
            return currentNode;
        }
        return currentNode;
    }

    public void vote(Node node, double rate, String userName, String language) throws Exception {
        Node languageNode;
        Session session = node.getSession();
        if (!(node = this.handleUser(session, node, userName)).isNodeType(VOTABLE)) {
            if (node.canAddMixin(VOTABLE)) {
                node.addMixin(VOTABLE);
            } else {
                throw new NoSuchNodeTypeException();
            }
        }
        if (!(languageNode = this.handleLanguage(node, language)).isNodeType(VOTABLE)) {
            if (languageNode.canAddMixin(VOTABLE)) {
                languageNode.addMixin(VOTABLE);
            } else {
                throw new NoSuchNodeTypeException();
            }
        }
        long voteTotalOfLang = languageNode.getProperty(VOTE_TOTAL_LANG_PROP).getLong();
        double votingRate = languageNode.getProperty(VOTING_RATE_PROP).getDouble();
        Value voterVoteValue = this.getVoterVoteValue(languageNode, userName);
        double newRating = 0.0;
        if (voterVoteValue != null) {
            String oldUserRateValueStr = voterVoteValue.getString().substring(voterVoteValue.getString().lastIndexOf(SPACE) + 1);
            double oldUserRate = Double.parseDouble(oldUserRateValueStr);
            newRating = ((double)voteTotalOfLang * votingRate + rate - oldUserRate) / (double)voteTotalOfLang;
        } else {
            newRating = ((double)voteTotalOfLang * votingRate + rate) / (double)(voteTotalOfLang + 1L);
        }
        DecimalFormat format = new DecimalFormat("###.##");
        double formatedRating = format.parse(format.format(newRating)).doubleValue();
        Value[] voterVoteValues = new Value[]{};
        Value[] newVoterVoteValues = null;
        if (languageNode.hasProperty(VOTER_VOTEVALUE_PROP)) {
            voterVoteValues = languageNode.getProperty(VOTER_VOTEVALUE_PROP).getValues();
        }
        if (voterVoteValue != null) {
            newVoterVoteValues = this.replaceOldValue(voterVoteValues, userName, rate, languageNode.getSession());
        } else {
            Value newVoterVoteValue = languageNode.getSession().getValueFactory().createValue(userName + SPACE + rate);
            newVoterVoteValues = new Value[voterVoteValues.length + (userName == null ? 0 : 1)];
            System.arraycopy(voterVoteValues, 0, newVoterVoteValues, 0, voterVoteValues.length);
            if (userName != null) {
                newVoterVoteValues[voterVoteValues.length] = newVoterVoteValue;
            }
        }
        languageNode.setProperty(VOTER_VOTEVALUE_PROP, newVoterVoteValues);
        node.setProperty(VOTE_TOTAL_PROP, this.getVoteTotal(node) + (long)(voterVoteValue == null ? 1 : 0));
        languageNode.setProperty(VOTE_TOTAL_LANG_PROP, voteTotalOfLang + (long)(voterVoteValue == null ? 1 : 0));
        languageNode.setProperty(VOTING_RATE_PROP, formatedRating);
        node.getSession().save();
        languageNode.getSession().save();
    }

    private Value getVoterVoteValue(Node languageNode, String userName) throws Exception {
        if (!languageNode.hasProperty(VOTER_VOTEVALUE_PROP)) {
            return null;
        }
        Value ret = null;
        for (Value voterVoteValue : languageNode.getProperty(VOTER_VOTEVALUE_PROP).getValues()) {
            if (!voterVoteValue.getString().startsWith(userName + SPACE)) continue;
            return voterVoteValue;
        }
        return ret;
    }

    private Value[] replaceOldValue(Value[] voterVoteValues, String userName, double rate, Session session) throws Exception {
        for (int i = 0; i < voterVoteValues.length; ++i) {
            if (!voterVoteValues[i].getString().startsWith(userName + SPACE)) continue;
            voterVoteValues[i] = session.getValueFactory().createValue(userName + SPACE + rate);
            break;
        }
        return voterVoteValues;
    }

    public boolean isVoted(Node node, String userName, String language) throws Exception {
        boolean isVoted = false;
        Session session = node.getSession();
        if (!(node = this.handleUser(session, node, userName)).isNodeType(VOTABLE)) {
            if (node.canAddMixin(VOTABLE)) {
                node.addMixin(VOTABLE);
            } else {
                throw new NoSuchNodeTypeException();
            }
        }
        Node languageNode = this.handleLanguage(node, language);
        Value[] voters = new Value[]{};
        if (languageNode.hasProperty(VOTER_PROP)) {
            voters = languageNode.getProperty(VOTER_PROP).getValues();
        }
        Value newVoter = session.getValueFactory().createValue(userName);
        ArrayList<Value> newVoterList = new ArrayList<Value>();
        newVoterList.addAll(Arrays.asList(voters));
        if (newVoterList.contains(newVoter)) {
            isVoted = true;
        }
        return isVoted;
    }

    private Node handleLanguage(Node node, String language) throws Exception {
        String defaultLang = this.multiLangService_.getDefault(node);
        Node multiLanguages = null;
        Node languageNode = null;
        if (defaultLang == null && language == null || language.equals(defaultLang)) {
            languageNode = node;
        } else if (node.hasNode(LANGUAGES)) {
            multiLanguages = node.getNode(LANGUAGES);
            if (multiLanguages.hasNode(language)) {
                languageNode = multiLanguages.getNode(language);
                if (node.getPrimaryNodeType().getName().equals("nt:file")) {
                    languageNode = this.getFileLangNode(languageNode);
                }
            }
        } else {
            languageNode = node;
        }
        return languageNode;
    }

    private Node handleUser(Session session, Node node, String userName) throws Exception {
        if (userName == null || "__anonim".equals(userName)) {
            String strWorkspaceName = node.getSession().getWorkspace().getName();
            ExoContainer eXoContainer = ExoContainerContext.getCurrentContainer();
            RepositoryService repositoryService = (RepositoryService)eXoContainer.getComponentInstanceOfType(RepositoryService.class);
            ManageableRepository manageRepository = repositoryService.getCurrentRepository();
            session = SessionProvider.createSystemProvider().getSession(strWorkspaceName, manageRepository);
            String uid = node.getUUID();
            node = session.getNodeByUUID(uid);
        }
        return node;
    }
}

