/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.migration;

import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class MigrationUtil {
    static String OLD_TEMPLATE_PORLET_NAME = "Content List Viewer";
    static String NEW_TEMPLATE_PORTLET_NAME = "content-list-viewer";
    private static Log log = ExoLogger.getLogger(MigrationUtil.class);

    public static String checkAndUpdateViewerTemplate(String strTemplatePath) {
        if (strTemplatePath.contains(OLD_TEMPLATE_PORLET_NAME)) {
            SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
            RepositoryService repoService = WCMCoreUtils.getService(RepositoryService.class);
            try {
                Session session = sessionProvider.getSession("dms-system", repoService.getCurrentRepository());
                Node root = session.getRootNode();
                String templateName = strTemplatePath.substring(strTemplatePath.lastIndexOf("/") + 1);
                if (root.hasNode("exo:ecm/views/templates/content-list-viewer/list/" + templateName)) {
                    strTemplatePath = "/exo:ecm/views/templates/content-list-viewer/list/" + templateName;
                } else if (root.hasNode("exo:ecm/views/templates/content-list-viewer/navigation/" + templateName)) {
                    strTemplatePath = "/exo:ecm/views/templates/content-list-viewer/navigation/" + templateName;
                } else if (root.hasNode("exo:ecm/views/templates/content-list-viewer/paginators/" + templateName)) {
                    strTemplatePath = "/exo:ecm/views/templates/content-list-viewer/paginators/" + templateName;
                } else if (log.isInfoEnabled()) {
                    log.info((Object)("Cannot locate in new location : " + strTemplatePath));
                }
            }
            catch (LoginException le) {
            }
            catch (NoSuchWorkspaceException nswe) {
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        return strTemplatePath;
    }
}

