/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.navigation;

import java.util.Iterator;
import javax.portlet.MimeResponse;
import javax.portlet.ResourceURL;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserNodeFilterConfig;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.application.WebuiRequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigationUtils {
    public static final Scope ECMS_NAVIGATION_SCOPE = Scope.CHILDREN;
    private static ThreadLocal<Boolean> gotNavigationKeeper = new ThreadLocal();

    public static boolean gotNavigation() {
        Boolean gotNavigation = gotNavigationKeeper.get();
        return gotNavigation == null ? false : gotNavigation;
    }

    public static void setGotNavigation(boolean value) {
        gotNavigationKeeper.set(value);
    }

    public static String getNavigationAsJSON(String portalName, String username) throws Exception {
        UserPortalConfigService userPortalConfigService = WCMCoreUtils.getService(UserPortalConfigService.class);
        UserPortalConfig userPortalCfg = userPortalConfigService.getUserPortalConfig(portalName, username, PortalRequestContext.USER_PORTAL_CONTEXT);
        UserPortal userPortal = userPortalCfg.getUserPortal();
        UserNodeFilterConfig.Builder filterConfigBuilder = UserNodeFilterConfig.builder();
        filterConfigBuilder.withReadWriteCheck().withVisibility(Visibility.DISPLAYED, new Visibility[]{Visibility.TEMPORAL});
        filterConfigBuilder.withTemporalCheck();
        UserNodeFilterConfig filterConfig = filterConfigBuilder.build();
        UserNavigation navigation = userPortal.getNavigation(SiteKey.portal((String)portalName));
        UserNode root = userPortal.getNode(navigation, ECMS_NAVIGATION_SCOPE, filterConfig, null);
        NavigationUtils.setGotNavigation(true);
        return NavigationUtils.createJsonTree(navigation, root);
    }

    private static String createJsonTree(UserNavigation navigation, UserNode rootNode) throws Exception {
        StringBuffer sbJsonTree = new StringBuffer();
        sbJsonTree.append("[");
        sbJsonTree.append("{");
        sbJsonTree.append("\"ownerId\":\"").append(navigation.getKey().getName()).append("\",");
        sbJsonTree.append("\"ownerType\":\"").append(navigation.getKey().getTypeName()).append("\",");
        sbJsonTree.append("\"priority\":\"").append(navigation.getPriority()).append("\",");
        sbJsonTree.append("\"nodes\":").append(NavigationUtils.addJsonNodes(rootNode.getChildren().iterator()));
        sbJsonTree.append("}");
        sbJsonTree.append("]");
        return sbJsonTree.toString();
    }

    private static StringBuffer addJsonNodes(Iterator<UserNode> children) throws Exception {
        StringBuffer sbJsonTree = new StringBuffer();
        sbJsonTree.append("[");
        boolean first = true;
        while (children.hasNext()) {
            UserNode child = children.next();
            if (!first) {
                sbJsonTree.append(",");
            }
            first = false;
            sbJsonTree.append("{");
            sbJsonTree.append("\"icon\":").append(child.getIcon() != null ? "\"" + child.getIcon() + "\"" : "null").append(",");
            sbJsonTree.append("\"label\":\"").append(child.getLabel()).append("\",");
            sbJsonTree.append("\"name\":\"").append(child.getName()).append("\",");
            sbJsonTree.append("\"resolvedLabel\":\"").append(child.getResolvedLabel()).append("\",");
            sbJsonTree.append("\"uri\":\"").append(child.getURI()).append("\",");
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            MimeResponse res = (MimeResponse)context.getResponse();
            ResourceURL resourceURL = res.createResourceURL();
            resourceURL.setResourceID(res.encodeURL(child.getURI()));
            sbJsonTree.append("\"getNodeURL\":\"").append(resourceURL.toString()).append("\",");
            sbJsonTree.append("\"nodes\":").append(NavigationUtils.addJsonNodes(child.getChildren().iterator()));
            sbJsonTree.append("}");
        }
        sbJsonTree.append("]");
        return sbJsonTree;
    }
}

