/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.audit;

import javax.jcr.Item;
import javax.jcr.Node;
import org.apache.commons.chain.Context;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.command.action.Action;
import org.exoplatform.services.jcr.ext.audit.AuditService;
import org.exoplatform.services.jcr.impl.core.ItemImpl;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.observation.ExtendedEventType;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class AuditAction
implements Action {
    private final Log log = ExoLogger.getLogger((String)"jcr.AuditAction");

    public boolean execute(Context ctx) throws Exception {
        ItemImpl currentItem = (ItemImpl)ctx.get((Object)"currentItem");
        ItemImpl previousItem = (ItemImpl)ctx.get((Object)"previousItem");
        int event = (Integer)ctx.get((Object)"event");
        NodeImpl node = currentItem.isNode() ? (NodeImpl)currentItem : currentItem.getParent();
        if (node.isNodeType(AuditService.EXO_AUDITABLE)) {
            AuditService auditService = (AuditService)((ExoContainer)ctx.get((Object)"exocontainer")).getComponentInstanceOfType(AuditService.class);
            if (!auditService.hasHistory((Node)node)) {
                auditService.createHistory((Node)node);
            }
            auditService.addRecord((Item)previousItem, (Item)currentItem, event);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Record '" + ExtendedEventType.nameFromValue((int)event) + "' added for " + currentItem.getPath()));
            }
            return true;
        }
        return false;
    }
}

