/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.activity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.ActivityStorageException;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.activity.UIActivitiesContainer;
import org.exoplatform.social.webui.composer.UIComposer;
import org.exoplatform.social.webui.profile.UIUserActivitiesDisplay;
import org.exoplatform.social.webui.space.UISpaceActivitiesDisplay;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.WebuiBindingContext;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormTextAreaInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseUIActivity
extends UIForm {
    private static final Log LOG = ExoLogger.getLogger(BaseUIActivity.class);
    private static int LATEST_COMMENTS_SIZE = 2;
    private int commentMinCharactersAllowed = 0;
    private int commentMaxCharactersAllowed = 100;
    private ExoSocialActivity activity;
    private Identity ownerIdentity;
    private List<ExoSocialActivity> comments;
    private String[] identityLikes;
    private boolean commentFormDisplayed = false;
    private boolean likesDisplayed = false;
    private CommentStatus commentListStatus = CommentStatus.LATEST;
    private boolean allCommentsHidden = false;
    private boolean commentFormFocused = false;

    public BaseUIActivity() {
        this.setSubmitAction("return false;");
        this.comments = new ArrayList<ExoSocialActivity>();
    }

    public void setActivity(ExoSocialActivity activity) {
        this.activity = activity;
        this.setOwnerIdentity(Utils.getIdentityManager().getIdentity(activity.getUserId(), true));
        this.addChild((UIComponent)new UIFormTextAreaInput("CommentTextarea" + activity.getId(), "CommentTextarea", null));
        try {
            this.refresh();
        }
        catch (ActivityStorageException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public ExoSocialActivity getActivity() {
        return this.activity;
    }

    public void setCommentMinCharactersAllowed(int num) {
        this.commentMinCharactersAllowed = num;
    }

    public int getCommentMinCharactersAllowed() {
        return this.commentMinCharactersAllowed;
    }

    public void setCommentMaxCharactersAllowed(int num) {
        this.commentMaxCharactersAllowed = num;
    }

    public int getCommentMaxCharactersAllowed() {
        return this.commentMaxCharactersAllowed;
    }

    public void setCommentFormDisplayed(boolean commentFormDisplayed) {
        this.commentFormDisplayed = commentFormDisplayed;
    }

    public boolean isCommentFormDisplayed() {
        return this.commentFormDisplayed;
    }

    public void setLikesDisplayed(boolean likesDisplayed) {
        this.likesDisplayed = likesDisplayed;
    }

    public boolean isLikesDisplayed() {
        return this.likesDisplayed;
    }

    public void setAllCommentsHidden(boolean allCommentsHidden) {
        this.allCommentsHidden = allCommentsHidden;
    }

    public boolean isAllCommentsHidden() {
        return this.allCommentsHidden;
    }

    public void setCommentFormFocused(boolean commentFormFocused) {
        this.commentFormFocused = commentFormFocused;
    }

    public boolean isCommentFormFocused() {
        return this.commentFormFocused;
    }

    public void setCommentListStatus(CommentStatus status) {
        this.commentListStatus = status;
        if (status == CommentStatus.ALL) {
            this.commentFormDisplayed = true;
        }
    }

    public CommentStatus getCommentListStatus() {
        return this.commentListStatus;
    }

    public boolean commentListToggleable() {
        return this.comments.size() > LATEST_COMMENTS_SIZE;
    }

    public List<ExoSocialActivity> getComments() {
        if (this.commentListStatus == CommentStatus.ALL) {
            return this.comments;
        }
        if (this.commentListStatus == CommentStatus.NONE) {
            return new ArrayList<ExoSocialActivity>();
        }
        int commentsSize = this.comments.size();
        if (commentsSize > LATEST_COMMENTS_SIZE) {
            return this.comments.subList(commentsSize - LATEST_COMMENTS_SIZE, commentsSize);
        }
        return this.comments;
    }

    public List<ExoSocialActivity> getAllComments() {
        return this.comments;
    }

    public String[] getIdentityLikes() {
        return this.identityLikes;
    }

    public String[] getDisplayedIdentityLikes() throws Exception {
        if (this.isLiked()) {
            return (String[])ArrayUtils.removeElement((Object[])this.identityLikes, (Object)Utils.getViewerIdentity().getId());
        }
        return this.identityLikes;
    }

    public void setIdenityLikes(String[] identityLikes) {
        this.identityLikes = identityLikes;
    }

    public String event(String actionName, String callback, boolean updateForm) throws Exception {
        if (updateForm) {
            return super.url(actionName);
        }
        StringBuilder b = new StringBuilder();
        b.append("javascript:eXo.social.webui.UIForm.submitForm('").append(this.getFormId()).append("','");
        b.append(actionName).append("',");
        b.append(callback).append(",");
        b.append("true").append(")");
        return b.toString();
    }

    public String getPostedTimeString(WebuiBindingContext resourceBundle, long postedTime) throws Exception {
        long time = (new Date().getTime() - postedTime) / 1000L;
        if (time < 60L) {
            return resourceBundle.appRes("UIActivity.label.Less_Than_A_Minute");
        }
        if (time < 120L) {
            return resourceBundle.appRes("UIActivity.label.About_A_Minute");
        }
        if (time < 3600L) {
            long value = Math.round(time / 60L);
            return resourceBundle.appRes("UIActivity.label.About_?_Minutes").replaceFirst("\\{0\\}", String.valueOf(value));
        }
        if (time < 7200L) {
            return resourceBundle.appRes("UIActivity.label.About_An_Hour");
        }
        if (time < 86400L) {
            long value = Math.round(time / 3600L);
            return resourceBundle.appRes("UIActivity.label.About_?_Hours").replaceFirst("\\{0\\}", String.valueOf(value));
        }
        if (time < 172800L) {
            return resourceBundle.appRes("UIActivity.label.About_A_Day");
        }
        if (time < 2592000L) {
            long value = Math.round(time / 86400L);
            return resourceBundle.appRes("UIActivity.label.About_?_Days").replaceFirst("\\{0\\}", String.valueOf(value));
        }
        if (time < 5184000L) {
            return resourceBundle.appRes("UIActivity.label.About_A_Month");
        }
        long value = Math.round(time / 2592000L);
        return resourceBundle.appRes("UIActivity.label.About_?_Months").replaceFirst("\\{0\\}", String.valueOf(value));
    }

    public String getPostedTimeInSpaceString(WebuiBindingContext resourceBundle, long postedTime) throws Exception {
        long time = (new Date().getTime() - postedTime) / 1000L;
        if (time < 60L) {
            return resourceBundle.appRes("UIActivity.label.Less_Than_A_Minute_In_Space");
        }
        if (time < 120L) {
            return resourceBundle.appRes("UIActivity.label.About_A_Minute_In_Space");
        }
        if (time < 3600L) {
            long value = Math.round(time / 60L);
            return resourceBundle.appRes("UIActivity.label.About_?_Minutes_In_Space").replaceFirst("\\{0\\}", String.valueOf(value));
        }
        if (time < 7200L) {
            return resourceBundle.appRes("UIActivity.label.About_An_Hour_In_Space");
        }
        if (time < 86400L) {
            long value = Math.round(time / 3600L);
            return resourceBundle.appRes("UIActivity.label.About_?_Hours_In_Space").replaceFirst("\\{0\\}", String.valueOf(value));
        }
        if (time < 172800L) {
            return resourceBundle.appRes("UIActivity.label.About_A_Day_In_Space");
        }
        if (time < 2592000L) {
            long value = Math.round(time / 86400L);
            return resourceBundle.appRes("UIActivity.label.About_?_Days_In_Space").replaceFirst("\\{0\\}", String.valueOf(value));
        }
        if (time < 5184000L) {
            return resourceBundle.appRes("UIActivity.label.About_A_Month_In_Space");
        }
        long value = Math.round(time / 2592000L);
        return resourceBundle.appRes("UIActivity.label.About_?_Months_In_Space").replaceFirst("\\{0\\}", String.valueOf(value));
    }

    private String getFormId() {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        if (context instanceof PortletRequestContext) {
            return ((PortletRequestContext)context).getWindowId() + "#" + this.getId();
        }
        return this.getId();
    }

    protected void saveComment(String remoteUser, String message) throws Exception {
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl(Utils.getViewerIdentity().getId(), "exosocial:spaces", message, null);
        Utils.getActivityManager().saveComment(this.getActivity(), (ExoSocialActivity)comment);
        this.comments = Utils.getActivityManager().getComments(this.getActivity());
        this.setCommentListStatus(CommentStatus.ALL);
    }

    protected void setLike(boolean isLiked, String remoteUser) throws Exception {
        Identity viewerIdentity = Utils.getViewerIdentity();
        if (isLiked) {
            Utils.getActivityManager().saveLike(this.activity, viewerIdentity);
        } else {
            Utils.getActivityManager().removeLike(this.activity, viewerIdentity);
        }
        this.activity = Utils.getActivityManager().getActivity(this.activity.getId());
        this.setIdenityLikes(this.activity.getLikeIdentityIds());
    }

    public boolean isLiked() throws Exception {
        return ArrayUtils.contains((Object[])this.identityLikes, (Object)Utils.getViewerIdentity().getId());
    }

    protected void refresh() throws ActivityStorageException {
        this.activity = Utils.getActivityManager().getActivity(this.activity.getId());
        if (this.activity == null) {
            LOG.info((Object)"activity_ is null, not found. It can be deleted!");
            return;
        }
        this.comments = Utils.getActivityManager().getComments(this.activity);
        this.identityLikes = this.activity.getLikeIdentityIds();
    }

    public boolean isUserActivity(String id) {
        boolean isUserActivity = false;
        if (this.getOwnerIdentity() != null) {
            isUserActivity = this.getOwnerIdentity().getProviderId().equals("organization");
        }
        return isUserActivity;
    }

    public boolean isActivityDeletable() throws SpaceException {
        UIActivitiesContainer uiActivitiesContainer = (UIActivitiesContainer)this.getAncestorOfType(UIActivitiesContainer.class);
        UIComposer.PostContext postContext = uiActivitiesContainer.getPostContext();
        if (postContext == UIComposer.PostContext.SPACE) {
            Space space = uiActivitiesContainer.getSpace();
            SpaceService spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
            if (Utils.getViewerIdentity().equals((Object)this.getOwnerIdentity())) {
                return true;
            }
            return spaceService.isLeader(space, Utils.getOwnerRemoteId());
        }
        if (postContext == UIComposer.PostContext.USER) {
            UIUserActivitiesDisplay uiUserActivitiesDisplay = (UIUserActivitiesDisplay)this.getAncestorOfType(UIUserActivitiesDisplay.class);
            if (Utils.getViewerIdentity().equals((Object)this.getOwnerIdentity())) {
                return true;
            }
            if (uiUserActivitiesDisplay != null && uiUserActivitiesDisplay.isActivityStreamOwner()) {
                if (uiUserActivitiesDisplay.getSelectedDisplayMode() == UIUserActivitiesDisplay.DisplayMode.MY_STATUS) {
                    return true;
                }
                if (uiUserActivitiesDisplay.getSelectedDisplayMode() == UIUserActivitiesDisplay.DisplayMode.SPACE_UPDATES) {
                    return false;
                }
                return false;
            }
        }
        return false;
    }

    public boolean isActivityCommentAndLikable() throws Exception {
        UIUserActivitiesDisplay uiUserActivitiesDisplay;
        UIActivitiesContainer uiActivitiesContainer = (UIActivitiesContainer)this.getAncestorOfType(UIActivitiesContainer.class);
        UIComposer.PostContext postContext = uiActivitiesContainer.getPostContext();
        if (postContext == UIComposer.PostContext.USER && (uiUserActivitiesDisplay = (UIUserActivitiesDisplay)this.getAncestorOfType(UIUserActivitiesDisplay.class)) != null && !uiUserActivitiesDisplay.isActivityStreamOwner()) {
            String ownerName = uiUserActivitiesDisplay.getOwnerName();
            Identity ownerIdentity = Utils.getIdentityManager().getOrCreateIdentity("organization", ownerName, false);
            Relationship relationship = Utils.getRelationshipManager().get(ownerIdentity, Utils.getViewerIdentity());
            if (relationship == null) {
                return false;
            }
            if (relationship.getStatus() != Relationship.Type.CONFIRMED) {
                return false;
            }
        }
        return true;
    }

    public boolean isCommentDeletable(String activityUserId) throws SpaceException {
        UIActivitiesContainer uiActivitiesContainer = (UIActivitiesContainer)this.getAncestorOfType(UIActivitiesContainer.class);
        UIComposer.PostContext postContext = uiActivitiesContainer.getPostContext();
        try {
            UIUserActivitiesDisplay uiUserActivitiesDisplay;
            if (Utils.getViewerIdentity().getId().equals(activityUserId)) {
                return true;
            }
            if (postContext == UIComposer.PostContext.SPACE) {
                Space space = uiActivitiesContainer.getSpace();
                SpaceService spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
                return spaceService.isLeader(space, Utils.getOwnerRemoteId());
            }
            if (postContext == UIComposer.PostContext.USER && (uiUserActivitiesDisplay = (UIUserActivitiesDisplay)this.getAncestorOfType(UIUserActivitiesDisplay.class)) != null && uiUserActivitiesDisplay.isActivityStreamOwner()) {
                if (uiUserActivitiesDisplay.getSelectedDisplayMode() == UIUserActivitiesDisplay.DisplayMode.MY_STATUS) {
                    return true;
                }
                if (uiUserActivitiesDisplay.getSelectedDisplayMode() == UIUserActivitiesDisplay.DisplayMode.SPACE_UPDATES) {
                    return false;
                }
                return false;
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("can't not get remoteUserIdentity: remoteUser = " + Utils.getViewerRemoteId()));
        }
        return false;
    }

    public void setOwnerIdentity(Identity ownerIdentity) {
        this.ownerIdentity = ownerIdentity;
    }

    public Identity getOwnerIdentity() {
        return this.ownerIdentity;
    }

    protected boolean isSpaceStreamOwner() {
        Identity identityStreamOwner = Utils.getIdentityManager().getOrCreateIdentity("space", this.getActivity().getStreamOwner(), false);
        return identityStreamOwner != null;
    }

    protected boolean isUISpaceActivitiesDisplay() {
        return this.getParent().getParent().getParent() instanceof UISpaceActivitiesDisplay;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteCommentActionListener
    extends EventListener<BaseUIActivity> {
        public void execute(Event<BaseUIActivity> event) throws Exception {
            BaseUIActivity uiActivity = (BaseUIActivity)((Object)event.getSource());
            WebuiRequestContext requestContext = event.getRequestContext();
            Utils.getActivityManager().deleteComment(uiActivity.getActivity().getId(), requestContext.getRequestParameter("objectId"));
            uiActivity.refresh();
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiActivity);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteActivityActionListener
    extends EventListener<BaseUIActivity> {
        public void execute(Event<BaseUIActivity> event) throws Exception {
            BaseUIActivity uiActivity = (BaseUIActivity)((Object)event.getSource());
            Utils.getActivityManager().deleteActivity(uiActivity.getActivity().getId());
            UIActivitiesContainer activitiesContainer = (UIActivitiesContainer)uiActivity.getParent();
            activitiesContainer.removeChildById(uiActivity.getId());
            activitiesContainer.removeActivity(uiActivity.getActivity());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)activitiesContainer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PostCommentActionListener
    extends EventListener<BaseUIActivity> {
        public void execute(Event<BaseUIActivity> event) throws Exception {
            BaseUIActivity uiActivity = (BaseUIActivity)((Object)event.getSource());
            uiActivity.refresh();
            WebuiRequestContext requestContext = event.getRequestContext();
            UIFormTextAreaInput uiFormComment = (UIFormTextAreaInput)uiActivity.getChild(UIFormTextAreaInput.class);
            String message = (String)uiFormComment.getValue();
            uiFormComment.reset();
            uiActivity.saveComment(requestContext.getRemoteUser(), message);
            uiActivity.setCommentFormFocused(true);
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiActivity);
            uiActivity.getParent().broadcast(event, event.getExecutionPhase());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ToggleDisplayCommentFormActionListener
    extends EventListener<BaseUIActivity> {
        public void execute(Event<BaseUIActivity> event) throws Exception {
            BaseUIActivity uiActivity = (BaseUIActivity)((Object)event.getSource());
            if (uiActivity.isCommentFormDisplayed()) {
                uiActivity.setCommentFormDisplayed(false);
            } else {
                uiActivity.setCommentFormDisplayed(true);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiActivity);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetCommentListStatusActionListener
    extends EventListener<BaseUIActivity> {
        public void execute(Event<BaseUIActivity> event) throws Exception {
            BaseUIActivity uiActivity = (BaseUIActivity)((Object)event.getSource());
            uiActivity.refresh();
            String status = event.getRequestContext().getRequestParameter("objectId");
            CommentStatus commentListStatus = null;
            if (status.equals(CommentStatus.LATEST.getStatus())) {
                commentListStatus = CommentStatus.LATEST;
            } else if (status.equals(CommentStatus.ALL.getStatus())) {
                commentListStatus = CommentStatus.ALL;
            } else if (status.equals(CommentStatus.NONE.getStatus())) {
                commentListStatus = CommentStatus.NONE;
            }
            if (commentListStatus != null) {
                uiActivity.setCommentListStatus(commentListStatus);
            }
            uiActivity.setCommentFormDisplayed(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiActivity);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LikeActivityActionListener
    extends EventListener<BaseUIActivity> {
        public void execute(Event<BaseUIActivity> event) throws Exception {
            BaseUIActivity uiActivity = (BaseUIActivity)((Object)event.getSource());
            uiActivity.refresh();
            WebuiRequestContext requestContext = event.getRequestContext();
            String isLikedStr = requestContext.getRequestParameter("objectId");
            boolean isLiked = Boolean.parseBoolean(isLikedStr);
            uiActivity.setLike(isLiked, requestContext.getRemoteUser());
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiActivity);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ToggleDisplayLikesActionListener
    extends EventListener<BaseUIActivity> {
        public void execute(Event<BaseUIActivity> event) throws Exception {
            BaseUIActivity uiActivity = (BaseUIActivity)((Object)event.getSource());
            uiActivity.refresh();
            if (uiActivity.isLikesDisplayed()) {
                uiActivity.setLikesDisplayed(false);
            } else {
                uiActivity.setLikesDisplayed(true);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiActivity);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CommentStatus {
        LATEST("latest"),
        ALL("all"),
        NONE("none");

        private String commentStatus;

        public String getStatus() {
            return this.commentStatus;
        }

        private CommentStatus(String status) {
            this.commentStatus = status;
        }
    }
}

