/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.profile;

import org.apache.commons.lang.StringEscapeUtils;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.profile.UIProfile;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;

@ComponentConfig(lifecycle=UIFormLifecycle.class)
public abstract class UIProfileSection
extends UIForm {
    private boolean isEditMode;

    public Profile getProfile() throws Exception {
        UIProfile uiProfile = (UIProfile)this.getAncestorOfType(UIProfile.class);
        return uiProfile.getProfile();
    }

    public boolean isEditMode() {
        return this.isEditMode;
    }

    public void setEditMode(boolean editMode) {
        this.isEditMode = editMode;
    }

    public boolean isEditable() {
        UIProfile pp = (UIProfile)this.getAncestorOfType(UIProfile.class);
        return pp.isEditable();
    }

    public String escapeHtml(String value) {
        return StringEscapeUtils.escapeHtml((String)value);
    }

    public User getViewUser() throws Exception {
        if (!Utils.isOwner()) {
            UserHandler userHandler = ((OrganizationService)this.getApplicationComponent(OrganizationService.class)).getUserHandler();
            return userHandler.findUserByName(Utils.getOwnerRemoteId());
        }
        ConversationState state = ConversationState.getCurrent();
        return (User)state.getAttribute("UserProfile");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UIProfileSection> {
        public void execute(Event<UIProfileSection> event) throws Exception {
            UIProfileSection sect = (UIProfileSection)((Object)event.getSource());
            sect.setEditMode(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)sect);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIProfileSection> {
        public void execute(Event<UIProfileSection> event) throws Exception {
            UIProfileSection sect = (UIProfileSection)((Object)event.getSource());
            sect.setEditMode(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)sect);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditActionListener
    extends EventListener<UIProfileSection> {
        public void execute(Event<UIProfileSection> event) throws Exception {
            UIProfileSection sect = (UIProfileSection)((Object)event.getSource());
            sect.setEditMode("true".equals(event.getRequestContext().getRequestParameter("objectId")));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)sect);
        }
    }
}

