/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.javascript;

import java.io.Reader;
import java.io.StringReader;
import javax.jcr.Node;
import org.exoplatform.portal.resource.Resource;
import org.exoplatform.portal.resource.ResourceResolver;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.javascript.JavascriptConfigService;

public class WCMJavascriptResourceResolver
implements ResourceResolver {
    private static Log log = ExoLogger.getLogger((String)"wcm:WCMJavascriptResourceResolver");
    private LivePortalManagerService livePortalManagerService_;
    private JavascriptConfigService javascriptConfigService_;

    public WCMJavascriptResourceResolver(LivePortalManagerService livePortalManagerService, JavascriptConfigService javascriptConfigService) {
        this.livePortalManagerService_ = livePortalManagerService;
        this.javascriptConfigService_ = javascriptConfigService;
    }

    public Resource resolve(String path) throws NullPointerException {
        if (!path.matches("/(.*)/javascript/eXo/(.*)/live")) {
            return null;
        }
        String[] elements = path.split("/");
        String portalName = elements[4];
        try {
            Node portalNode = this.livePortalManagerService_.getLivePortal(WCMCoreUtils.getSystemSessionProvider(), portalName);
            final String jsData = WCMCoreUtils.getSiteGlobalActiveJs(portalNode);
            if (jsData == null) {
                return null;
            }
            return new Resource(path){

                public Reader read() {
                    return new StringReader(jsData);
                }
            };
        }
        catch (Exception e) {
            log.error((Object)"Unexpected error happens", (Throwable)e);
            return null;
        }
    }
}

