/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.ispn;

import java.io.IOException;
import java.io.Serializable;
import javax.jcr.RepositoryException;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.jcr.config.QueryHandlerEntry;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.impl.core.query.ChangesFilterListsWrapper;
import org.exoplatform.services.jcr.impl.core.query.IndexerChangesFilter;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoModeHandler;
import org.exoplatform.services.jcr.impl.core.query.IndexingTree;
import org.exoplatform.services.jcr.impl.core.query.LocalIndexMarker;
import org.exoplatform.services.jcr.impl.core.query.QueryHandler;
import org.exoplatform.services.jcr.impl.core.query.SearchManager;
import org.exoplatform.services.jcr.impl.core.query.ispn.AbstractIndexerCacheStore;
import org.exoplatform.services.jcr.impl.core.query.ispn.ChangesKey;
import org.exoplatform.services.jcr.impl.core.query.ispn.LocalIndexCacheStore;
import org.exoplatform.services.jcr.infinispan.ISPNCacheFactory;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.loaders.CacheLoaderManager;

public class LocalIndexChangesFilter
extends IndexerChangesFilter
implements LocalIndexMarker {
    private final Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.LocalIndexChangesFilter");
    public static final String PARAM_INFINISPAN_CACHESTORE_CLASS = "infinispan-cachestore-classname";
    private final Cache<Serializable, Object> cache;
    private final String wsId;

    public LocalIndexChangesFilter(SearchManager searchManager, SearchManager parentSearchManager, QueryHandlerEntry config, IndexingTree indexingTree, IndexingTree parentIndexingTree, QueryHandler handler, QueryHandler parentHandler, ConfigurationManager cfm) throws IOException, RepositoryException, RepositoryConfigurationException {
        super(searchManager, parentSearchManager, config, indexingTree, parentIndexingTree, handler, parentHandler, cfm);
        this.wsId = searchManager.getWsId();
        ISPNCacheFactory factory = new ISPNCacheFactory(cfm);
        config.putParameterValue(PARAM_INFINISPAN_CACHESTORE_CLASS, LocalIndexCacheStore.class.getName());
        this.cache = factory.createCache("Indexer_" + searchManager.getWsId(), config);
        CacheLoaderManager cacheLoaderManager = (CacheLoaderManager)this.cache.getAdvancedCache().getComponentRegistry().getComponent(CacheLoaderManager.class);
        AbstractIndexerCacheStore cacheStore = (AbstractIndexerCacheStore)cacheLoaderManager.getCacheLoader();
        cacheStore.register(searchManager, parentSearchManager, handler, parentHandler);
        IndexerIoModeHandler modeHandler = cacheStore.getModeHandler();
        handler.setIndexerIoModeHandler(modeHandler);
        parentHandler.setIndexerIoModeHandler(modeHandler);
        if (!parentHandler.isInitialized()) {
            parentHandler.init();
        }
        if (!handler.isInitialized()) {
            handler.init();
        }
    }

    protected Log getLogger() {
        return this.log;
    }

    protected void doUpdateIndex(ChangesFilterListsWrapper changes) {
        ChangesKey changesKey = new ChangesKey(this.wsId, IdGenerator.generate());
        this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_LOCKING});
        this.cache.put((Object)changesKey, (Object)changes);
    }
}

