/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.activity;

import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.webui.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpaceActivityListAccess
implements ListAccess<ExoSocialActivity> {
    private static final Log LOG = ExoLogger.getLogger(SpaceActivityListAccess.class);
    private Space space;
    private Identity spaceIdentity = null;

    public SpaceActivityListAccess(Space space) {
        this.space = space;
        try {
            this.spaceIdentity = Utils.getIdentityManager().getOrCreateIdentity("space", space.getName());
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
    }

    public int getSize() throws Exception {
        return Utils.getActivityManager().getActivitiesCount(this.spaceIdentity);
    }

    public ExoSocialActivity[] load(int index, int length) throws Exception {
        Object[] objects = Utils.getActivityManager().getActivities(this.spaceIdentity, (long)index, (long)length).toArray();
        ExoSocialActivity[] results = new ExoSocialActivity[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            results[i] = (ExoSocialActivity)objects[i];
        }
        return results;
    }
}

