/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringEscapeUtils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.UIAvatarUploadContent;
import org.exoplatform.social.webui.UIAvatarUploader;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.space.UISpaceSetting;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.ExpressionValidator;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.StringLengthValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/social/webui/space/UISpaceInfo.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}, phase=Event.Phase.PROCESS), @EventConfig(listeners={ChangeAvatarActionListener.class})})
public class UISpaceInfo
extends UIForm {
    private static final String SPACE_PRIORITY = "priority";
    private static final String PRIORITY_HIGH = "high";
    private static final String PRIORITY_IMMEDIATE = "immediate";
    private static final String PRIORITY_LOW = "low";
    private static final String SPACE_ID = "id";
    private static final String SPACE_DISPLAY_NAME = "displayName";
    private static final String SPACE_DESCRIPTION = "description";
    private SpaceService spaceService = null;
    private final String POPUP_AVATAR_UPLOADER = "UIPopupAvatarUploader";
    private static final String MSG_DEFAULT_SPACE_DESCRIPTION = "UISpaceAddForm.msg.default_space_description";

    public UISpaceInfo() throws Exception {
        this.addUIFormInput((UIFormInput)((UIFormStringInput)new UIFormStringInput(SPACE_ID, SPACE_ID, null).setRendered(false)));
        UIFormStringInput spaceDisplayNameInput = new UIFormStringInput(SPACE_DISPLAY_NAME, SPACE_DISPLAY_NAME, null);
        spaceDisplayNameInput.setEditable(false);
        this.addUIFormInput((UIFormInput)spaceDisplayNameInput.addValidator(MandatoryValidator.class, new Object[0]).addValidator(ExpressionValidator.class, new Object[]{"^([\\p{L}\\d]+[\\s]?)+$", "UISpaceInfo.msg.name-invalid"}).addValidator(StringLengthValidator.class, new Object[]{3, 30}));
        this.addUIFormInput((UIFormInput)new UIFormTextAreaInput(SPACE_DESCRIPTION, SPACE_DESCRIPTION, null).addValidator(StringLengthValidator.class, new Object[]{0, 255}));
        ArrayList<SelectItemOption> priorityList = new ArrayList<SelectItemOption>(3);
        SelectItemOption pHigh = new SelectItemOption(PRIORITY_HIGH, (Object)"1");
        SelectItemOption pImmediate = new SelectItemOption(PRIORITY_IMMEDIATE, (Object)"2");
        SelectItemOption pLow = new SelectItemOption(PRIORITY_LOW, (Object)"3");
        priorityList.add(pHigh);
        priorityList.add(pImmediate);
        priorityList.add(pLow);
        UIFormSelectBox selectPriority = new UIFormSelectBox(SPACE_PRIORITY, SPACE_PRIORITY, priorityList);
        this.addUIFormInput((UIFormInput)selectPriority);
        this.addUIFormInput((UIFormInput)((UIFormStringInput)new UIFormStringInput("tag", "tag", null).setRendered(false)));
        UIPopupWindow uiPopup = (UIPopupWindow)this.createUIComponent(UIPopupWindow.class, null, "UIPopupAvatarUploader");
        uiPopup.setWindowSize(500, 0);
        this.addChild((UIComponent)uiPopup);
    }

    public void setValue(Space space) throws Exception {
        this.invokeGetBindingBean(space);
        this.getUIStringInput("tag").setValue((Object)space.getTag());
    }

    public void saveAvatar(UIAvatarUploadContent uiAvatarUploadContent, Space space) throws Exception {
        SpaceService spaceService = this.getSpaceService();
        space.setAvatarAttachment(uiAvatarUploadContent.getAvatarAttachment());
        spaceService.updateSpace(space);
        spaceService.updateSpaceAvatar(space);
    }

    protected String getImageSource() throws Exception {
        SpaceService spaceService = this.getSpaceService();
        String id = (String)this.getUIStringInput(SPACE_ID).getValue();
        Space space = spaceService.getSpaceById(id);
        return space.getAvatarUrl();
    }

    public SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        }
        return this.spaceService;
    }

    public OrganizationService getOrganizationService() {
        return (OrganizationService)this.getApplicationComponent(OrganizationService.class);
    }

    public DataStorage getDataSource() {
        return (DataStorage)this.getApplicationComponent(DataStorage.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeAvatarActionListener
    extends EventListener<UISpaceInfo> {
        public void execute(Event<UISpaceInfo> event) throws Exception {
            UISpaceInfo uiSpaceInfo = (UISpaceInfo)((Object)event.getSource());
            UIPopupWindow uiPopup = (UIPopupWindow)uiSpaceInfo.getChild(UIPopupWindow.class);
            UIAvatarUploader uiAvatarUploader = (UIAvatarUploader)uiSpaceInfo.createUIComponent(UIAvatarUploader.class, null, null);
            uiPopup.setUIComponent((UIComponent)uiAvatarUploader);
            uiPopup.setShow(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UISpaceInfo> {
        public void execute(Event<UISpaceInfo> event) throws Exception {
            boolean nameChanged;
            UISpaceInfo uiSpaceInfo = (UISpaceInfo)((Object)event.getSource());
            SpaceService spaceService = uiSpaceInfo.getSpaceService();
            UIPortal uiPortal = Util.getUIPortal();
            PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
            WebuiRequestContext requestContext = event.getRequestContext();
            UIApplication uiApp = requestContext.getUIApplication();
            String id = (String)uiSpaceInfo.getUIStringInput(UISpaceInfo.SPACE_ID).getValue();
            String name = (String)uiSpaceInfo.getUIStringInput(UISpaceInfo.SPACE_DISPLAY_NAME).getValue();
            Space space = spaceService.getSpaceById(id);
            if (space == null) {
                portalRequestContext.getResponse().sendRedirect(Utils.getURI("all-spaces"));
                return;
            }
            String spaceUrl = space.getUrl();
            UserNode selectedNode = uiPortal.getSelectedUserNode();
            UserNode homeNode = null;
            boolean bl = nameChanged = !space.getDisplayName().equals(name);
            if (nameChanged) {
                String cleanedString = SpaceUtils.cleanString((String)name);
                if (spaceService.getSpaceByUrl(cleanedString) != null) {
                    uiApp.addMessage(new ApplicationMessage("UISpaceInfo.msg.current-name-exist", null, 2));
                    return;
                }
                UserPortalConfig userPortalConfig = Util.getUIPortalApplication().getUserPortalConfig();
                UserPortal userPortal = userPortalConfig.getUserPortal();
                List pageNavigations = userPortal.getNavigations();
                space.setUrl(cleanedString);
                UserNavigation spaceNavigation = SpaceUtils.getGroupNavigation((String)space.getGroupId());
                for (UserNavigation pageNavigation : pageNavigations) {
                    if (!pageNavigation.getKey().getName().equals(spaceNavigation.getKey().getName())) continue;
                    spaceNavigation = pageNavigation;
                    break;
                }
                if ((homeNode = SpaceUtils.getHomeNodeWithChildren((UserNavigation)spaceNavigation, (String)spaceUrl)) == null) {
                    throw new Exception("homeNode is null!");
                }
                SpaceUtils.changeSpaceUrlPreference((UserNode)homeNode, (Space)space, (String)name);
                homeNode.setName(cleanedString);
                homeNode.setLabel(name);
                Collection childNodes = homeNode.getChildren();
                while (childNodes.iterator().hasNext()) {
                    UserNode childNode = (UserNode)childNodes.iterator().next();
                    SpaceUtils.changeSpaceUrlPreference((UserNode)childNode, (Space)space, (String)name);
                    String oldUri = childNode.getURI();
                    String newUri = oldUri.replace(oldUri.substring(0, oldUri.lastIndexOf("/")), cleanedString);
                    childNode.setName(newUri.substring(newUri.lastIndexOf("/") + 1, newUri.length()));
                    if (!selectedNode.getName().equals(childNode.getName())) continue;
                    selectedNode = childNode;
                }
                userPortalConfig.getUserPortal().saveNode(homeNode, null);
                SpaceUtils.setNavigation((UserNavigation)spaceNavigation);
            }
            uiSpaceInfo.invokeSetBindingBean(space);
            String spaceDescription = space.getDescription();
            if (spaceDescription == null || spaceDescription.trim().length() == 0) {
                ResourceBundle resourceBundle = requestContext.getApplicationResourceBundle();
                space.setDescription(resourceBundle.getString(UISpaceInfo.MSG_DEFAULT_SPACE_DESCRIPTION));
                uiSpaceInfo.getUIFormTextAreaInput(UISpaceInfo.SPACE_DESCRIPTION).setValue((Object)space.getDescription());
            } else {
                space.setDescription(StringEscapeUtils.escapeHtml((String)space.getDescription()));
            }
            spaceService.updateSpace(space);
            if (nameChanged) {
                UISpaceSetting uiSpaceSetting = (UISpaceSetting)uiSpaceInfo.getAncestorOfType(UISpaceSetting.class);
                portalRequestContext.getResponse().sendRedirect(Utils.getSpaceURL(selectedNode));
                return;
            }
            uiApp.addMessage(new ApplicationMessage("UISpaceInfo.msg.update-success", null, 2));
        }
    }
}

