/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.service;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.protocol.HandlerPreconditions;
import org.apache.shindig.protocol.Operation;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.protocol.RequestItem;
import org.apache.shindig.protocol.Service;
import org.apache.shindig.social.opensocial.model.Album;
import org.apache.shindig.social.opensocial.service.SocialRequestItem;
import org.apache.shindig.social.opensocial.spi.AlbumService;
import org.apache.shindig.social.opensocial.spi.CollectionOptions;
import org.apache.shindig.social.opensocial.spi.UserId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="albums", path="/{userId}+/{groupId}/{albumId}+")
public class AlbumHandler {
    private final AlbumService service;
    private final ContainerConfig config;

    @Inject
    public AlbumHandler(AlbumService service, ContainerConfig config) {
        this.service = service;
        this.config = config;
    }

    @Operation(httpMethods={"POST"}, bodyParam="album")
    public Future<?> create(SocialRequestItem request) throws ProtocolException {
        Set<UserId> userIds = request.getUsers();
        List albumIds = request.getListParameter("albumId");
        HandlerPreconditions.requireNotEmpty(userIds, (String)"No userId specified");
        HandlerPreconditions.requireSingular(userIds, (String)"Multiple userIds not supported");
        HandlerPreconditions.requireEmpty((Collection)albumIds, (String)"Cannot specify albumId in create");
        return this.service.createAlbum((UserId)Iterables.getOnlyElement(userIds), request.getAppId(), (Album)request.getTypedParameter("album", Album.class), request.getToken());
    }

    @Operation(httpMethods={"GET"})
    public Future<?> get(SocialRequestItem request) throws ProtocolException {
        Set<UserId> userIds = request.getUsers();
        ImmutableSet optionalAlbumIds = ImmutableSet.copyOf((Collection)request.getListParameter("albumId"));
        HandlerPreconditions.requireNotEmpty(userIds, (String)"No userId specified");
        if (userIds.size() > 1 && !optionalAlbumIds.isEmpty()) {
            throw new IllegalArgumentException("Cannot fetch same albumIds for multiple userIds");
        }
        if (!optionalAlbumIds.isEmpty()) {
            if (optionalAlbumIds.size() == 1) {
                return this.service.getAlbum((UserId)Iterables.getOnlyElement(userIds), request.getAppId(), request.getFields(), (String)optionalAlbumIds.iterator().next(), request.getToken());
            }
            return this.service.getAlbums((UserId)Iterables.getOnlyElement(userIds), request.getAppId(), request.getFields(), new CollectionOptions((RequestItem)request), (Set<String>)optionalAlbumIds, request.getToken());
        }
        return this.service.getAlbums(userIds, request.getGroup(), request.getAppId(), request.getFields(), new CollectionOptions((RequestItem)request), request.getToken());
    }

    @Operation(httpMethods={"PUT"}, bodyParam="album")
    public Future<?> update(SocialRequestItem request) throws ProtocolException {
        Set<UserId> userIds = request.getUsers();
        List albumIds = request.getListParameter("albumId");
        HandlerPreconditions.requireNotEmpty(userIds, (String)"No userId specified");
        HandlerPreconditions.requireSingular(userIds, (String)"Multiple userIds not supported");
        HandlerPreconditions.requireNotEmpty((Collection)albumIds, (String)"No albumId specified");
        HandlerPreconditions.requireSingular((Collection)albumIds, (String)"Multiple albumIds not supported");
        return this.service.updateAlbum((UserId)Iterables.getOnlyElement(userIds), request.getAppId(), (Album)request.getTypedParameter("album", Album.class), (String)Iterables.getOnlyElement((Iterable)albumIds), request.getToken());
    }

    @Operation(httpMethods={"DELETE"})
    public Future<?> delete(SocialRequestItem request) throws ProtocolException {
        Set<UserId> userIds = request.getUsers();
        String albumId = request.getParameter("albumId");
        HandlerPreconditions.requireNotEmpty(userIds, (String)"No userId specified");
        HandlerPreconditions.requireSingular(userIds, (String)"Multiple userIds not supported");
        return this.service.deleteAlbum((UserId)Iterables.getOnlyElement(userIds), request.getAppId(), albumId, request.getToken());
    }

    @Operation(httpMethods={"GET"}, path="/@supportedFields")
    public List<Object> supportedFields(RequestItem request) {
        String container = (String)Objects.firstNonNull((Object)request.getToken().getContainer(), (Object)"default");
        return this.config.getList(container, "${Cur['gadgets.features'].opensocial.supportedFields.album}");
    }
}

