/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.organization.injector;

import java.io.File;
import java.io.FileOutputStream;
import java.util.zip.ZipOutputStream;
import org.exoplatform.management.annotations.Impact;
import org.exoplatform.management.annotations.ImpactType;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.management.rest.annotations.RESTEndpoint;
import org.exoplatform.platform.organization.injector.DataInjectorService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

@Managed
@ManagedDescription(value="Platform Organization Data Injector Service")
@NameTemplate(value={@Property(key="name", value="OrganizationDataInjectorService"), @Property(key="service", value="extensions"), @Property(key="type", value="platform")})
@RESTEndpoint(path="orgsync")
public class JMXDataInjector
implements Startable {
    private static final Log logger_ = ExoLogger.getLogger(JMXDataInjector.class);
    private DataInjectorService dataInjectorService;

    public JMXDataInjector(DataInjectorService dataInjectorService) {
        this.dataInjectorService = dataInjectorService;
    }

    @Managed
    @ManagedDescription(value="extract Organization Data to a zip file")
    @Impact(value=ImpactType.READ)
    public void extractData(@ManagedDescription(value="exported file path") @ManagedName(value="filePath") String filePath) throws Exception {
        if (filePath == null || filePath.isEmpty() || !filePath.endsWith(".zip")) {
            throw new IllegalArgumentException(filePath + " have to point into a zip file.");
        }
        File targetFile = new File(filePath);
        if (targetFile.exists()) {
            throw new IllegalArgumentException(filePath + " already exists.");
        }
        logger_.info((Object)("Extracting Organization model data to : " + filePath));
        FileOutputStream out = new FileOutputStream(filePath);
        ZipOutputStream zos = new ZipOutputStream(out);
        this.dataInjectorService.writeProfiles(zos);
        this.dataInjectorService.writeUsers(zos);
        this.dataInjectorService.writeOrganizationModelData(zos);
        zos.close();
        logger_.info((Object)"Organization model data successfully exported.");
    }

    @Managed
    @ManagedDescription(value="inject Organization Data from a zip file")
    @Impact(value=ImpactType.READ)
    public void injectData(@ManagedDescription(value="path to zip file") @ManagedName(value="filePath") String filePath) {
        if (filePath == null || filePath.isEmpty() || !filePath.endsWith(".zip")) {
            throw new IllegalArgumentException(filePath + " have to point into a zip file.");
        }
        try {
            this.dataInjectorService.readDataPlugins(filePath);
            this.dataInjectorService.readUsersData(filePath);
            this.dataInjectorService.readUserProfilesData(filePath);
            this.dataInjectorService.doImport(true);
        }
        catch (Exception e) {
            logger_.error((Object)"Can not import users profile .. ", (Throwable)e);
        }
        logger_.info((Object)"Organization model data successfully imported.");
    }

    public void start() {
    }

    public void stop() {
    }
}

