/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.jsdoc;

import com.google.caja.ancillary.jsdoc.Updoc;
import com.google.caja.ancillary.jsdoc.UpdocParser;
import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.ParseException;
import com.google.caja.util.CajaTestCase;
import com.google.caja.util.MoreAsserts;
import com.google.caja.util.TestUtil;
import java.util.Arrays;

public class UpdocParserTest
extends CajaTestCase {
    public final void testParse1() throws Exception {
        this.assertParsed("$ Math.abs(-5)\n# 5", "Updoc", "  Run", "    SpecialOperation : FUNCTION_CALL", "      SpecialOperation : MEMBER_ACCESS", "        Reference", "          Identifier : Math", "        Reference", "          Identifier : abs", "      SimpleOperation : NEGATION", "        IntegerLiteral : 5", "    IntegerLiteral : 5");
    }

    public final void testParse2() throws Exception {
        this.assertParsed("$ Math.abs(0)\n# 0\n$ abs(\n      0 / 0)\n# NaN", "Updoc", "  Run", "    SpecialOperation : FUNCTION_CALL", "      SpecialOperation : MEMBER_ACCESS", "        Reference", "          Identifier : Math", "        Reference", "          Identifier : abs", "      IntegerLiteral : 0", "    IntegerLiteral : 0", "  Run", "    SpecialOperation : FUNCTION_CALL", "      Reference", "        Identifier : abs", "      SimpleOperation : DIVISION", "        IntegerLiteral : 0", "        IntegerLiteral : 0", "    Reference", "      Identifier : NaN");
    }

    public final void testRender() throws Exception {
        UpdocParserTest.assertEquals((String)"$ Math.abs(0);\n# 0;\n$ abs(0 / 0);\n# NaN;", (String)UpdocParserTest.render(this.updoc(this.fromString("$ Math.abs( 0 )\n# 0\n// comments can appear in updoc too\n$ abs(0/0)\n# NaN"))));
    }

    private void assertParsed(String input, String ... golden) throws ParseException {
        MoreAsserts.assertListsEqual(Arrays.asList(golden), Arrays.asList(TestUtil.format(this.updoc(this.fromString(input))).split("\r\n?|\n")));
    }

    private Updoc updoc(CharProducer cp) throws ParseException {
        UpdocParser p = new UpdocParser(this.mq);
        return p.parseComplete(cp);
    }
}

